.\" Process this file with
.\" groff -man -Tutf8 akfgopherserver.de.man
.\"
.
.TH "akfgopherserver" 1 2025-10-21 akfnetz
.nh
.
.\" Makros .TQ .EX .EE aus groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.de TQ
.br
.ns
.TP \\$1
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.SH NAME
akfgopherserver \- Gopher-Server
.
.SH SYNTAX
.BI "akfgopherserver [" Optionen ]
.
.SH BESCHREIBUNG
.
Das Programm
.B akfgopherserver
ist ein Server f\[:u]r das Gopher-Protokoll (nicht Gopher+).
.PP
Gopher ist ein simples Internet-Protokoll, welches haupts\[:a]chlich
daf\[:u]r benutzt wird, um Informationen in Form von einfachen Textdateien
\[:u]ber das Netz zur Verf\[:u]gung zu stellen.
Andere Dateien k\[:o]nnen zum Herunterladen angeboten werden.
.PP
Dieser Server kann von normalen Benutzern bei Bedarf gestartet werden.
Er antwortet per Voreinstellung nur auf Zugriffe von lokalen Netzen,
w\[:a]hrend er Zugriffe aus dem Internet blockiert.
.PP
Wenn dieser Server von einem normalen, nicht privilegierten Benutzer
aufgerufen wird, verwendet er den Port
.BR 7070 .
Dieser Port muss dann auch beim Abruf im Client explizit mit
angegeben werden.
Zum Beispiel:
.BR gopher://localhost:7070 .
.PP
Wenn das Programm in einem Terminal im Vordergrund l\[:a]uft,
kann man es einfach mit der Tastenkombination
.BR [Strg] + [C]
abbrechen.
Ansonsten kann man es auch \[:u]ber die Befehle
.BR killall (1)
oder
.BR kill (1)
beenden.
.PP
.
.SH OPTIONEN
.
.TP
-h
.TQ
--help
.TQ
--Hilfe
Zeigt eine kurze Hilfe an.
.TP
-V
.TQ
--version
.TQ
--Version
Zeigt die Version an.
.PP
.TP
-t
.TQ
--text
unbekannte Dateinamen sollten als Textdateien interpretiert werden 
(Typ 0).
Ansonsten sind es Bin\[:a]rdateien (Typ 9).
.PP
.TP
.RI "-d " Verzeichnis
.TQ
.RI --directory= Verzeichnis
.TQ
.RI --Verzeichnis= Verzeichnis
Legt das angegebene
.I Verzeichnis
als Wurzelverzeichnis fest.
Ohne diese Angabe wird das Verzeichnis, in dem das Programm gestartet
wurde zum Wurzelverzeichnis.
.PP
.TP
.RI "-N " Servername
.TQ
.RI --Servername= Servername
.TQ
.RI --servername= Servername
Legt den
.IR Servername n
fest.
.IP
Internationale Domainnamen m\[:u]ssen in ASCII-kompatibler Schreibweise (ACE)
angegeben werden.
.PP
.TP
.RI "-p " Portnummer
.TQ
.RI --port= Portnummer
.TQ
.RI --Port= Portnummer
Legt die
.I Portnummer
fest.
Dies ist der Port auf dem dieser Server lauscht.
.PP
.TP
.RI --Serverport= Portnummer
.TQ
.RI --serverport= Portnummer
Legt eine nominelle andere
.I Portnummer
fest.
Falls der Server \[:u]ber ein Frontend gesteuert wird,
kann man hiermit dessen Portnummer angeben.
.PP
.TP
-l
.TQ
--localhost
H\[:o]rt nur auf die
.BR localhost -Adresse
f\[:u]r IPv4.
Das ist
.BR 127.0.0.1 .
Damit sollte der Server nur von dem selben Rechner aus erreichbar sein.
.PP
.TP
.RI "-a " IP-Adresse
.TQ
.RI --address= IP-Adresse
.TQ
.RI --Adresse= IP-Adresse
Bindet den Server an die angegebene
.IR IP-Adresse .
.IP
Dieses kann man nutzen, um die Erreichbarkeit auf ein lokales Netzwerk
zu begrenzen.
Das ist sicherer, als der eingebaute Filter.
.PP
.TP
-4
.TQ
--IPv4
IPv4 verwenden.
.PP
.TP
-6
.TQ
--IPv6
IPv6 verwenden. (Vorgabe)
.br
Der Server beh\[:a]lt sich jedoch das Anrecht vor, die Verbindung nach
Gutd\[:u]nken zu einem gemeinen IPv4 zu degradieren.
.IP
Ob im IPv6-Modus auch IPv4-Verbindungen unterst\[:u]tzt werden,
h\[:a]ngt vom Betriebssystem und eventuell dessen Einstellungen ab.
.PP
.TP
.RI "-u " Nutzerkennung
.TQ
.RI --Nutzer= Nutzerkennung
Wenn der Server mit root-Rechten gestartet wird (reale Nutzerkennung),
kann man \[:u]ber diese Option eine andere
.I Nutzerkennung
angeben, mit deren Rechten er letztendlich laufen soll.
Die
.I Nutzerkennung
kann ein Name, oder eine nummerische Angabe sein.
.PP
.TP
-D
.TQ
--daemon
Startet den Server als Daemon im Hintergrund.
.PP
.TP
--open
.TQ
--offen
.TQ
--Internet
\[:o]ffnet den Server f\[:u]r das gasamte Internet
.IP
.B Vorsicht!
Das schaltet den Filter f\[:u]r private Netzwerke ab.
Der Server ist dann auch \[:u]ber das Internet erreichbar.
Man muss daf\[:u]r eventuell auch den Port an seinem Router freigeben.
.PP
.TP
-i
.TQ
--inetd
Nimmt Anfragen auf der Standardeingabe entgegen
und gibt Antworten auf der Standardausgabe aus.
Wenn die Standardeingabe ein Socket ist, k\[:o]nnen daraus die
Verbindungsdaten ausgelesen werden.
.PP
.
.SH UMGEBUNGSVARIABLEN
.
.TP
HOSTNAME, HOST
Falls diese Variable gesetzt ist, wird das als Servername genommen.
.PP
.TP
LC_ALL, LC_MESSAGES, LANG
diese Variablen beeinflussen die Sprachauswahl f\[:u]r den Bildschirm.
.PP
.
.SH NOTIZEN
.
.SS Dateien
.
Dateien, die keinen Punkt im Namen haben (und nicht ausf\[:u]hrbar sind) werden 
als Textdateien erkannt.
Man kann auch die Dateierweiterungen
.BR .text " oder " .txt
verwenden.
Diese Dateiendungen werden nicht angezeigt
und Unterstriche werden in Leerzeichen umgewandelt.
.PP
Dateien in der Markdown-Formatierung mit der Erweiterung
.BR .md " oder " .markdown
werden ebenfalls als Textdateien anerkannt.
.PP
F\[:u]r Gopher m\[:u]ssen Textdateien weniger als 80 Zeichen pro Zeile
haben.
Daf\[:u]r ist der Befehl
.BR fmt (1)
n\[:u]tzlich.
.PP
Es werden viele weitere Dateierweiterungen f\[:u]r verschiedene Dateiformate 
erkannt.
.PP
Dateien, deren Name mit einem Punkt beginnt, sind versteckt,
k\[:o]nnen aber abgerufen werden.
Das selbe gilt f\[:u]r Verzeichnisse.
.
.SS Verzeichnisse
.
F\[:u]r Verzeichnisse kann man einen anderen Anzeigenamen
angeben, indem man eine Datei namens
.B gophertag
anlegt.
So kann man den Pfad kurz halten und dennoch eine vern\[:u]nftige Anzeige 
bekommen.
Zum Beispiel, gehe in ein Verzeichnis namens
.B rel/
und gib da folgendes ein:
.br
.B  $ echo 'Religi\[:o]se Schriften' > gophertag
.PP
Normalerweise wird das Men\[:u] automatisch durch Dateiauflistung erstellt.
.PP
.
.SS Men\[:u]s
.
Man kann auch eigene Men\[:u]s erstellen.
Das sieht nicht nur besser aus, sondern ist f\[:u]r etliche
M\[:o]glichkeiten von Gopher unumg\[:a]nglich.
.PP
Um eigene Men\[:u]s zu erstellen muss in einem Verzeichnis
eine Datei namens
.B gophermap
erstellt werden.
Grunds\[:a]tzlich stellt jede Zeile einen Men\[:u]-Eintrag dar.
Jedoch sind Zeilen, die mit einer Raute (#) beginnen, Kommentare und
werden ignoriert.
Zeilen, die kein <TAB>-Zeichen enthalten werden zu Informationszeilen
('i'). Dies gilt auch f\[:u]r Leerzeilen.
Informationszeilen sollten keine wichtigen Inhalte transportieren,
da diese vom Client ignoriert werden d\[:u]rfen.
Inhalte sollten in Textdateien stehen.
.PP
Das Format einer
.BR gophermap -Zeile
ist wie folgt:
.br
.IR xName <TAB> Selektor <TAB> Host <TAB> Port
.PP
.TP
.I x
ist der Gopher-Typ
(siehe Abschnitt
.BR Gopher-Typen ).
.TP
.I Name
ist eine Beschreibung des Eintrags
.TP
.I Selektor
ist der Pfad zum Inhalt
.TP
.I Host
ist der Hostname
.TP
.I Port
ist die Port-Nummer
.PP
Wenn man den Host und den Port nicht angibt, wird daf\[:u]r der eigene
Server eingetragen.
In diesem Fall reicht es auch, als Selektor nur den Dateinamen anzugeben.
Dann wird der Pfad eventuell erg\[:a]nzt. Zwei Punkte als Selektor ("..")
f\[:u]hren zum Elternverzeichnis.
Wenn im Selektor aber ein Schr\[:a]gstrich steht, wird er unver\[:a]ndert
\[:u]bertragen. F\[:u]r das Hauptverzeichnis kann man einfach nur einen
Schr\[:a]gstrich eintragen.
.PP
Wohlgemerkt, wenn der Host und Port angegeben sind, wird der Selektor immer
unver\[:a]ndert \[:u]bertragen.
.PP
Zum Abschluss der Datei sollte eine Zeile stehen,
die nur einen Punkt ('.') enth\[:a]lt.
Damit ist das Men\[:u] abgeschlossen.
Wenn stattdessen am Ende eine Zeile steht,
die nur ein Sternchen ('*') enth\[:a]lt,
wird am Ende noch eine automatische Dateiauflistung
drangeh\[:a]ngt.
.PP
Wenn man allgemein eine automatische Dateiauflistung bevorzugt,
und nur einzelne andere Eintr\[:a]ge hinzuf\[:u]gen will,
kann man Dateien mit der Dateiendung
.B .gophermap
einf\[:u]gen, die nur eine, oder ein paar Men\[:u]zeilen umfassen.
Der Name solcher Dateien wird zwar nie angezeigt,
hat jedoch Einfluss auf die Sortierung.
Ob, und mit welchen Abschlusszeichen solche Dateien abgeschlossen
werden, ist irrelevant.
.PP
.
.SS Gopher-Typen
.
Aus der originalen Spezifikation:
.TP
0
Text-Datei
.TP
1
Verzeichnis
.TP
2
CCSO-Telefonbuch-Server
.TP
3
Fehler
.TP
4
BinHex Macintosh-Datei
.TP
5
Bin\[:a]res Archiv
.TP
6
uuencode Datei
.TP
7
Index-Suche
.TP
8
Telnet-Sitzung
.TP
9
Bin\[:a]re Datei
.TP
+
Redundanter Server
.TP
T
TN3270-Sitzung
.TP
g
GIF Grafikdatei
.TP
I
sonstige Grafikdatei
.PP
Erweiterungen
.PP
.TP
i
Informationale Nachricht
.TP
d
Dokumentation
.TP
h
HTML-Datei
.TP
X
XML-Datei
.TP
s
Audiodatei (Sound)
.TP
;
Filmdatei
.TP
c
Kalenderdatei
.TP
M
MIME-Datei
.PP
Andere Erweiterungen k\[:o]nnen benutzt werden,
und werden benutzt...
.PP
.
.SH BEISPIEL
.
Beispiel f\[:u]r eine
.BR gophermap -Datei.
Anstelle von "<TAB>" ist nat\[:u]rlich ein TAB-Zeichen zu verwenden.
.PP
.EX
# Erstmal eine Begr\[:u]\[ss]ung
Willkommen auf Beispielserver

# Link auf Datei info im Hauptverzeichnis
0Information<TAB>/info
# Unterverzeichnis
1B\[:u]cher und Texte<TAB>buch
# Externer Server
1Floodgap<TAB>/<TAB>gopher.floodgap.com<TAB>70
# Telnet Sitzung
8Telehack<TAB>none<TAB>telehack.com<TAB>23
# Link zu anderen Protokollen mit "URL:" einleiten
hWebseite<TAB>URL:https://akfoerster.de/
\&.
.EE
.
.SH AUTOREN
.
Copyright \(co 2025 Andreas K. F\[:o]rster
.
.SH LIZENZ
.
Dieses Programm ist freie Software.
Sie k\[:o]nnen es unter den Bedingungen
der GNU General Public License, wie von der Free Software Foundation
ver\[:o]ffentlicht, weitergeben und/oder modifizieren,
entweder gem\[:a]\[ss]
Version 3 der Lizenz oder (nach Ihrer Option)
jeder sp\[:a]teren Version.
.PP
Die Ver\[:o]ffentlichung dieses Programms erfolgt in der Hoffnung,
dass es Ihnen von Nutzen sein wird, aber
.BR "ohne irgendeine Garantie" ,
sogar ohne die implizite Garantie der
.B Marktreife
oder der
.BR "Verwendbarkeit f\[:u]r einen bestimmten Zweck" .
Details finden Sie in der GNU General Public License.
.PP
Sie sollten ein Exemplar der GNU General Public License zusammen
mit diesem Programm erhalten haben.
Falls nicht, siehe <http://www.gnu.org/licenses/>.
.
.SH "SIEHE AUCH"
.BR akfgb (1),
.BR akfgopher-dl (1)
.br
RFC\~1436
.PP
gopher://akfoerster.de:47520/1soft/akfnetz
.br
https://akfoerster.de/p/akfnetz/
