.\" Process this file with
.\" groff -man -Tutf8 akfgopher-dl.en.man
.\"
.
.TH "akfgopher-dl" 1 2025-02-16 akfnetz
.nh
.
.\" Makros .TQ .EX .EE aus groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.de TQ
.br
.ns
.TP \\$1
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.SH NAME
.
akfgopher-dl \- downloader for Gopher
.
.SH SYNOPSIS
.
.BI "akfgopher-dl <" URL >
.br
.B gophermenu
.
.SH DESCRIPTION
.
The program akfgopher-dl is a simle downloader for Gopher.
.PP
It can for example be used as a backend from other programs
to download information or other material from the Internet.
.PP
The type information in the URL is ignored by this program.
.PP
To make the output of directories more legible for humans
you can use the command
.B gophermenu
as a filter.
This should only be used with type 1 and 7.
.PP
If you are looking for an interactive Gopher program, see
.BR akfgb (1).
.
.SH EXAMPLES
.EX
akfgopher-dl gopher://gopher.example.net/0/info | less
akfgopher-dl gopher://gopher.example.net/1/ | gophermenu | less
akfgopher-dl gopher://gopher.example.net/7/v2/vs%09searchterm | gophermenu 
| less
.EE
.PP
.
.SH ENVIRONMENT
.
.TP
GOPHER_PROXY
.TQ
gopher_proxy
.TQ
ALL_PROXY
.TQ
all_proxy
Use a proxy.
.IP
The information is given in form of a URL,
.br
SOCKS 4, 4a and 5 is supported.
.IP
For example:
.br
.IR socks5://127.0.0.1:1080/ ,
.br
.IR socks5://Name:Password@127.0.0.1:1080/ .
.IP
Credentials are transmitted unencrypted.
SOCKS 4 and 4a do not support credentials at all,
but there the user ID (LOGNAME) will be transfered.
.PP
.
.SH DETAILS
.
With OpenSSH you can redirect the traffic through another system.
This works by allocating a socket to listen to port on
.BR localhost .
.PP
.EX
ssh -D localhost:1080 server.example.net
# (other terminal)
GOPHER_PROXY=socks5://localhost:1080
export GOPHER_PROXY
.EE
.
.SH AUTHORS
.
Copyright \(co 2025 Andreas K. F\[:o]rster
.PP
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful, but
.BR "WITHOUT ANY WARRANTY" ;
without even the implied warranty of
.BR MERCHANTABILITY " or " "FITNESS FOR A PARTICULAR PURPOSE" .
See the GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program.
If not, see <http://www.gnu.org/licenses/>.
.PP
.
.SH "SEE ALSO"
.BR akfgb (1),
.BR akfweb-dl (1)
.PP
https://akfoerster.de/p/akfnetz/
