.\" Process this file with
.\" groff -man -Tutf8 akfgb.en.man
.\"
.
.TH "akfgb" 1 2025-05-24 akfnetz
.nh
.
.\" Makros .TQ .EX .EE aus groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.de TQ
.br
.ns
.TP \\$1
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.SH NAME
.
akfgb \- Browser for Gopher
.
.SH SYNOPSIS
.
.BI "akfgb [" URL ]
.
.SH DESCRIPTION
.
This is a browser for the Gopher protocol.
.PP
Gopher is a simple Internet protocol,
with which you can retrieve mainly texts via menus.
Other files can also be transmitted.
.PP
This is an application for the terminal
or for the text console (TUI).
.PP
Help can be obtained by pressing
.RB [ ? "], or [" F1 ].
.
.SS KEYS
.TP
F1, ?
help
.TP
Esc, q, Q
quit
.TP
h, Pos1
first line
.TP
Ende
last line
.TP
j, down
.TQ
k, up
navigation / select menu entry
.TP
Enter, right
start menu entry
.TP
u, left
back menu
.TP
Space, Page down
next page
.TP
b, Page up
previous page
.TP
w
menu up
.TP
F2, m
startaddress
.TP
t
try to show it as text
(independent of the given type)
.TP
a
show address
.TP
o
enter new URL
.TP
F4, ^S
save
.TP
^L, ^R
refresh display
.PP
.
.SH DETAILS
.
Some files cannot be displayed.
But all files can be downloaded.
.PP
For some files or services, additional software can be installed if necessary.
It shows which command is tried to be executed.
.PP
Which programs to execute is set in the source code in the file
.BR akfgb.h .
.
.SS Redirect with SSH
.
With OpenSSH you can redirect the traffic through another system.
This works by allocating a socket to listen to port on
.BR localhost .
.PP
.EX
ssh -D localhost:1080 server.example.net
# (other terminal)
ALL_PROXY=socks5://localhost:1080
export ALL_PROXY
akfgb
.EE
.
.SH ENVIRONMENT
.
.TP
GOPHER_HOME
Startaddress, when none is given
.TP
GOPHER_PROXY
.TQ
gopher_proxy
.TQ
ALL_PROXY
.TQ
all_proxy
Use a proxy.
.IP
The information is given in form of a URL,
.br
SOCKS 4, 4a and 5 is supported.
.IP
For example:
.br
.IR socks5://127.0.0.1:1080/ ,
.br
.IR socks5://Name:Password@127.0.0.1:1080/ .
.IP
Credentials for SOCKS\~5 are transmitted unencrypted.
SOCKS\~4 and 4a do not support credentials at all,
but there the user ID (LOGNAME) will be transfered.
.IP
.B Attention:
External programs can establish Internet connections outside of this proxy.
This is especially critical for anonymization services.
In particular, you should avoid menu items for
.BR URLs ", " Telnet ", " Tn3270 ", " CCSO .
.PP
.
.SH AUTHORS
.
Copyright \(co 2025 Andreas K. F\[:o]rster
.PP
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful, but
.BR "WITHOUT ANY WARRANTY" ;
without even the implied warranty of
.BR MERCHANTABILITY " or " "FITNESS FOR A PARTICULAR PURPOSE" .
See the GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program.
If not, see <http://www.gnu.org/licenses/>.
.PP
.
.SH "SEE ALSO"
.BR akfgopher-dl (1),
.BR akfweb-dl (1)
.br
.BR feh (1),
.BR mpv (1),
.BR xdg-open (1),
.BR telnet (1),
.BR c3270 (1),
.BR ph (1)
.PP
gopher://akfoerster.de:47520
