--[[-------------------------------------------------------------------
CGI fuer Lua, getestet mit Lua 5.1, 5.3
Copyright (c) 2019,2024 Andreas K. Foerster <akf@akfoerster.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

SPDX-License-Identifier: GPL-3.0-or-later
--]]-------------------------------------------------------------------

local P = {}
cgi = P


-- P.Fehlerstil = "/.well-known/akfnetz/Fehler.css"


P.code = io.write
P.write = io.write
P.var = os.getenv


P.Kopfende = function ()
  P.write ("\n")
  if P.var ("REQUEST_METHOD") == "HEAD" then os.exit () end
end


P.Kopf = function (Typ)
  P.write ("Content-Type: ", Typ or "text/html; charset=UTF-8", "\n")
  P.Kopfende ()
end


P.Status = function (Status, Typ)
  P.write ("Status: ", Status or "200 Ok", "\n",
      "Content-Type: ", Typ or "text/html; charset=UTF-8", "\n")
  P.Kopfende ()
end


-- HTML-Zeichen maskieren
P.htmltext = function (s)
  if not s then return nil end
  return ((string.gsub (s, "([<>&\"'])",
    function (c) return string.format ("&#%u;", string.byte (c)) end)))
end


P.text = function (...)
  return P.write (P.htmltext (table.concat ({...})))
end


P.Fehler = function (Meldung, Status)
  local m = P.htmltext (Meldung or "Fehler")

  P.Status (Status or "500 Server Error")
  P.write ("<!DOCTYPE html>\n<html>\n<head>\n<title>", m,
           "</title>\n")

  if P.Fehlerstil then
    P.write ("<link rel='stylesheet' href='", P.Fehlerstil, "'>\n")
  end

  P.write ("</head>\n<body>\n<div id='Fehler'>\n<h1>", m,
          "</h1>\n</div>\n</body>\n</html>\n")

  os.exit ()
end


-- volle URL fuer externe Umleitung
-- absoluter Pfad fuer interne Umleitung ('/' als erstes Zeichen)
-- keine relativen Adressen!
P.Umleitung = function (s)
  P.write ("Location: ", s, "\n\n")
  -- der Inhalt sollte bei externer Umleitung vom Server generiert werden
  -- bei internen Umleitungen darf kein Inhalt folgen
  os.exit ()
end


-- stille Empfangsbestaetigung von Formulardaten
-- Browser gibt keine Rueckmeldung und bleibt im Formular
P.stiller_Erfolg = function ()
  P.write ("Status: 204 No Content\n")
  P.Kopfende ()

  os.exit ()
end


local url_dekodiert = function (s)
  s = string.gsub (s, "%+", " ")
  s = string.gsub (s, "%%(%x%x)",
     function (v) return string.char (tonumber (v, 16)) end)

  return s
end


-- Gibt Tabelle aus Formulardaten zurueck oder nil
-- Sollte nur einmal aufgerufen werden
local formular = function ()
  local data = nil

  if P.var ("REQUEST_METHOD") == "POST"
     and P.var ("CONTENT_TYPE") == "application/x-www-form-urlencoded"
  then
    data = io.read (tonumber (P.var ("CONTENT_LENGTH")) or "*a")
  else   -- GET | HEAD
    data = P.var ("QUERY_STRING")
  end

  if not data or data == "" then return nil end

  local t = {}

  for k, v in string.gmatch (data, "([^&;=]+)=([^&;]+)") do
    k = url_dekodiert (k)
    v = url_dekodiert (v)
    local o = t[k]

    if not o
    then
      t[k] = v
    elseif type (o) == "table"
    then
      table.insert (o, v)
      o[v] = true
    else
      t[k] = { o, [o] = true, v, [v] = true }
    end
  end

  return t
end

P.form = formular ()

return P
