#include <sys\types.h>
#include <sys\stat.h>

/* If the string given is a directory, then add \*.* to the end 
of it. This is for dir accesses, etc.

	BECOMES
blank		*.*
A:		A:*.*
\		\*.*
B:\		B:\*.*
BIN		BIN\*.*		BIN is a directory 
FILE		FILE		FILE not a directory
BIN\FILE	BIN\FILE
*/

int fixdir(s)
char *s;
{
int l;
	l= strlen(s);

	if (isdir(s)) {
		if (l == 0) strcat(s,"*.*");	/* default dir */
		else if ((s[l - 1]) == '\\') strcat(s,"*.*");
		else strcat(s,"\\*.*");
		return(1);
	}
	return(0);
}

/* Return true if the string is a subdirectory. Null strings return true;
it means the current directory. We string test for things like: "/", 
"B:", "/BIN/", and ask DOS for others. Note that this lets Fido type
prefixes ("/BIN/") get through as paths. */

int isdir(s)
char *s;
{
unsigned short v;
struct stat buff;

	switch (strlen(s)) {
		case 0: return(1);			/* blank is current dir */
		case 1: if (*s == '\\') return(1);	/* if just \, root */
			else goto check;		/* else check it */
		case 2: if (s[v - 1] == ':') return(1);	/* check raw drive */
							/* fall through */
check:		default:
			v= stat(s,&buff);		/* get file/dir attributes */
			if (v == -1) return(0);		/* error -- doesnt exist at all */
			return(buff.st_mode & S_IFDIR);	/* if is a directory */
	}
}
