/*
  C source for Winsock Chess
  
  Revision 1994-03-15
  Modified by Donald Munro for use as a 2 player chess game over a 
  WINSOCK layer on a TCP (or other WinSock supporting) network.
  Source code and make files for MS Visual C/C++ V1.00/1.50.
  February/March 1994
  All GNU copyright and distribution conditions as described below and in the
  file COPYING also apply to WinSock Chess.
  This module is Winsock Chess specific.
  
  C source for GNU CHESS

  Revision: 1990-09-30
  Modified by Daryl Baker for use in MS WINDOWS environment

  Copyright (C) 1986, 1987, 1988, 1989, 1990 Free Software Foundation, Inc.
  Copyright (c) 1988, 1989, 1990  John Stanback

  This file is part of CHESS.

  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY.  No author or distributor accepts responsibility to anyone for
  the consequences of using it or for whether it serves any particular
  purpose or works at all, unless he says so in writing.  Refer to the CHESS
  General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute CHESS, but
  only under the conditions described in the CHESS General Public License.
  A copy of this license is supposed to have been given to you along with
  CHESS so you can know your rights and responsibilities.  It should be in a
  file named COPYING.  Among other things, the copyright notice and this
  notice must be preserved on all copies.
*/


#define STRICT

#include <windows.h> 
#include <windowsx.h>
#include <shellapi.h>
#include <string.h>

#include "gnuchess.h"
#include "defs.h"    

#define LEFT_MARGIN 10
#define STATLWIDTH   2
#define STATSEP     18

extern BOOL bConnected;
extern int User_Move;
extern short opponent,GameCnt;
extern int ychar;
extern HWND hwndStatus;

void Draw3D(HDC hDC, const RECT *rect)
//------------------------------------
{ POINT ptTop,ptBot;
  HPEN hpenBlack,hpenWhite,hpenOld;
  int i;
              
  ptTop.x = rect->left-1;
  ptTop.y = rect->top-1;
  ptBot.x = rect->right+1;
  ptBot.y = rect->bottom+1;
  hpenBlack = CreatePen(PS_SOLID,1,RGB(0X60,0X60,0X60));  
  hpenWhite = CreatePen(PS_SOLID,1,RGB(240,240,240));
  hpenOld = SelectObject(hDC,hpenWhite);
  for (i=0; i < STATLWIDTH; i++)
    { SelectObject(hDC,hpenWhite);
      MoveTo(hDC,ptTop.x-i,ptBot.y+i);
      LineTo(hDC,ptBot.x+i,ptBot.y+i);
      LineTo(hDC,ptBot.x+i,ptTop.y-i);
      SelectObject(hDC,hpenBlack);
      LineTo(hDC,ptTop.x-i,ptTop.y-i);
      LineTo(hDC,ptTop.x-i,ptBot.y+i);
    }  
  SelectObject(hDC,hpenOld);
  DeleteObject(hpenBlack);
  DeleteObject(hpenWhite);
}

void DrawStatusBar(HWND hwnd)
//---------------------------
{ RECT rc;
  PAINTSTRUCT ps;
  HDC hDC;
  int nx,ny;
  DWORD dwExtent;
  COLORREF colBack, colWin;
  char szStr[200],szTime[21],szMax1[]="Not Connected",szMax2[]="Black", 
       szMax3[]="Opponents Move",szMax4[]="Move 8888",
       szMax5[]="Time XXX:XX";
  
  hDC = BeginPaint (hwnd, &ps);
  colBack = GetNearestColor(hDC,RGB(0,255,255));
  colWin  = GetNearestColor(hDC,RGB(0XC0,0XC0,0XC0));
  SetTextColor(hDC,RGB(0,0,0));
  SetBkColor(hDC,colWin);
  nx = LEFT_MARGIN;
  ny = 8;
  if (bConnected)
    lstrcpy(szStr,"Connected    ");
  else
    lstrcpy(szStr,"Not Connected");  
  dwExtent = GetTextExtent(hDC,szStr,lstrlen(szStr));
  SetRect(&rc,nx,ny,nx+LOWORD(dwExtent),ny+HIWORD(dwExtent));
  ExtTextOut(hDC,nx,ny,ETO_CLIPPED,&rc,szStr,lstrlen(szStr),(LPINT) NULL);
  dwExtent = GetTextExtent(hDC,szMax1,lstrlen(szMax1));
  SetRect(&rc,nx,ny,nx+LOWORD(dwExtent),ny+HIWORD(dwExtent));
  Draw3D(hDC,&rc);             
  
  nx += LOWORD(dwExtent)+STATSEP;
  if (opponent == white)
    lstrcpy(szStr,"White");
  else
    lstrcpy(szStr,"Black");
  if (! bConnected)
    lstrcpy(szStr,"   ");  
  dwExtent = GetTextExtent(hDC,szStr,lstrlen(szStr));  
  SetRect(&rc,nx,ny,nx+LOWORD(dwExtent),ny+HIWORD(dwExtent));
  ExtTextOut(hDC,nx,ny,ETO_CLIPPED,&rc,szStr,lstrlen(szStr),(LPINT) NULL);
  dwExtent = GetTextExtent(hDC,szMax2,lstrlen(szMax2));
  SetRect(&rc,nx,ny,nx+LOWORD(dwExtent),ny+HIWORD(dwExtent));
  Draw3D(hDC,&rc);
  
  nx += LOWORD(dwExtent)+STATSEP;
  if (User_Move)
    lstrcpy(szStr,"Your Move");
  else
    lstrcpy(szStr,"Opponents Move");
  if (! bConnected)
    lstrcpy(szStr,"   ");    
  dwExtent = GetTextExtent(hDC,szStr,lstrlen(szStr));  
  SetRect(&rc,nx,ny,nx+LOWORD(dwExtent),ny+HIWORD(dwExtent));
  ExtTextOut(hDC,nx,ny,ETO_CLIPPED,&rc,szStr,lstrlen(szStr),(LPINT) NULL);
  dwExtent = GetTextExtent(hDC,szMax3,lstrlen(szMax3));
  SetRect(&rc,nx,ny,nx+LOWORD(dwExtent),ny+HIWORD(dwExtent));
  Draw3D(hDC,&rc);
  
  nx += LOWORD(dwExtent)+STATSEP;
  wsprintf(szStr,"Move %d",(GameCnt+1)/2);
  if (! bConnected)
    lstrcpy(szStr,"   ");    
  dwExtent = GetTextExtent(hDC,szStr,lstrlen(szStr));  
  SetRect(&rc,nx,ny,nx+LOWORD(dwExtent),ny+HIWORD(dwExtent));
  ExtTextOut(hDC,nx,ny,ETO_CLIPPED,&rc,szStr,lstrlen(szStr),(LPINT) NULL);
  dwExtent = GetTextExtent(hDC,szMax4,lstrlen(szMax4));
  SetRect(&rc,nx,ny,nx+LOWORD(dwExtent),ny+HIWORD(dwExtent));
  Draw3D(hDC,&rc);
  
  nx += LOWORD(dwExtent)+STATSEP;
  ClockString(szTime);
  wsprintf(szStr,"Time %s",(LPSTR)szTime);
  if (! bConnected)
    lstrcpy(szStr,"   ");    
  dwExtent = GetTextExtent(hDC,szStr,lstrlen(szStr));  
  SetRect(&rc,nx,ny,nx+LOWORD(dwExtent),ny+HIWORD(dwExtent));
  ExtTextOut(hDC,nx,ny,ETO_CLIPPED,&rc,szStr,lstrlen(szStr),(LPINT) NULL);
  dwExtent = GetTextExtent(hDC,szMax5,lstrlen(szMax5));
  SetRect(&rc,nx,ny,nx+LOWORD(dwExtent),ny+HIWORD(dwExtent));
  Draw3D(hDC,&rc);
  
  EndPaint (hwnd,&ps);  
}  

BOOL DestroyStatusBar(HWND hWnd)
//------------------------------
{ PostQuitMessage(0);
  return TRUE;
}  

LRESULT CALLBACK StatusBarProc(HWND hWnd,UINT message,WPARAM wParam,
                               LPARAM lParam)
//------------------------------------------------------------------
{ switch (message)
   { case WM_PAINT :
       return HANDLE_WM_PAINT(hWnd,wParam,lParam,DrawStatusBar);
       
     case WM_DESTROY:  
          return HANDLE_WM_DESTROY(hWnd,wParam,lParam,DestroyStatusBar);
          
     default:   
         return (DefWindowProc(hWnd, message, wParam, lParam));
   }
  return NULL;
}                                               