/*
  MODULE: WS_GLOB.H  (global header file)
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef _BORLANDC_
#include <dir.h>
#else
#include <direct.h>
#endif

#include "winsock.h"

#ifndef WS_GLOBHEADER

#define WS_GLOBHEADER

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

#ifndef MAXPACKET
#define MAXPACKET 4096
#endif

// some miscellaneous definitions that we use

#define SCRLWND      7531

#define FTP_PRELIM   1
#define FTP_COMPLETE 2
#define FTP_CONTINUE 3
#define FTP_RETRY    4
#define FTP_ERROR    5
#define FTP_ABORT    6

#ifndef IS_GLOBAL_C

extern BOOL bAutoStart;
extern BOOL bAborted;
extern BOOL bRetain;
extern BOOL bDblClkVu;
extern BOOL bAccount;
extern BOOL bFireWall;
extern BOOL bLocalHistory;
extern BOOL bRemoteHistory;
extern BOOL bCancelXfer;
extern BOOL bOpInProgress;

extern WORD wSortType;

extern u_int uiTimeOut;              // 30 second timeout??

extern char szMsgBuf[MAXPACKET];     // main i/o buffer
extern u_char szSendPkt[MAXPACKET];  // output transfer buffer
extern char szString[5120];           // temp string area
extern char szMailAddress[128];
extern char szViewer[128];
extern char szDlgPrompt[80];         // used by input dialog as prompt
extern char szDlgEdit[80];           // used by input dialog for output
extern char szTempDir[80];           // Directory for temporary files
extern char szConfig[80];            // used by host dialog for userid
extern char szUserID[80];            // used by host dialog for userid
extern char szPassWord[80];          // used by host dialog for password
extern char szRemoteHost[80];        // remote host name/addr to connect to
extern char szFireWallHost[80];
extern char szFireWallUserID[30];
extern char szFireWallUserPass[30];
extern char szAppName[20];           // this programs name "winftp"
extern char szIniFile[20];           // INI file name
extern char szTmpDirFileName[20];
extern char szTmpViewFileName[20];
extern char szLFileType[20];
extern char szRFileType[20];
extern char szAccountPass[30];
extern char szDefaultHdr[40];
extern char szCurrentDir[_MAX_PATH]; // Holds Current Dir File name for LongDir
extern char szTmpDirFile[_MAX_PATH];
extern char szTmpViewFile[_MAX_PATH];
extern char szInitDir[_MAX_PATH];
extern char szScript[_MAX_PATH];
extern char szLogFile[_MAX_PATH];
extern char szXferWnd[10];
extern char szMsgWnd[15];
 
extern char szFormName[10];          // ** not used in this version
extern char szModeName[10];          // ** not used in this version
extern char szStructName[10];        // ** not used in this version
extern char szTypeName[10];          // ** not used in this version

extern LPSTR lpDebugWindow;

extern char fType;                   // file transfer type
extern char cType;                   // current transfer type
extern char cForm;                   // format (not used???)
extern char cMode;                   // mode (not used???)
 
extern HCURSOR hStdCursor;           // cursors
extern HCURSOR hWaitCursor;          // cursors
 
extern HINSTANCE hInst;              // handle of instance
extern HWND hWndMain;                // handle of main window
extern HWND hWndDbg;                 // handle of Debug window

// child window handles
extern HWND hLbxLDir,hLbxLFiles,hLbxRDir,hLbxRFiles, hLbxLDirLst, hLbxRDirLst;
extern HWND hTxtLDir,hTxtRHost,hTxtRDir,hTxtLBytes,hTxtRBytes;
extern HWND hRBascii,hRBbinary,hRBl8,hScroll;
 
extern BOOL bConnected;              // connected flag
extern BOOL bCmdInProgress;          // command in progress flag
extern BOOL bSendPort;               // use PORT commands (must be 1!!!)
 
extern int nWndx;                    // the x axis multiplier
extern int nWndy;                    // the y axis multiplier
extern int nAcctType;
extern int nLogFlag;

// options
extern int bBell;          // completion bell (not used in this version)
extern int bCRstrip;       // crlf conversion (not used in this version)
extern int bDoGlob;        // globbing (not used in this version)
extern int bHash;          // show hash (not used in this version)
extern int bInteractive;   // prompting (not used in this version)
extern int bMCase;         // case conversion (not used in this version)
extern int bRecvUniq;      // unique name on receive (not used in this ver)
extern int bStorUniq;      // unique name on transmit (not used in this ver)
extern int bVerbose;       // maximum verbosity (turns extra debug msgs on)
extern int nHostType; 
extern int iCode;          // return code from last command(..)
extern int nCfgNum;
extern int nViewNum;
 
extern int ptrhGMem;
extern int nTimerID;

extern SOCKET ctrl_socket;           // control channel socket
extern SOCKET data_socket;           // data channel socket
extern SOCKET listen_socket;         // data listen socket
 
extern struct sockaddr_in saDestAddr;     
extern struct sockaddr_in saFromAddr;     
extern struct sockaddr_in saSockAddr;         // endpoint address
extern struct sockaddr_in saSockAddr1;        // used when bSendPort==0
extern struct sockaddr_in saCtrlAddr;
 
extern WORD sVPos;                   // scroll pos for debug window
 
extern WSADATA WSAData;              // windows sockets dll information
 
#endif /* if IS_GLOBAL_C */
 
#endif /* if WS_GLOBHEADER */

