/* conf.h
   Define the site specific configuration values and macros */


     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing Services Office                      */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#ifndef G_CONFIG_H
#define G_CONFIG_H

/* ----- application defaults ---- */
/* Following are the default values for application resources.
   These are easily overridden in the system's or user's application
   defaults file. */

#define ROOT_SERVER	"gopher.uiuc.edu"  /* default host server	  */
#define ROOT_PORT	70		/* default host server	 	  */
#define MAIN_TITLE	"UIUC Gopher  Information Service"
					/* title of main menu	  */
#define ALLOW_PRINT	TRUE		/* allow files to be printed?	  */
#define ALLOW_SAVE	TRUE		/* allow files to be saved?	  */
#define PRINT_COMMAND	"out" 		/* default print command	  */
#define HELP_FILE	"/usr/lib/X11/xgopher/xgopher.help"
					/* default help file		  */
#define DIRECTORY_TIME	600		/* number of seconds a dir is valid */
#define HAS_SOUND	FALSE		/* the X server(!) has sound	  */
#define SOUND_COMMAND	"/bin/false"	/* command to get sound out  	  */
#define ALLOW_TELNET	TRUE		/* allow telnet sessions          */
#define TELNET_COMMAND	"xterm -e telnet"
					/* command to start telnet  	  */
#define ITEMS_TO_START	500		/* initial number of gopher items */
#define ITEMS_TO_ADD	50		/* alloc this many more when needed */
#define DIRS_TO_START	50		/* initial number of gopher dirs  */
#define DIRS_TO_ADD	10		/* alloc this many more when needed */
#define DOUBLE_CLICK	TRUE		/* Allow double click for selection */
#define MARK_ROOT	TRUE		/* set automatic  bookmark at root */
#define TEMP_DIRECTORY	"/tmp"		/* directory for bringing files to */

	/* the following prefixes must be <= PREFIX_LEN characters long */

#define PREFIX_FILE	"      "	/* listing prefix for text files     */
#define PREFIX_DIR	"\273     "	/* listing prefix for directories    */
#define PREFIX_CSO	"<cso> "	/* listing prefix for CSO nameservers */
#define PREFIX_INDEX	"<idx> "	/* listing prefix for index search   */
#define PREFIX_TELNET	"<tel> "	/* listing prefix for telnet session */
#define PREFIX_SOUND	"<snd> "	/* listing prefix for sound files    */
#define PREFIX_UNKNOWN	"<???> "	/* listing prefix for unknown files  */

/* ----- end of application defaults ---- */

#define	PATH_NAME_LEN		1024	/* characters in a file path name */
#define USER_STRING_LEN		100	/* length of user display string  */
#define PREFIX_LEN		6	/* length of user string prefix   */
#define SELECTOR_STRING_MAX_LEN	1024	/* max length of selector string  */
#define HOST_STRING_LEN		100	/* length of host name string     */
#define MESSAGE_STRING_LEN	256	/* length of strings for messages */
#define FILE_LINE_LEN		512	/* length of line in text file    */
#define HELP_SEC_TITLE_LEN	80	/* length of help item title      */
#define INDEX_WORD_LEN          1024	/* total len of index word string */
#define INDEX_WORD_COUNT        40	/* number of distinct index words */

#define GOPHER		"gopher"	/* name of the thing!             */
#define GOPHER_CLASS	"Xgopher"	/* name of the application class  */

#define NL		'\n'		/* New Line character             */
#define EOL_STRING	"\r\n"		/* terminate queries with  this   */

#define PREFIX(gi, p) {int i; for (i=0;i<PREFIX_LEN;i++) \
			(gi->userStringAndPrefix)[i]=*(p+i);}


/* ----- Portability ----- */

/*       Each server allows a maximum window size.  It is not clear that
	 the server can be queried to obtain this maximum value.  Most
	 servers allow 65535 x 65535  (width, height).  Some HP servers,
	 for example, allow only 16383 x 16383.  The following constants
	 define this maximum.  It is used to create an overlay window
	 for the stopwatch cursor during time-consuming operations.

	 The Sun OpenWindows Release 2 server also requires these
	 following 2 constants to be 16383 each.

	 Other X11R3-compliant servers may have a similar limit.  If
	 you try to run Xgopher and receive messages (from X) about
	 "unable to allocate resource...Request Major code 1..."
	 Then try changing these values.  The symbol OPENWIN_2 may
	 be used for convenience.
*/

#ifndef OPENWIN_2

#define SERVER_MAX_WINDOW_WIDTH		65535
#define SERVER_MAX_WINDOW_HEIGHT	65535

#else	/* OPENWIN_2 */

#define SERVER_MAX_WINDOW_WIDTH		16383
#define SERVER_MAX_WINDOW_HEIGHT	16383

#endif	/* OPENWIN_2 */

/* ----- X11R4 compatability ----- */

/*       There has been considerable interest in compiling Xgopher
	 under X11R4.  I will try to make some effort to provide that
	 capability to the extent possible, perhaps with some minor
	 loss of function.   To that end, if you must use X11R4, 
	 uncomment the line below to define the symbol XGOPHER_X11R4.
	 I cannot promise to maintain this backwards compatibility 
	 in the long run. */

/*  #define XGOPHER_X11R4   */


#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#endif /* ifndef G_CONFIG_H */
