#include "gopher.h"

#ifdef _AIX  /** Use bsd definitions to get wait3 on the rs6000 **/
#define _BSD
#endif

#include <sys/wait.h>
#include <signal.h>

#ifdef SIGTSTP    /* True on a BSD system */
#include <sys/file.h>
#endif

#include <sys/ioctl.h>

/* A little signal handler that handles those damn zombies */


void
sig_child()
{
     /*
      * Use the wait3() system call with the WNOHANG option
      */

     int pid;
#ifdef POSIXWAIT
     int status;

     while ( (pid =waitpid(-1, &status, WNOHANG)) > 0)
	  ;
#else

     union wait  status;

     while ( (pid = wait3(&status, WNOHANG, (struct rusage *) 0)) > 0)
          ;
#endif
}


#ifdef SIGCHLD
#ifndef SIGCLD
#  define SIGCLD SIGCHLD
#endif
#endif


setsighandler() 
{
          
#ifdef SIGTSTP
     signal(SIGCLD, sig_child);  /* BSD */
#else
     signal(SIGCLD, SIG_IGN);
#endif


}
