program Ap2IFC;

(* converts Apple ][ format Infocom file to IBM *)
(* WARNING: Only tested on old version 3 files  *)

uses
  Objects;

const
  start = $3000;
  numsects = 31*16;
  sectbl : array[0..15] of byte =
    (0,13,11,9,7,5,3,1,14,12,10,8,6,4,2,15);
  wordspersect : array[1..5] of byte =
    (128, 128, 128, 64, 64);
var
  S,D : TBufStream;
  trk,sec, i : word;
  numwords : word;
  GameVer : byte;
begin
  if (ParamCount <> 2) then begin
    writeln('USAGE: ap2ifc <srcfile> <destfile>');
    halt(1);
  end;
  S.Init(ParamStr(1), stOpenRead, $1000);
  if S.Status <> stok then begin
    Writeln('Could not open "', ParamStr(1), '"');
  end;
  D.Init(ParamStr(2), stCreate, $1000);
  if D.Status <> stok then begin
    Writeln('Could not create "', ParamStr(2), '"');
  end;
  Writeln('Writing to file "', ParamStr(2), '"...');
  S.Seek($3000);
  S.Read(GameVer, 1);
  if not (GameVer in [1..5]) then begin
    Writeln('Not correct format or version not supported.');
    Halt;
  end;
  S.Seek($301A);
  S.Read(numwords, 2);
  numwords := Swap(numwords);
  for i := 0 to (numwords div wordspersect[GameVer]) do begin
    trk := (i div 16);
    sec := sectbl[i and 15];
    S.Seek(start+longint(trk*16+sec)*256);
    D.CopyFrom(S, 256);
  end;
  D.Done;
  S.Done;
  Writeln('Done.');
end.
