// zeal - A portable Glk-based Z-code interpreter
// Copyright (C) 2000 Jeremy Condit <jcondit@eecs.harvard.edu>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// =======================================================================
//  stdlite.cc:
//
//  digital unix has no snprintf().  i finally got fed up and just wrote
//  my own.  it supports %d, %s, and %s, plus field widths.
//
//  i also considered rewriting the bits of the c library that i used to
//  make this code completely self-sufficient, but then i realized that
//  that was just silly.  if someone doesn't have a working memcpy(),
//  they've got bigger problems than whether they can play zork.
// =======================================================================

#ifndef _stdlite_h_
#define _stdlite_h_

#include <stdarg.h>

typedef unsigned int uint;

void*
memcpy_lite(void* s1, const void* s2, uint n);

int
vsnprintf_lite(char *s, uint n, const char *format, va_list args);

int
snprintf_lite(char *s, uint n, const char *format, ...);

#endif // _stdlite_h_
