// zeal - A portable Glk-based Z-code interpreter
// Copyright (C) 2000 Jeremy Condit <jcondit@eecs.harvard.edu>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// =======================================================================
//  osdep.h:
//
//  this class is an abstract class that is used to hide os-dependent
//  information from zeal.  basically, everything zeal needs that it can't
//  get from glk goes in here.
//
//  the os-dependent glk code should override these methods and put an
//  instance of this class in the os global.  if this isn't done, the
//  default implementation below is used.
// =======================================================================

#ifndef _osdep_h_
#define _osdep_h_

class osdep {
    public:
        osdep() {}
        virtual ~osdep() {}

        virtual unsigned long get_seed() { return 42; }
        virtual strid_t get_story() { return NULL; }
        virtual void close_story() {}
        virtual uint get_strictz() { return 1; }
        virtual bool debug() { return false; }
        virtual void debug_msg(const char* /* format */, ...) {}
};

#endif // _osdep_h_
