// zeal - A portable Glk-based Z-code interpreter
// Copyright (C) 2000 Jeremy Condit <jcondit@eecs.harvard.edu>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// =======================================================================
//  inst.h:
//
//  this header contains data structures used for holding instruction
//  handler info plus a data structure for passing arguments to an
//  instruction.
//
//  the tables are defined in inst.cc.
// =======================================================================

#ifndef _inst_h_
#define _inst_h_

#include "zeal.h"

struct inst_args {
    ubyte opcode;
    ubyte ext;
    ubyte argc;
    uword argv[8];
};

typedef void (*inst_handler)(inst_args* args);

extern inst_handler two_inst_table[];
extern inst_handler one_inst_table[];
extern inst_handler zero_inst_table[];
extern inst_handler var_inst_table[];
extern inst_handler ext_inst_table[];

#endif // _inst_h_
