// zeal - A portable Glk-based Z-code interpreter
// Copyright (C) 2000 Jeremy Condit <jcondit@eecs.harvard.edu>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// =======================================================================
//  alpha.h:
//
//  the alphabet class represents an alphabet table in the z-machine
//  memory or the default table if a custom one is not specified.
// =======================================================================

#ifndef _alpha_h_
#define _alpha_h_

#include "zeal.h"

class alphabet {
    public:
        alphabet();
        ~alphabet();

        ubyte zchar_to_zscii(int a, ubyte zchar);
        bool zscii_to_zchar(ubyte zscii, int* a, ubyte* zchar);

    private:
        address custom;
        const char** standard;

        static const char* table1[];
        static const char* table2[];
};

#endif // _alpha_h_
