/*
  Status
*/

#include "status.h"

#include "console.h"
#include "head.h"
#include "infocom.h"
#include "object.h"
#include "os.h"
#include "print.h"
#include "shared.h"
#include "var.h"
#include "wio.h"

static byte *s_buff_ptr;

static void put_status(word ch)
{
  *s_buff_ptr++ = (char) ch;
}

static void put_space(void)
{
  put_status(' ');
}

static void put_digit(word d)
{
  put_status(d + '0');
}

static void copy_string(char *src)
{
#if 0
  int len = os_strlen(src);
  os_mcpy(s_buff_ptr, src, len);
  s_buff_ptr += len;
#else
  while(*src)
  {
    put_status(*src);
    ++src;
  }
#endif
}

static void pad_string(byte *upto)
{
  while(s_buff_ptr < upto)
    put_space();
}

static void print_status(byte *s_buffer)
{
  int w = hd_width();
  start_update();
  save_attributes(1);
  goto_xy(0, 0);
  out_char(make_font_request(FONT_FIXED_REVS));
  while(--w >= 0)
    out_char(*s_buffer++);
  erase_to_eoln();
  restore_attributes(1);
  finish_update();
}

void status(void)
{
  extern bool disable_script;
  extern void (*PrintChar) (word);

  bool old_disable_script    = disable_script;
  void (*old_procptr) (word) = PrintChar;

  word locn = load_var(0x10);
  word arg1 = load_var(0x11);
  word arg2 = load_var(0x12);

  byte s_buffer[MAX_MAX_FIXED];

  s_buff_ptr     = s_buffer;
  put_space();
  disable_script = 1;
  PrintChar      = put_status;

  obj_print(locn);

  if(hd_mode() & USE_TIME)
  {
    word hour    = arg1;
    word minutes = arg2;

    pad_string(&s_buffer[hd_width() - 0x10]);
    copy_string("Time: ");
    print_num(hour == 0 ? 12 : hour <= 12 ? hour : hour - 12);
    put_status(':');
    put_digit(minutes/10);
    put_digit(minutes%10);
    copy_string(hour >= 12 ? " PM" : " AM");
  }
  else
  {
    pad_string(&s_buffer[hd_width() - 0x14]);
    copy_string("Score: ");
    print_num(arg1);
    put_status('/');
    print_num(arg2);
  }
  pad_string(&s_buffer[MAX_MAX_FIXED]);
  print_status(s_buffer);
  disable_script = old_disable_script;
  PrintChar      = old_procptr;
}

