/*
  PC
*/

#include "pc.h"

#include "mem.h"

static word page, offset;

word pc_page(void)
{
  return page;
}

word pc_offset(void)
{
  return offset;
}

void move_pc(word d)
{
  set_pc(page, offset + d);
}

void set_pc(word p, signed_word o)
{
  while(o < 0)
  {
    o += BLOCK_SIZE;
    p -= 1;
  }
  while(o >= BLOCK_SIZE)
  {
    o -= BLOCK_SIZE;
    p += 1;
  }
  page   = p;
  offset = o;
}

byte next_byte(void)
{
  byte b = rd_byte_seg(page, offset);
#if 0 /* This is slow */
  move_pc(1);
#else
  if(++offset == BLOCK_SIZE)
  {
    offset = 0;
    ++page;
  }
#endif
  return b;
}

word next_word(void)
{
  byte hi = next_byte();
  byte lo = next_byte();
  return make_word(hi, lo);
}
