/*
  Init
*/

#include "init.h"

#include "addr.h"
#include "head.h"
#include "input.h"
#include "message.h"
#include "mem.h"
#include "page.h"
#include "random.h"
#include "shared.h"
#include "stop.h"
#include "support.h"
#include "var.h"

#define MAX_BYTES ((word)0xFE00)

void init(void)
{
  char *error = "Not enough memory";
  if(pg_head())
  {
    if(init_addr())
    {
      word minimum  = hd_resident_blocks();
      word maximum  = hd_version() >= VERSION_3
                    ? pg_blocks(ad_raw_addr(hd_verify())) : 256;
      if(pg_init(minimum, maximum))
      {
        init_input();
        init_message();
        seed_random();
        error = 0;
      }
    }
    else
    {
      error = "Infocom file with bad version number (not 1 through 8)";
    }
  }
  if(error)
  {
    display((byte *) error);
    quit();
  }
}
