/*
  Addr
*/

#include "addr.h"

#include "head.h"
#include "page.h"

static int shift_factor;

int init_addr(void)
{
  switch(hd_version())
  {
#if EARLY
    case VERSION_1:
    case VERSION_2:
#endif
    case VERSION_3:
      shift_factor = 1;
      return 1;
    case VERSION_4:
    case VERSION_5:
    case VERSION_6:
    case VERSION_7:
      shift_factor = 2;
      return 1;
    case VERSION_8:
      shift_factor = 3;
      return 1;
    default:
      return 0;
  }
}

/* This has been cleaned up to add version 8 support */

long_word ad_raw_addr(long_word addr)
{ return addr << shift_factor; }

long_word ad_code_addr(word addr)
{ return ad_raw_addr(addr + (long_word) hd_code_offset()); }

long_word ad_text_addr(word addr)
{ return ad_raw_addr(addr + (long_word) hd_text_offset()); }

