// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "FrotzCE.h"


#include "FrotzCEDoc.h"
#include "FrotzCEView.h"
#include "MainFrm.h"
#include "MacroDialog.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define PSPC_TOOLBAR_HEIGHT 24

const DWORD dwAdornmentFlags = 0; // exit button

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_BOLDFONT, OnBoldfont)
	ON_UPDATE_COMMAND_UI(ID_BOLDFONT, OnUpdateBoldfont)
	ON_COMMAND(ID_COLOURS, OnColours)
	ON_UPDATE_COMMAND_UI(ID_COLOURS, OnUpdateColours)
	ON_COMMAND(ID_EXPANDABBREV, OnExpandabbrev)
	ON_UPDATE_COMMAND_UI(ID_EXPANDABBREV, OnUpdateExpandabbrev)
	ON_COMMAND(ID_IGNOREERRORS, OnIgnoreerrors)
	ON_UPDATE_COMMAND_UI(ID_IGNOREERRORS, OnUpdateIgnoreerrors)
	ON_COMMAND(ID_SMALLFONT, OnSmallfont)
	ON_UPDATE_COMMAND_UI(ID_SMALLFONT, OnUpdateSmallfont)
	ON_COMMAND(ID_STYLES, OnStyles)
	ON_UPDATE_COMMAND_UI(ID_STYLES, OnUpdateStyles)
	ON_COMMAND(ID_TANDY, OnTandy)
	ON_UPDATE_COMMAND_UI(ID_TANDY, OnUpdateTandy)
	ON_COMMAND(ID_TERMINALFONT, OnTerminalfont)
	ON_UPDATE_COMMAND_UI(ID_TERMINALFONT, OnUpdateTerminalfont)
	ON_UPDATE_COMMAND_UI(ID_SHOW_COMPASS, OnUpdateShowCompass)
	ON_COMMAND(ID_SHOW_COMPASS, OnShowCompass)
	ON_COMMAND(ID_FILE_EDITMACROS, OnFileEditmacros)
	//}}AFX_MSG_MAP


	ON_MESSAGE(WM_UPDATE_MENU, OnUpdateMenu)

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	m_wndCommandBar.m_bShowSharedNewButton = FALSE;
	m_ToolTipsTable[0] = MakeString(IDS_NEW);
	m_ToolTipsTable[1] = MakeString(IDS_FILE);
	m_ToolTipsTable[2] = MakeString(ID_OPTIONS);
	m_ToolTipsTable[3] = MakeString(IDS_MHELP);
	m_ToolTipsTable[4] = MakeString(IDS_ABOUT);
	

	m_ToolTipsTable[5] = MakeString(IDS_FILE);
	m_ToolTipsTable[6] = MakeString(ID_LOOK);
    m_ToolTipsTable[7] = MakeString(ID_TAKE);
	m_ToolTipsTable[8] = MakeString(ID_DROP);
	m_ToolTipsTable[9] = MakeString(ID_INVENTORY);
	m_ToolTipsTable[10] = MakeString(ID_GO);
	m_ToolTipsTable[11] = MakeString(ID_OPEN);
 

	if(!m_wndCommandBar.Create(this) ||
	   !m_wndCommandBar.InsertMenuBar(IDR_MAINFRAME) ||
	   !m_wndCommandBar.AddAdornments() ||
	   !m_wndCommandBar.LoadToolBar(IDR_MAINFRAME)  ||
		!m_wndCommandBar.SendMessage(TB_SETTOOLTIPS, (WPARAM)(4), (LPARAM)(&m_ToolTipsTable[1])))
	{
		TRACE0("Failed to create CommandBar\n");
		return -1;      // fail to create
	}

	m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_FIXED);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs


	return TRUE;
}



LPTSTR CMainFrame::MakeString(UINT stringID)
{
	TCHAR buffer[255];
	TCHAR* theString;

	::LoadString(AfxGetInstanceHandle(), stringID, buffer, 255);
	theString = new TCHAR[lstrlen(buffer) + 1];
	lstrcpy(theString, buffer);
	return theString;
}   



void CMainFrame::RefreshMacroMenu()
{
	int i;
	UINT   id_list[10];


	CMenu* pTopMenu = AfxGetMainWnd()->GetMenu();
	CMenu* pMacroMenu = pTopMenu->GetSubMenu(1);
	
	// Delete All Menu's
	while (pMacroMenu->DeleteMenu(0, MF_BYPOSITION) != 0);


	// Add Standard Menu's
	pMacroMenu->AppendMenu(MF_STRING,
		ID_FILE_EDITMACROS, CString("Edit Macros"));    // Macro Menu
	pMacroMenu->AppendMenu(MF_SEPARATOR,				// SEPERATOR
		0, CString(""));    

	id_list[0] = ID_RUN_MACRO1;
	id_list[1] = ID_RUN_MACRO2;
	id_list[2] = ID_RUN_MACRO3;
	id_list[3] = ID_RUN_MACRO4;
	id_list[4] = ID_RUN_MACRO5;
	id_list[5] = ID_RUN_MACRO6;
	id_list[6] = ID_RUN_MACRO7;
	id_list[7] = ID_RUN_MACRO8;
	id_list[8] = ID_RUN_MACRO9;
	id_list[9] = ID_RUN_MACRO10;
	
	// Insert Macro Menu's
	for (i = (FROTZCEAPP->m_iNumberMacros -1); i >= 0 ; i--)
	{
			pMacroMenu->AppendMenu(MF_STRING,
				id_list[i], FROTZCEAPP->m_sMacroNames[i]);    // ID is worthless
	}


}












 
/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnSmallfont() 
{
	if ((FROTZCEAPP->m_nFontHeight != SMALL_FONT_HEIGHT) &&
	   (FROTZCEAPP->m_nFontWidth != SMALL_FONT_WIDTH))
	{
		FROTZCEAPP->m_nFontHeight = SMALL_FONT_HEIGHT;
		FROTZCEAPP->m_nFontWidth = SMALL_FONT_WIDTH;
	}
	else 
	{
		FROTZCEAPP->m_nFontHeight = 0;
		FROTZCEAPP->m_nFontWidth = 0;
	}
}

void CMainFrame::OnTerminalfont() 
{
	if ((FROTZCEAPP->m_nFontWidth != TERMINAL_FONT_WIDTH) &&
		(FROTZCEAPP->m_nFontHeight != TERMINAL_FONT_HEIGHT))
	{
		FROTZCEAPP->m_nFontHeight = TERMINAL_FONT_HEIGHT;
		FROTZCEAPP->m_nFontWidth = TERMINAL_FONT_WIDTH;
	}
	else 
	{
		FROTZCEAPP->m_nFontHeight = 0;
		FROTZCEAPP->m_nFontWidth = 0;
	}
}

void CMainFrame::OnBoldfont() 
{ 
	if (FROTZCEAPP->m_nDefaultStyle == NORMAL_STYLE) 
		FROTZCEAPP->m_nDefaultStyle = BOLDFACE_STYLE;
	else FROTZCEAPP->m_nDefaultStyle = NORMAL_STYLE;
}

void CMainFrame::OnUpdateBoldfont(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( (FROTZCEAPP->m_nDefaultStyle != NORMAL_STYLE) );
}

void CMainFrame::OnUpdateSmallfont(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((FROTZCEAPP->m_nFontHeight == SMALL_FONT_HEIGHT) &&
	   (FROTZCEAPP->m_nFontWidth == SMALL_FONT_WIDTH));
}

void CMainFrame::OnUpdateTerminalfont(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((FROTZCEAPP->m_nFontWidth == TERMINAL_FONT_WIDTH) &&
		(FROTZCEAPP->m_nFontHeight == TERMINAL_FONT_HEIGHT));
}

void CMainFrame::OnColours() 
{
	if (FROTZCEAPP->m_bUseColours) FROTZCEAPP->m_bUseColours = FALSE;
	else FROTZCEAPP->m_bUseColours = TRUE;
}

void CMainFrame::OnUpdateColours(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( FROTZCEAPP->m_bUseColours );
}

void CMainFrame::OnStyles() 
{
	if (FROTZCEAPP->m_bUseStyles) FROTZCEAPP->m_bUseStyles = FALSE;
	else 
	{
		AfxMessageBox( TEXT( "Setting this option may result in irregular spacing" ) );
		FROTZCEAPP->m_bUseStyles = TRUE;
	}
}

void CMainFrame::OnUpdateStyles(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( FROTZCEAPP->m_bUseStyles );
}

void CMainFrame::OnExpandabbrev() 
{
	if (option_expand_abbreviations) option_expand_abbreviations = 0;
	else option_expand_abbreviations = 1;
}

void CMainFrame::OnUpdateExpandabbrev(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( (option_expand_abbreviations == 1) );
}

void CMainFrame::OnIgnoreerrors() 
{
	if (option_ignore_errors) option_ignore_errors = 0;
	else option_ignore_errors = 1;
}

void CMainFrame::OnUpdateIgnoreerrors(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( (option_ignore_errors == 1) );
}

void CMainFrame::OnTandy() 
{
	if (FROTZCEAPP->m_bTandy) FROTZCEAPP->m_bTandy = FALSE;
	else FROTZCEAPP->m_bTandy = TRUE;
}

void CMainFrame::OnUpdateTandy(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( FROTZCEAPP->m_bTandy );
}



void CMainFrame::OnUpdateShowCompass(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( FROTZCEAPP->m_bShowCompass );
	
}

void CMainFrame::OnShowCompass() 
{
	if (FROTZCEAPP->m_bShowCompass) FROTZCEAPP->m_bShowCompass = FALSE;
	else FROTZCEAPP->m_bShowCompass = TRUE;
	
	FROTZCEVIEW->Invalidate();
	FROTZCEVIEW->UpdateWindow();

}



//MUCH TO DO
void CMainFrame::OnUpdateMenu()
{
	// Clear the command bar
	m_wndCommandBar.ResetCommandBar();

	// Z-machine running?

	if (FROTZCEAPP->m_bZmachineRunning == FALSE)
	{

		
	   m_ToolTipsTable[0] = MakeString(IDS_ABOUT);
	   m_wndCommandBar.InsertMenuBar(IDR_MAINFRAME);
	   m_wndCommandBar.AddAdornments();
	   m_wndCommandBar.LoadToolBar(IDR_MAINFRAME);
	   m_wndCommandBar.SendMessage(TB_SETTOOLTIPS, (WPARAM)(4), (LPARAM)(&m_ToolTipsTable[1]));
	   m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_FIXED);

	}
	else
	{
  
	   
	   
	   m_wndCommandBar.InsertMenuBar(IDR_GAMEMENU);
	   m_wndCommandBar.AddAdornments();
	   m_wndCommandBar.LoadToolBar(IDR_GAMEBUTTONS);
	   m_wndCommandBar.SendMessage(TB_SETTOOLTIPS, (WPARAM)(7), (LPARAM)(&m_ToolTipsTable[5]));
	   m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_FIXED);

		RefreshMacroMenu();
	}


}



void CMainFrame::OnFileEditmacros() 
{
	CMacroDialog myDlg;
	myDlg.m_bFullScreen = FALSE;
	if (myDlg.DoModal() == IDOK)
		RefreshMacroMenu();
	
}

