// MacroDialog.cpp : implementation file
//
#include "stdafx.h"
#include "resource.h"
#include "MacroDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMacroDialog dialog


CMacroDialog::CMacroDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CMacroDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMacroDialog)
	//}}AFX_DATA_INIT
}


void CMacroDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMacroDialog)
	DDX_Control(pDX, IDC_MACRO_ACTION_EDIT, m_MacroAction);
	DDX_Control(pDX, IDC_MACRO_NAME_EDIT, m_MacroName);
	DDX_Control(pDX, IDC_MACRO_LIST, m_MacroList);
	DDX_Control(pDX, IDC_ACTION_LIST, m_ActionList);
	//}}AFX_DATA_MAP

	
	m_iNumItems = FROTZCEAPP->m_iNumberMacros;
	int i;

	for(i=0;i<m_iNumItems;i++)
	{
		m_MacroList.InsertString(-1,FROTZCEAPP->m_sMacroNames[i]);
		m_ActionList.InsertString(-1,FROTZCEAPP->m_sMacroActions[i]);
	}



}


BEGIN_MESSAGE_MAP(CMacroDialog, CDialog)
	//{{AFX_MSG_MAP(CMacroDialog)
	ON_BN_CLICKED(IDC_ADD_BUTTON, OnAddButton)
	ON_BN_CLICKED(IDC_DEL_BUTTON, OnDelButton)
	ON_LBN_SELCHANGE(IDC_MACRO_LIST, OnSelchangeMacroList)
	ON_EN_KILLFOCUS(IDC_MACRO_ACTION_EDIT, OnKillfocusMacroActionEdit)
	ON_EN_KILLFOCUS(IDC_MACRO_NAME_EDIT, OnKillfocusMacroNameEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMacroDialog message handlers

void CMacroDialog::OnAddButton() 
{
	CString temp;
	
	temp.Format(_T("macro%d"),(m_iNumItems + 1)); 

	if (m_iNumItems < 10)
	{

	m_MacroList.InsertString(-1,temp);
	temp.Format(_T("action%d"),(m_iNumItems + 1)); 
	m_ActionList.InsertString(-1,temp);
	m_iNumItems++;	
	}
	else
	{
		AfxMessageBox(CString("Maximum of 10 Macros"));
	}

}

void CMacroDialog::OnDelButton() 
{
	CString temp;
    int i;

	i = m_MacroList.GetCurSel();
	if(m_MacroList.DeleteString( i ) != LB_ERR )
	{
		m_ActionList.DeleteString( i ); 
		m_iNumItems--;	
		m_MacroName.SetWindowText(CString(""));
		m_MacroAction.SetWindowText(CString(""));

	}
	else
		AfxMessageBox(CString("Nothing to delete."));



}


void CMacroDialog::OnSelchangeMacroList() 
{
	CString temp;
    int i;

	i = m_MacroList.GetCurSel();
	if (i == LB_ERR )
	{
		m_MacroName.SetWindowText(CString(""));
		m_MacroAction.SetWindowText(CString(""));
	}
	else
	{
	m_MacroList.GetText( i, temp );
	m_MacroName.SetWindowText(temp);

	m_ActionList.GetText( i, temp );
	m_MacroAction.SetWindowText(temp);
	}
}

void CMacroDialog::OnOK() 
{

	// TODO: Add extra validation here

	FROTZCEAPP->m_iNumberMacros = m_iNumItems;
	int i;
	CString temp;
	for(i=0;i<m_iNumItems;i++)
	{
		
		m_MacroList.GetText( i, temp );
		FROTZCEAPP->m_sMacroNames[i] = temp;
		m_ActionList.GetText( i, temp );
		FROTZCEAPP->m_sMacroActions[i] = temp;
	}
	

	CDialog::OnOK();
}

void CMacroDialog::OnKillfocusMacroActionEdit() 
{
	CString temp, temp1, temp2;
    int i;
	int x;
	i = m_MacroList.GetCurSel();
	if (i != LB_ERR )
	{
		 m_MacroName.GetWindowText(temp1);
		 m_MacroAction.GetWindowText(temp2);

		x = temp2.GetLength();
		if ((x < 1 ) || (x >30))
		{
			m_MacroList.GetText( i, temp );
			m_MacroAction.SetWindowText(temp);
			AfxMessageBox(CString("Macro Action must be between 1 and 30 characters"));
			m_MacroList.SetCurSel(i);
			return;
		}


		i = m_MacroList.GetCurSel();
		if(m_MacroList.DeleteString( i ) != LB_ERR )
		{
			m_ActionList.DeleteString( i ); 
			m_MacroList.InsertString(i,temp1);
			m_ActionList.InsertString(i,temp2);
		}

		m_MacroList.SetCurSel(i);
	}
}

void CMacroDialog::OnKillfocusMacroNameEdit() 
{
	CString temp, temp1, temp2;
    int i;
	int x;
	i = m_MacroList.GetCurSel();
	if (i != LB_ERR )
	{

		 m_MacroName.GetWindowText(temp1);
		 m_MacroAction.GetWindowText(temp2);

		x = temp1.GetLength();
		if ((x < 1 ) || (x >20))
		{
			m_MacroList.GetText( i, temp );
			m_MacroName.SetWindowText(temp);
			AfxMessageBox(CString("Macro Name must be between 1 and 20 characters"));
			m_MacroList.SetCurSel(i);
			return;
		}

		i = m_MacroList.GetCurSel();
		if(m_MacroList.DeleteString( i ) != LB_ERR )
		{
			m_ActionList.DeleteString( i ); 
			m_MacroList.InsertString(i,temp1);
			m_ActionList.InsertString(i,temp2);
		}

		m_MacroList.SetCurSel(i);
	}	
}
