#!/bin/sh

# This thing is intended primarily to find soundcard.h for use with the
# OSS soundcard driver.  It will first look in <sys/soundcard.h> then
# <soundcard.h>.  Linux systems use the former.  *BSD uses the latter.
# This script will be replaced with something more decent when support for
# more sound drivers is added.  This file will be executed during compile
# even if you aren't using sound.  

INCLUDE1="/usr/include/sys"
INCLUDE2="/usr/include"
SOUNDCARD_H="soundcard.h"
OUTFILE="soundcard.h"

echo "checking for $SOUNDCARD_H"

if [ -f $OUTFILE ] ; then
	exit 0
fi

cat << EOF > $OUTFILE
/*
 * This file automatically generated by findsound.sh which run by the
 * Makefile found in the Unix Frotz 2.41 source distribution.
 * Copying this nasty hack to find headers which may be in any of several
 * places is not recommended.  I didn't want to use autoconf just yet 
 * for this project.
 *
 */

EOF

FILE=$INCLUDE1/$SOUNDCARD_H
if [ -f $FILE ] ; then
	echo "I see we have $FILE..."
	if [ -r $FILE ] ; then
		echo '#include <sys/soundcard.h>' >> $OUTFILE
	else
		echo "Oops...  Can't read it!"
		exit 1
	fi
	exit 0
fi

# I'm too lazy to iterate properly right now

FILE=$INCLUDE2/$SOUNDCARD_H
if [ -f $FILE ] ; then
	echo "I see we have $FILE..."
	if [ -r $FILE ] ; then
		echo '#include <soundcard.h>' >> $OUTFILE
	else
		echo "Oops...  Can't read it!"
		exit 2
	fi
	exit 0
fi


