/* FBMAKE: Make a CP/M + DOS "fat binary"
    Copyright (C) 1996,2000  John Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>


#if CPM
#define AV0 "FBMAKE"
#else
#define AV0 argv[0]
#endif

unsigned char header[256]= {
            0xeb,0x0c,0xc3,0x60,0x01,0x00,0x00,0x00, /* 00-07 */
            0x00,0x00,0x00,0x00,0x00,0x00,0x8b,0x3e, /* 08-0F */
            0x0c,0x01,0xbe,0x20,0x01,0xb9,0x12,0x00, /* 10-17 */
            0xf3,0xa4,0x8b,0x1e,0x0c,0x01,0xff,0xe3, /* 18-1F */
            0xbf,0x00,0x01,0x8b,0x36,0x08,0x01,0x8b, /* 20-27 */
            0x0e,0x0a,0x01,0xf3,0xa4,0xbb,0x00,0x01, /* 28-2F */
            0xff,0xe3,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a, /* 30-37 */
            0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a, /* 38-3F */
            0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a, /* 40-47 */
            0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a, /* 48-4F */
            0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a, /* 50-58 */
            0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a, /* 58-5F */
            0xe5,0xc5,0xd5,0xf5,0x2a,0x08,0x01,0x2e, /* 50-67 */
            0x00,0x24,0x22,0x0c,0x01,0x11,0x86,0x01, /* 68-6F */
            0x06,0x1e,0x1a,0x77,0x13,0x23,0x05,0xc2, /* 70-77 */
            0x72,0x01,0x2a,0x0c,0x01,0x2e,0x15,0x36, /* 78-7F */
            0x0d,0x23,0x74,0x2e,0x00,0xe9,0x2a,0x08, /* 80-87 */
            0x01,0x44,0x4d,0x05,0x05,0x11,0x00,0x01, /* 88-8F */
            0x21,0x00,0x02,0x7e,0x12,0x23,0x13,0x0b, /* 90-97 */
            0x78,0xb1,0xc2,0x93,0x01,0xf1,0xc1,0xe1, /* 98-9F */
            0xd1,0xc3,0x00,0x01 };                   /* A0-A3 */


void helpscr (char *title)
{
    fprintf (stderr,"Syntax is %s cpmfile.com dosfile.com outfile.com\n",title);
    exit(1);
}
 
void fail (char *s, char *t)
{
     fprintf(stderr,"%s: %s() failed\n",s,t);
     exit(1);
}

int main (int argc, char **argv)
{
    FILE *cpmin, *dosin, *outfile;
    unsigned clen;
    unsigned dlen;
    unsigned elen;
    int c;

    clen=0; dlen=0; elen=0;

    if (argc < 4) helpscr(AV0);
    if (!(cpmin=fopen(argv[1],"rb")))   fail (argv[1],"fopen");
    if (!(dosin=fopen(argv[2],"rb")))   fail (argv[2],"fopen");
    if (!(outfile=fopen(argv[3],"wb"))) fail (argv[3],"fopen");

    if ((fwrite (header, sizeof(header), 1, outfile)) != 1) fail (argv[3],"fwrite()");

    c=fgetc(cpmin);
    while (c != EOF)
        {
        if (fputc(c,outfile) == EOF) fail(argv[3],"fputc");
        clen++;
        if (clen > 0xFEFF) 
              {
              fprintf(stderr,"%s: file %s is too big",AV0,argv[1]);
              exit(1);
              }
	c=fgetc(cpmin);
        }
    if (fclose(cpmin)) fail (argv[1],"fclose");
/*    if (fseek(outfile,(clen+0x100),0)) fail (argv[3],"fseek"); */
    c=fgetc(dosin);
    while (c != EOF)
        {
        if (fputc(c,outfile) == EOF) fail(argv[3],"fputc");
        dlen++;
        if (dlen > 0xFEFF) 
              {
              fprintf(stderr,"%s: file %s is too big",AV0,argv[2]);
              exit(1);
              }
	c=fgetc(dosin);
	}
    if (fclose(dosin)) fail (argv[2],"fclose");
    if (fseek(outfile,8,SEEK_SET)) fail (argv[3],"fseek");
    clen+=0x200;           /* CP/M length becomes start of DOS image */
    elen=clen+dlen; /* Combined length in elen */
    if (elen > 0xFEFF) 
              {
              fprintf(stderr,"%s: combined file %s is too big",AV0,argv[3]);
              exit(1);
              }
     fputc((clen & 0xFF),outfile);
     fputc((clen >> 8),outfile);
     fputc((dlen & 0xFF),outfile);
     fputc((dlen >> 8),outfile);
     fputc((elen & 0xFF),outfile);
     fputc((elen >> 8),outfile);
     if (fclose(outfile)) fail (argv[3],"fclose");
     return 0;
}

