/*
 *   T E X 2 A S C . H
 *                   
 */

/*
 *   Copyright (C) 1993 Konrad Schroder.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef TEX2ASC_H_
#define TEX2ASC_H_

#include <stdio.h>

struct Option {
     int gutenberg;      /* conform to the Gutenberg standard */
     int apply_codes;    /* 0 = strip, 1 = ANSI, 2 = ASCII, 3 = IBM_ANSI */
     int footnote;       /* 0 = strip, 1 = leave, 2 = file, 3 = at end */
     int number_lines;   /* only if mode.countlines */
     int number_sec;     /* 0 = strip, 1 = leave */
     int character_set;  /* 0 = unknown, 1 = IBM, 2 = Mac, 3 = Latin1 */
     int few_cr;         /* 1 = don't end lines with a CR/LF/whatever */
     int greek;          /* 0 = ASCII, 1 = GreekKeys, 2 = WinGreek */
};

enum CODES {
     strip_codes,
     ansi_codes,
     ascii_codes,
     ibm_ansi_codes,
     rtf_codes
};

enum GREEK {
     ascii_greek,
     greek_keys,
     win_greek
};

enum FEET {
     strip_notes,
     leave_notes,
     file_notes,
     end_notes
};

enum CHARS {
     ascii_chars,
     ibm_pc_chars,
     mac_chars,
     latin1_chars
};

enum FONTS {
     ROMAN=0,
     ITALICS=1,
     BOLD=2,
     UNDERLINE=4,
     GREEK=8
};

struct k_str {
     char *str;
     long len;
};

struct direc_and_last {
     char c;
     struct k_str direc;
};

typedef struct Mode {
     int obeylines;
     int countlines;     /* yes implies add line numbers */
     int font;           /* ITALICS | BOLD | GREEK | UNDERLINE; ROMAN=0 */
     int underline;      /* 1 or 0 */
     int superscript;    /* unimplemented */
     int subscript;      /* unimplemented */
     int math_mode;      /* currently pointless */
     int foot_mode;      /* is non-zero in the body of footnotes */
     int margin;         /* the current margin; usu. either 60 or 75 */
     int leftmargin;     /* usu. zero */
     int chapcount;      /* chapter number */
     int seccount;       /* section number */
     int linecount;      /* line number */
} MODE;

struct hash {
     char word[20];
     int val;
     char replace_word[20];
     int has_params;
};

#define ML 1024
#define GOOD_MAL 10240
#define VERSION 1
#define SUBVERSION 3
#define streq(A,B) (strcmp((A),(B))==0)

#define TIE         001
#define NOPRINT     002
#define NOINDENT    003
#define NUMBER      004
#define SP_PAR      005
#define DISC_NL     006
#define RSQ         007

#if (defined __MSDOS__ || defined MSDOS  || defined __TURBOC__)
# define DOS
#endif

#if (defined __THINK__)
# define MAC
# include "MacStuff.h"
# define exit(n) ExitToShell()
# define unlink(X) remove(X)
# define malloc(X) NewPtr(X)
# define free(X)   DisposPtr(X)
#endif

int do_file(char *);
void k_zero(struct k_str *);
void output_line(char *, FILE *, int);
void output(char *, FILE *);
void resize(struct k_str *);
void output_paragraph(struct k_str *,  FILE *);
char accent(char, char);
char *chapter(MODE *);
char *section(MODE *);
void add_str(struct k_str *, char *);
void cleanup(MODE, MODE, struct k_str *);
int  get_next_char(void);
void add_char(struct k_str *, char);
void c_print(char *);
char *read_frame(MODE, int, char);
void usage(void);
int main(int argc, char **argv);
int do_file(char *);

#endif /* TEX2ASC_H_ */
