/*
 *
 * F L A G S . C   -    Argument handling for tex2asc.
 *                      (Modified from Hand.)
 */

/*
 *   Copyright (C) 1992, 1993 Konrad Schroder.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "g_getopt.h"
#include "tex2asc.h"

extern struct Option option;

struct g_option longopts[] = {
     {"gutenberg", 0, 0, 'g'},
     {"strip-controls", 0, &option.apply_codes,strip_codes},
     {"ascii-controls", 0, &option.apply_codes,ascii_codes},
     {"ansi-controls", 0, &option.apply_codes,ansi_codes},
     {"nansi-controls", 0, &option.apply_codes, ibm_ansi_codes},
     {"rtf-controls", 0, 0, 'r'},
     {"no-accents", 0, &option.character_set,ascii_chars},
     {"ibm-set", 0, &option.character_set,ibm_pc_chars},
     {"mac-set", 0, &option.character_set,mac_chars},
     {"xterm-set", 0, &option.character_set,latin1_chars},
     {"strip-notes", 0, &option.footnote, 0},
     {"leave-notes", 0, &option.footnote, leave_notes},
     {"end-notes", 0, &option.footnote, end_notes},
     {"file-notes", 0, &option.footnote, file_notes},
     {"number-lines", 2, &option.number_lines, 1},
     {"number-sections", 2, &option.number_sec, 1},
     {"few-crs", 0, &option.few_cr, 1},
     {"fake-greek", 0, &option.greek, 0},
     {"greekkeys",  0, &option.greek, greek_keys},
     {"wingreek", 0, &option.greek, win_greek},
     {0,0,0,0}
};

int longind;

/*
 * envarg(argc, argv, s) tokenizes the environment variable s and adds the
 * tokens to the beginning of argv, preserving the order of the original
 * argv array.
 */

void envarg(int *argp, char ***argv, char *var)
{
     int i, envc;
     char **envv, *s, *t;

     s=(char *)malloc(sizeof(char)*ML); /* used after function termination */

     if(getenv(var)==NULL)
          return;
     else
     {
          strcpy(s,(char *)getenv(var));
          if((t=(char *)strtok(s," "))!=NULL)
          {
               envv=(char **)malloc(sizeof(char *)*(envc=2));
               envv[1]=t;
               while((t=(char *)strtok(NULL," "))!=NULL)
               {
                    envv = (char **)realloc(envv,sizeof(char *)*(++envc));
                    envv[envc-1]=t;
               }
               envv = (char **)realloc(envv,sizeof(char *)*(*argp+envc));
               envv[0]=(*argv)[0];
               for(i=0;i< *argp-1;i++)
                    envv[envc+i]=(*argv)[i+1];
               envv[*argp+envc-1]=NULL;
               *argv = envv;
               *argp += --envc;
          }
          return;
     }
}

/*
 * gethandopt() reads the (modified by envarg) arguments and modifies struct
 * Option option to agree.
 */

int gethandopt(int argc, char **argv, char *infile)
{
     int c;

     /*
      * Option defaults:
      *
      * Number sections and chapters as well as lines
      * in poetry; insert footnotes into the text body, and leave Greek
      * alone, without bothering to translate it to any particular format.
      */

     option.gutenberg=0;
     option.apply_codes=strip_codes;
     option.footnote=leave_notes;
     option.number_lines=1;
     option.number_sec=1;
     option.character_set=ascii_chars;
     
     infile[0]='\0';
 
     while((c=g_getopt_long(argc, argv, "af:grs", longopts, &longind))!=EOF)
     {
          switch(c)
          {
            case 0:
               break; /* processed a long option */
             case 'a':
               option.apply_codes=ascii_codes;
               option.character_set=ascii_chars;
               option.footnote=strip_notes;
               option.number_lines=0;
               option.number_sec=0;
               break;
             case 'g':
               option.gutenberg=1;
               option.apply_codes=strip_codes;
               option.footnote=end_notes;
               option.number_lines=0;
               option.number_sec=0;
               break;
            case 'f':
               strcpy(infile,g_optarg);
               break;
            case 'r':
               option.apply_codes=rtf_codes;
               option.number_lines=0;
               option.number_sec=1;
               option.few_cr=1;
               break;
            case 's':
               option.apply_codes=strip_codes;
               option.footnote=strip_notes;
               option.number_lines=0;
               option.number_sec=0;
               break;
            case '?': default:
               usage();
               exit(0);
          }
     }
     return 0;
}
