#include <StandardFile.h>
#include <Dialogs.h>
#include <Types.h>
#include <Files.h>

WindowRecord	wRecord;
WindowPtr		myWindow;
MenuHandle		myMenu;

#include "tex2asc.h"
#include "MacStuff.h"

extern struct Option option;

#define	ours(w)		((myWindow != NULL) && (w == myWindow))

char *GetFilename(char *fn)
{
     SFTypeList TList;
     SFReply reply;
     Point P;
     int i;
     
     TList[0] = 'TEXT';
     SetPt(&P,100,100);
     
     SFGetFile(P,"\p",0,1,TList,0,&reply);
     if(reply.good==0)
          return NULL;
     for(i=0;i<reply.fName[0];i++)
          fn[i] = reply.fName[i+1];
     fn[i]='\0';
     return fn;
}

void MacStartupStuff(void) 
{
	InitGraf(&thePort);
	InitFonts();
	FlushEvents(everyEvent, 0);
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(0L);
	InitCursor();
	MaxApplZone();
     MoreMasters();
     
	SetUpMenus();
}

int DoMouseDown (int windowPart, WindowPtr whichWindow, EventRecord *myEvent)
     
{
	switch (windowPart) {
        case inMenuBar:
          return(DoCommand(MenuSelect(myEvent->where)));
          
        case inSysWindow:
          SystemClick(myEvent, whichWindow);
          break;
          
        case inContent:
          if (whichWindow != FrontWindow())
               SelectWindow(whichWindow);
          break;
	}
}


int MainEvent(void) 
{
	EventRecord    myEvent;
	WindowPtr		whichWindow;
	short		windowPart;
	Rect			r;
     
	SystemTask();
     
	if (GetNextEvent(everyEvent, &myEvent)) {
		switch (myEvent.what) {
             case mouseDown:
			windowPart = FindWindow(myEvent.where, &whichWindow);
			DoMouseDown(windowPart, whichWindow, &myEvent);
			break;
               
             case keyDown:
             case autoKey: 
			{
                    register char	theChar;
                    
                    theChar = myEvent.message & charCodeMask;
                    if ((myEvent.modifiers & cmdKey) != 0) 
                         return(DoCommand(MenuKey( theChar)));
			}
			break;
               /*
                 case updateEvt: 
                 if (ours((WindowPtr) myEvent.message))
                 UpdateWindow(myWindow);
                 */
			break;
		} /* end of case myEvent.what */
	} /* if */
	return(1);
}

int SetUpMenus(void)
{
	myMenu = GetMenu(129);
	InsertMenu(myMenu, 0) ;
	DrawMenuBar();
}

void RefreshCharacter(DialogPtr DL, struct Option *opt)
{
     short item;
     short iType;
     Handle iHandl;
     Rect iRect;
     
     item = 20;
     GetDItem(DL,item,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(opt->character_set==0));
     SetDItem(DL,item,iType,iHandl,&iRect);
     item = 3;
     GetDItem(DL,item,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(opt->character_set==2));
     SetDItem(DL,item,iType,iHandl,&iRect);
     item = 4;
     GetDItem(DL,item,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(opt->character_set==1));
     SetDItem(DL,item,iType,iHandl,&iRect);
     item = 5;
     GetDItem(DL,item,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(opt->character_set==3));
     SetDItem(DL,item,iType,iHandl,&iRect);
     
     return;
}

void RefreshFootnote(DialogPtr DL, struct Option *opt)
{
     short item, iType;
     Handle iHandl;
     Rect iRect;
     
     item = 9;
     GetDItem(DL,item,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(opt->footnote==0));
     SetDItem(DL,item,iType,iHandl,&iRect);
     item = 10;
     GetDItem(DL,item,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(opt->footnote==3));
     SetDItem(DL,item,iType,iHandl,&iRect);
     item = 14;
     GetDItem(DL,item,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(opt->footnote==1));
     SetDItem(DL,item,iType,iHandl,&iRect);
     item = 15;
     GetDItem(DL,item,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(opt->footnote==2));
     SetDItem(DL,item,iType,iHandl,&iRect);
     
     return;
}

void RefreshEmphasis(DialogPtr DL, struct Option *opt)
{
     short item;
     short iType;
     Handle iHandl;
     Rect iRect;
     
     item = 6;
     GetDItem(DL,item,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(opt->apply_codes==0));
     SetDItem(DL,item,iType,iHandl,&iRect);
     item = 7;
     GetDItem(DL,item,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(opt->apply_codes==2));
     SetDItem(DL,item,iType,iHandl,&iRect);
     item = 8;
     GetDItem(DL,item,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(opt->apply_codes==1));
     SetDItem(DL,item,iType,iHandl,&iRect);
     
     return;
}

void MacOptions(void)
{
     short itemHit;
     short iType;
     DialogPtr DialRec;
     struct Option newOption = option;
     Handle iHandl;
     Rect iRect;
     
     DialRec = GetNewDialog(128,0,(WindowPtr)-1);
     
     RefreshCharacter(DialRec,&newOption);
     RefreshFootnote(DialRec,&newOption);
     RefreshEmphasis(DialRec,&newOption);
     
     itemHit = 16;
     GetDItem(DialRec,itemHit,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(newOption.number_lines==1));
     SetDItem(DialRec,itemHit,iType,iHandl,&iRect);
     
     itemHit = 17;
     GetDItem(DialRec,itemHit,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(newOption.number_sec==1));
     SetDItem(DialRec,itemHit,iType,iHandl,&iRect);
     
     itemHit = 21;
     GetDItem(DialRec,itemHit,&iType,&iHandl,&iRect);
     SetCtlValue(iHandl,(newOption.few_cr==1));
     SetDItem(DialRec,itemHit,iType,iHandl,&iRect);
     
     do {
          ModalDialog(0, &itemHit);
          switch(itemHit)
          {
             case 20:
               newOption.character_set = 0;
               RefreshCharacter(DialRec,&newOption);
               break;
             case 3:
               newOption.character_set = 2;
               RefreshCharacter(DialRec,&newOption);
               break;
             case 4:
               newOption.character_set = 1;
               RefreshCharacter(DialRec,&newOption);
               break;
             case 5:
               newOption.character_set = 3;
               RefreshCharacter(DialRec,&newOption);
               break;
             case 9:
               newOption.footnote = 0;
               RefreshFootnote(DialRec,&newOption);
               break;
             case 10:
               newOption.footnote = 3;
               RefreshFootnote(DialRec,&newOption);
               break;
             case 14:
               newOption.footnote = 1;
               RefreshFootnote(DialRec,&newOption);
               break;
             case 15:
               newOption.footnote = 2;
               RefreshFootnote(DialRec,&newOption);
               break;
             case 6:
               newOption.apply_codes = 0;
               RefreshEmphasis(DialRec,&newOption);
               break;
             case 7:
               newOption.apply_codes = 2;
               RefreshEmphasis(DialRec,&newOption);
               break;
             case 8:
               newOption.apply_codes = 1;
               RefreshEmphasis(DialRec,&newOption);
               break;
             case 16:
               newOption.number_lines = !newOption.number_lines;
               GetDItem(DialRec,itemHit,&iType,&iHandl,&iRect);
               SetCtlValue(iHandl,(newOption.number_lines==1));
               SetDItem(DialRec,itemHit,iType,iHandl,&iRect);
               break;
             case 17:
               newOption.number_sec = !newOption.number_sec;
               GetDItem(DialRec,itemHit,&iType,&iHandl,&iRect);
               SetCtlValue(iHandl,(newOption.number_sec==1));
               SetDItem(DialRec,itemHit,iType,iHandl,&iRect);
               break;
             case 21:
               newOption.few_cr = !newOption.few_cr;
               GetDItem(DialRec,itemHit,&iType,&iHandl,&iRect);
               SetCtlValue(iHandl,(newOption.few_cr==1));
               SetDItem(DialRec,itemHit,iType,iHandl,&iRect);
               break;
          }
     } while(itemHit != 1 && itemHit != 2 && itemHit != 18);
     
     DisposDialog(DialRec);
     if(itemHit != 2)
          option = newOption;
     /*
       if(itemHit == 18)
       { }
       */
     return;
}

int DoCommand(long mResult)
{
	int  theItem;
	char infile[ML];
	
	theItem = LoWord(mResult);
     
     switch(theItem)
     {
        case 1:
          if(GetFilename(infile)==NULL)
               break;
          DisableItem(myMenu,0);
          do_file(infile);
          EnableItem(myMenu,0);
          break;
        case 2:
          MacOptions();
          break;
        case 3:
          exit(0);
     }
	HiliteMenu(0);
	return(1);
}

void SetFileToMyType(char *s)
{
     Str255 fn;
     FInfo info;
     
     fn[1] = (char)strlen(s);
     strcpy((char *)fn+1,s);
     GetFInfo(fn,0,&info);
     info.fdCreator = 'MSWD';
     SetFInfo(fn,0,&info);
     return;
}

void MacDisplayWarning(char *s)
{
     Str255 text;
     
     text[0] = (char)strlen(s);
     strcpy((char *)text+1,s);
     ParamText(text,"\p","\p","\p");
     CautionAlert(256,0);
     return;
}


