/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Chat
extends Applet
implements Runnable {
    protected ChatProtocal Pthread;
    protected int ColumnLength;
    protected StringTokenizer MToken;
    protected String ParsedMessage;
    protected String LineMessage;
    protected String TmpMessage;
    protected boolean UpdateList = true;
    protected boolean ShowDialog = false;
    protected Thread runner;
    protected static ChatProperties P = new ChatProperties();
    protected static Chat ChatClient;
    private static boolean isApplet;
    private static AppletFrame ChatFrame;
    private Panel MainDisplay;
    private Panel ConfigPanel;
    private Panel ChatPanel;
    private List UserList;
    private Label UserListLabel;
    private TextArea MessageScreen;
    private int TotalMessageLength;
    private TextField InputField;
    private Button ConnectionButton;
    private Button ConfigButton;
    private Button ConnectNowButton;
    private Button DesktopButton;
    private Checkbox URLCheck;
    private Checkbox SoundCheck;
    private Panel RightPanel;
    private Panel RightPanelPart;
    private Panel ButtonPanel;
    private Panel InputPanel;
    private Panel InputPanelPart;
    private Panel CheckboxPanel;
    private Button SaveButton;
    private Button CancelButton;
    private Panel LogoPanel;
    private Panel LoginScreen;
    private Choice ServerChoice;
    private TextField InputServerField = new TextField(30);
    private TextField InputPortField = new TextField(10);
    private TextField InputNickField = new TextField(10);
    private TextField InputChannelField = new TextField(10);
    private TextField InputRealNameField = new TextField(30);
    private Panel ActionPanel;
    private GridBagLayout GridBag;
    private GridBagLayout GridBag2;
    private GridBagConstraints c;
    private Label LabelServer = new Label("Server Name:");
    private Label LabelPort = new Label("Server Port:");
    private Label LabelNick = new Label("Nick Name:");
    private Label LabelChannel = new Label("Channel:");
    private Label LabelRealName = new Label("Real Name:");
    private Canvas Hline1;
    private Canvas Hline2;
    private Canvas Hline3;
    private Canvas Hline4;
    private Canvas Vline1;
    private Canvas Vline2;
    private Canvas Vline3;
    private Canvas Vline4;
    private Panel LoginPanel;
    private Panel LoginWrapper;
    private Image JavaLogo;
    private LogoCanvas LogoContainer;
    private Panel CreditPanel;
    private Panel LogoCreditPanel;
    private Panel LogoWrapper;
    private Label AutherLabel;
    private Label VersionLabel;
    private Label EmailLabel;
    private static MenuBar ChatFrameMenu;
    private static Menu FileMenu;
    private static MenuItem ExitMenu;
    private CardLayout MainLayout;
    private ConfigReader Reader;
    private String ConfigEntry;
    private String tmp;
    private String ConfigKey;
    private String ConfigVal;
    private int i;
    private int j;
    private String InputString;
    private boolean isConnected = false;

    public Chat() {
        if (!isApplet) {
            this.init();
            this.start();
        }
    }

    public void init() {
        this.readConfig();
        this.createConfigPanel();
        this.createChatPanel();
        try {
            Chat.P.HostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Failed to resolved hostname");
        }
        this.MainLayout = new CardLayout();
        this.MainDisplay = new Panel();
        this.MainDisplay.setLayout(this.MainLayout);
        this.MainDisplay.add("Config", this.ConfigPanel);
        this.MainDisplay.add("Chat", this.ChatPanel);
        this.MainLayout.show(this.MainDisplay, "Config");
        this.setLayout(new BorderLayout(Chat.P.BorderHsp, Chat.P.BorderVsp));
        this.add("North", new Canvas());
        this.add("South", new Canvas());
        this.add("West", new Canvas());
        this.add("East", new Canvas());
        this.add("Center", this.MainDisplay);
        this.TotalMessageLength = this.MessageScreen.getText().length();
    }

    public void readConfig() {
        if (isApplet) {
            int n = 0;
            while (n <= 18) {
                this.ConfigKey = Chat.P.Alltargets[n];
                this.ConfigVal = this.getParameter(this.ConfigKey);
                if (this.ConfigVal != null) {
                    P.setProperties(this.ConfigKey, this.ConfigVal);
                }
                ++n;
            }
            return;
        }
        this.Reader = new ConfigReader();
        int n = 0;
        while (n <= this.Reader.ConfigVector.size() - 1) {
            this.ConfigEntry = (String)this.Reader.ConfigVector.elementAt(n);
            try {
                int n2 = this.ConfigEntry.indexOf(":");
                if (n2 != -1) {
                    this.ConfigKey = this.ConfigEntry.substring(0, n2);
                    this.ConfigVal = this.ConfigEntry.substring(n2 + 1);
                    P.setProperties(this.ConfigKey, this.ConfigVal);
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
            ++n;
        }
    }

    public void createConfigPanel() {
        this.GridBag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.insets = new Insets(Chat.P.BorderVsp, Chat.P.BorderHsp, 0, Chat.P.BorderHsp);
        this.ServerChoice = new Choice();
        this.ServerChoice.addItem(Chat.P.ServerName1);
        this.ServerChoice.addItem(Chat.P.ServerName2);
        this.ServerChoice.addItem(Chat.P.ServerName3);
        this.ServerChoice.addItem(Chat.P.ServerName4);
        this.ServerChoice.addItem(Chat.P.ServerName5);
        this.LoginScreen = new Panel();
        this.LoginScreen.setLayout(this.GridBag);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 13;
        ((TextComponent)this.InputNickField).setText(Chat.P.NickName);
        this.addToGridBag(this.LoginScreen, this.LabelNick, this.GridBag, this.c, 0, 0, 1, 1);
        this.c.anchor = 17;
        this.addToGridBag(this.LoginScreen, this.InputNickField, this.GridBag, this.c, 1, 0, 1, 1);
        this.c.anchor = 13;
        ((TextComponent)this.InputChannelField).setText(Chat.P.Channel);
        this.addToGridBag(this.LoginScreen, this.LabelChannel, this.GridBag, this.c, 0, 1, 1, 1);
        this.c.anchor = 17;
        this.addToGridBag(this.LoginScreen, this.InputChannelField, this.GridBag, this.c, 1, 1, 1, 1);
        this.c.anchor = 13;
        ((TextComponent)this.InputRealNameField).setText(Chat.P.RealName);
        this.addToGridBag(this.LoginScreen, this.LabelRealName, this.GridBag, this.c, 0, 2, 1, 1);
        this.c.anchor = 17;
        this.addToGridBag(this.LoginScreen, this.InputRealNameField, this.GridBag, this.c, 1, 2, 2, 1);
        this.c.anchor = 13;
        ((TextComponent)this.InputServerField).setText(Chat.P.ServerName);
        this.addToGridBag(this.LoginScreen, this.LabelServer, this.GridBag, this.c, 0, 3, 1, 1);
        this.c.anchor = 17;
        this.addToGridBag(this.LoginScreen, this.InputServerField, this.GridBag, this.c, 1, 3, 2, 1);
        this.c.anchor = 17;
        this.addToGridBag(this.LoginScreen, this.ServerChoice, this.GridBag, this.c, 1, 4, 2, 1);
        this.c.anchor = 13;
        ((TextComponent)this.InputPortField).setText(Integer.toString(Chat.P.ServerPort));
        this.addToGridBag(this.LoginScreen, this.LabelPort, this.GridBag, this.c, 0, 5, 1, 1);
        this.c.anchor = 17;
        this.c.insets = new Insets(Chat.P.BorderVsp, Chat.P.BorderHsp, Chat.P.BorderVsp, Chat.P.BorderHsp);
        this.addToGridBag(this.LoginScreen, this.InputPortField, this.GridBag, this.c, 1, 5, 2, 1);
        this.Hline1 = new Canvas();
        this.Hline1.resize(10, 1);
        this.Hline1.setBackground(Color.white);
        this.Hline2 = new Canvas();
        this.Hline2.resize(10, 1);
        this.Hline2.setBackground(Color.white);
        this.Vline1 = new Canvas();
        this.Vline1.resize(1, 10);
        this.Vline1.setBackground(Color.white);
        this.Vline2 = new Canvas();
        this.Vline2.resize(1, 10);
        this.Vline2.setBackground(Color.white);
        this.LoginWrapper = new Panel();
        this.LoginWrapper.setLayout(new BorderLayout());
        this.LoginWrapper.add("North", this.Hline1);
        this.LoginWrapper.add("South", this.Hline2);
        this.LoginWrapper.add("West", this.Vline1);
        this.LoginWrapper.add("East", this.Vline2);
        this.LoginWrapper.add("Center", this.LoginScreen);
        this.ActionPanel = new Panel();
        this.ActionPanel.setLayout(new FlowLayout(1, Chat.P.BorderHsp, Chat.P.BorderVsp));
        this.ConnectNowButton = new Button("Connect Now!");
        this.SaveButton = new Button("Save Config");
        this.CancelButton = new Button("Cancel");
        this.ActionPanel.add(this.SaveButton);
        this.ActionPanel.add(this.CancelButton);
        this.ActionPanel.add(this.ConnectNowButton);
        this.LogoPanel = new Panel();
        this.LogoPanel.setLayout(new BorderLayout(Chat.P.BorderHsp, 0));
        this.LogoPanel.setBackground(Color.white);
        this.LogoContainer = isApplet ? new LogoCanvas(this.getCodeBase()) : new LogoCanvas();
        this.LogoContainer.resize(Chat.P.LogoWidth, Chat.P.LogoHeight);
        this.LogoContainer.setBackground(Color.white);
        this.LogoWrapper = new Panel();
        this.LogoWrapper.add(this.LogoContainer);
        this.CreditPanel = new Panel();
        this.CreditPanel.setLayout(new GridLayout(3, 1));
        this.CreditPanel.setBackground(Color.white);
        this.AutherLabel = new Label("Auther: Brian Lam");
        this.AutherLabel.setForeground(Color.red);
        this.VersionLabel = new Label("Version: 2.0");
        this.VersionLabel.setForeground(Color.red);
        this.EmailLabel = new Label("E-mail: faigor@best.com");
        this.EmailLabel.setForeground(Color.red);
        this.CreditPanel.add(this.AutherLabel);
        this.CreditPanel.add(this.VersionLabel);
        this.CreditPanel.add(this.EmailLabel);
        this.LogoCreditPanel = new Panel();
        this.LogoCreditPanel.setLayout(new BorderLayout(Chat.P.BorderHsp, Chat.P.BorderVsp));
        this.LogoCreditPanel.add("North", this.LogoWrapper);
        this.LogoCreditPanel.add("South", this.CreditPanel);
        this.Vline3 = new Canvas();
        this.Vline3.setBackground(Color.black);
        this.Vline3.resize(2, 10);
        this.Vline4 = new Canvas();
        this.Vline4.setBackground(Color.black);
        this.Vline4.resize(2, 10);
        this.Hline3 = new Canvas();
        this.Hline3.setBackground(Color.black);
        this.Hline3.resize(10, 2);
        this.Hline4 = new Canvas();
        this.Hline4.setBackground(Color.black);
        this.Hline4.resize(10, 2);
        this.LogoPanel.add("Center", this.LogoCreditPanel);
        this.LogoPanel.add("East", this.Vline3);
        this.LogoPanel.add("West", this.Vline4);
        this.LogoPanel.add("North", this.Hline3);
        this.LogoPanel.add("South", this.Hline4);
        this.ConfigPanel = new Panel();
        this.ConfigPanel.setBackground(Color.lightGray);
        this.ConfigPanel.setLayout(new BorderLayout(Chat.P.BorderHsp, Chat.P.BorderVsp));
        this.ConfigPanel.add("West", this.LogoPanel);
        this.ConfigPanel.add("Center", this.LoginWrapper);
        this.ConfigPanel.add("South", this.ActionPanel);
    }

    public void createChatPanel() {
        this.InputPanel = new Panel();
        this.InputField = new TextField("", Chat.P.TextFieldLength);
        this.ConnectionButton = new Button("Connect    ");
        this.ConfigButton = new Button("Config");
        this.DesktopButton = new Button("Desktop");
        this.InputPanelPart = new Panel();
        this.InputPanelPart.add(this.ConnectionButton);
        this.InputPanelPart.add(this.ConfigButton);
        if (isApplet) {
            this.InputPanelPart.add(this.DesktopButton);
        }
        this.InputPanel.setLayout(new BorderLayout());
        this.InputPanel.add("East", this.InputPanelPart);
        this.InputPanel.add("Center", this.InputField);
        this.URLCheck = new Checkbox("Allow URL");
        this.URLCheck.setState(Chat.P.AllowURL);
        this.SoundCheck = new Checkbox("Allow Sound");
        this.SoundCheck.setState(Chat.P.AllowSound);
        this.CheckboxPanel = new Panel();
        this.CheckboxPanel.setLayout(new GridLayout(2, 1));
        this.CheckboxPanel.add(this.URLCheck);
        this.CheckboxPanel.add(this.SoundCheck);
        this.RightPanel = new Panel();
        this.RightPanel.setLayout(new BorderLayout());
        this.UserList = new List(1, false);
        this.UserList.setForeground(Color.blue);
        this.UserList.setBackground(new Color(234, 233, 209));
        this.UserListLabel = new Label("Channel : # People");
        this.RightPanel.add("West", this.UserList);
        this.RightPanel.add("South", this.CheckboxPanel);
        this.RightPanel.add("North", this.UserListLabel);
        this.ChatPanel = new Panel();
        this.ChatPanel.setLayout(new BorderLayout(Chat.P.BorderHsp, Chat.P.BorderVsp));
        this.MessageScreen = new TextArea(Chat.P.WelcomeMessage);
        this.MessageScreen.appendText("\n");
        this.MessageScreen.setEditable(false);
        this.ChatPanel.add("South", this.InputPanel);
        this.ChatPanel.add("East", this.RightPanel);
        this.ChatPanel.add("Center", this.MessageScreen);
        Canvas canvas = new Canvas();
        canvas.setBackground(Color.black);
        this.ChatPanel.add("North", canvas);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 201: {
                this.exitChat();
                return true;
            }
            case 1001: {
                if (event.arg.equals("Config")) {
                    this.switchToConfigPanel();
                    return true;
                }
                if (event.target == this.URLCheck) {
                    Chat.P.AllowURL = this.URLCheck.getState();
                    return true;
                }
                if (event.target == this.SoundCheck) {
                    Chat.P.AllowSound = this.SoundCheck.getState();
                    return true;
                }
                if (event.target == this.ServerChoice) {
                    this.handleSelectedServer(event);
                    return true;
                }
                if (event.target == this.ConnectNowButton) {
                    this.handleConfigSave(1);
                    this.connectionRequest(event);
                    return true;
                }
                if (event.target == this.SaveButton) {
                    this.handleConfigSave(0);
                    return true;
                }
                if (event.target == this.CancelButton) {
                    this.handleConfigCancel();
                    return true;
                }
                if (event.target == this.ConnectionButton) {
                    this.connectionRequest(event);
                    return true;
                }
                if (event.target == this.UserList) {
                    this.handleSelectedList(event);
                    return true;
                }
                if (event.target == this.DesktopButton) {
                    this.handleDesktopButton(event);
                    return true;
                }
                if (event.target == this.InputField) {
                    this.processInput(event);
                    return true;
                }
                if (event.target == ExitMenu) {
                    this.exitChat();
                    return true;
                }
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public void handleConfigSave(int n) {
        Chat.P.NickName = this.InputNickField.getText();
        Chat.P.Channel = this.InputChannelField.getText();
        Chat.P.RealName = this.InputRealNameField.getText();
        Chat.P.ServerName = this.InputServerField.getText();
        Chat.P.ServerPort = new Integer(this.InputPortField.getText());
        Chat.P.NickName = Chat.P.NickName.replace(' ', '_');
        Chat.P.Channel = Chat.P.Channel.replace(' ', '_');
        Chat.P.ServerName = Chat.P.ServerName.replace(' ', '_');
        ((TextComponent)this.InputNickField).setText(Chat.P.NickName);
        ((TextComponent)this.InputChannelField).setText(Chat.P.Channel);
        ((TextComponent)this.InputRealNameField).setText(Chat.P.RealName);
        ((TextComponent)this.InputServerField).setText(Chat.P.ServerName);
        ((TextComponent)this.InputPortField).setText(Integer.toString(Chat.P.ServerPort));
        if (n == 1) {
            this.switchToChatPanel();
        }
    }

    public void handleConfigCancel() {
        ((TextComponent)this.InputNickField).setText(Chat.P.NickName);
        ((TextComponent)this.InputChannelField).setText(Chat.P.Channel);
        ((TextComponent)this.InputRealNameField).setText(Chat.P.RealName);
        ((TextComponent)this.InputServerField).setText(Chat.P.ServerName);
        ((TextComponent)this.InputPortField).setText(Integer.toString(Chat.P.ServerPort));
        this.switchToChatPanel();
    }

    public void handleDesktopButton(Event event) {
        if (event.arg.equals("Desktop")) {
            ChatFrame = new AppletFrame(this, "Java Chat Client!");
            ChatFrame.setLayout(new BorderLayout(Chat.P.BorderHsp, Chat.P.BorderVsp));
            ChatFrame.add("North", new Canvas());
            ChatFrame.add("South", new Canvas());
            ChatFrame.add("West", new Canvas());
            ChatFrame.add("East", new Canvas());
            this.remove(this.MainDisplay);
            ChatFrame.add("Center", this.MainDisplay);
            ChatFrame.resize(ChatProperties.WindowWidth, ChatProperties.WindowHeight);
            ChatFrameMenu = new MenuBar();
            FileMenu = new Menu("File");
            ExitMenu = new MenuItem("Exit");
            FileMenu.add(ExitMenu);
            ChatFrameMenu.add(FileMenu);
            ChatFrame.setMenuBar(ChatFrameMenu);
            ExitMenu.disable();
            this.DesktopButton.setLabel("Browser");
            ChatFrame.show();
            return;
        }
        ChatFrame.remove(this.MainDisplay);
        ChatFrame.dispose();
        this.hide();
        this.add("Center", this.MainDisplay);
        ExitMenu.enable();
        this.validate();
        this.show();
        this.DesktopButton.setLabel("Desktop");
    }

    public void handleSelectedServer(Event event) {
        ((TextComponent)this.InputServerField).setText((String)event.arg);
    }

    public void handleSelectedList(Event event) {
        String string = (String)event.arg;
        if (this.Pthread.isAlive()) {
            if (string.startsWith("@")) {
                this.Pthread.requestUserInfo(string.substring(1));
                return;
            }
            if (string.startsWith("+")) {
                this.Pthread.requestUserInfo(string.substring(1));
                return;
            }
            this.Pthread.requestUserInfo(string);
        }
    }

    public void processInput(Event event) {
        this.InputString = this.InputField.getText();
        ((TextComponent)this.InputField).setText("");
        if (this.isConnected) {
            this.Pthread.handleUserInput(this.InputString);
            return;
        }
        this.printMessage("Not connected to server");
        this.printMessage(this.InputString);
    }

    public void connectionRequest(Event event) {
        if (this.ConnectionButton.getLabel().equals("Connect    ")) {
            this.printMessage("Connectiong to " + Chat.P.ServerName + " " + Chat.P.ServerPort + " ......");
            this.ConnectionButton.setLabel("Disconnect ");
            this.ActionPanel.remove(this.ConnectNowButton);
            if (this.runner == null) {
                this.runner = new Thread(this);
            } else {
                this.runner.stop();
                this.runner = new Thread(this);
            }
            this.runner.start();
            return;
        }
        if (this.Pthread != null && this.Pthread.isAlive()) {
            this.Pthread.logoutServer();
            this.Pthread.handleConnectionClose();
        }
        this.closeConnection();
        this.ActionPanel.add(this.ConnectNowButton);
    }

    public void switchToConfigPanel() {
        this.MainLayout.show(this.MainDisplay, "Config");
    }

    public void switchToChatPanel() {
        this.MainLayout.show(this.MainDisplay, "Chat");
    }

    public void printMessage(String string) {
        this.ParsedMessage = string;
        this.MessageScreen.appendText(String.valueOf(this.ParsedMessage) + "\n");
        this.TotalMessageLength += new String(String.valueOf(this.ParsedMessage) + "\n").length();
        this.MessageScreen.select(this.TotalMessageLength, this.TotalMessageLength);
    }

    public void handleConnectionClose() {
        this.isConnected = false;
        Chat.P.ValidNickName = "";
        Chat.P.ValidChannel = "";
        if (this.runner != null) {
            this.runner.stop();
        }
        this.printMessage("Connection closed.");
        this.ConnectionButton.setLabel("Connect    ");
    }

    public void run() {
        if (Chat.P.Type.equals("4m")) {
            try {
                Protocal4m protocal4m = (Protocal4m)Class.forName("Protocal4m").newInstance();
                protocal4m.addGUI(this);
                protocal4m.start();
                this.Pthread = new ChatProtocal(protocal4m);
                return;
            }
            catch (Exception exception) {
                this.printMessage("Failed to load 4m protocal.");
                return;
            }
        }
        try {
            ProtocalIRC protocalIRC = (ProtocalIRC)Class.forName("ProtocalIRC").newInstance();
            protocalIRC.addGUI(this);
            protocalIRC.start();
            this.Pthread = new ChatProtocal(protocalIRC);
            return;
        }
        catch (Exception exception) {
            this.printMessage("Load IRC class failed." + exception.toString());
            return;
        }
    }

    public void start() {
        if (isApplet && !Chat.P.Debug && this.isNetscape()) {
            AccessRequester.enableSocket();
        }
    }

    public void stop() {
    }

    public void exitChat() {
        if (this.Pthread != null && this.Pthread.isAlive()) {
            this.Pthread.logoutServer();
            this.Pthread.handleConnectionClose();
        }
        this.closeConnection();
        if (!isApplet) {
            ChatFrame.dispose();
            System.exit(0);
        }
    }

    public void closeConnection() {
        Chat.P.ValidNickName = "";
        Chat.P.ValidChannel = "";
        this.isConnected = false;
        if (this.runner != null) {
            this.runner.stop();
        }
        this.printMessage("Connection closed.");
        this.ConnectionButton.setLabel("Connect    ");
    }

    protected boolean displayURL(String string) {
        String string2 = string;
        if (!isApplet || !Chat.P.AllowURL) {
            return false;
        }
        try {
            URL uRL = new URL(string2);
            this.getAppletContext().showDocument(uRL, "JAVACHAT_WIN");
        }
        catch (Exception exception) {
            this.printMessage("*** Displaying URL error: " + string2);
            return false;
        }
        return true;
    }

    public void cleanScreen() {
        this.MessageScreen.setText("");
        this.TotalMessageLength = 0;
    }

    public boolean isItApplet() {
        return isApplet;
    }

    public void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    private void addToGridBag(Panel panel, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        panel.add(component);
    }

    protected void removeAllUserList() {
        this.UserList.clear();
        this.UserListLabel.setText("Channel : # People");
    }

    protected void createUserList() {
        this.UserList.clear();
        this.UserListLabel.setText(String.valueOf(Chat.P.ValidChannel) + " :   People");
    }

    protected void addToUserList(String string) {
        string = string.trim();
        this.UserList.addItem(string);
        this.UserListLabel.setText(String.valueOf(Chat.P.ValidChannel) + " : " + this.UserList.countItems() + " People");
    }

    protected void removeFromUserList(String string) {
        string = string.trim();
        int n = 0;
        while (n <= this.UserList.countItems() - 1) {
            if (this.UserList.getItem(n).equals(string) || this.UserList.getItem(n).equals("@" + string)) {
                this.UserList.delItem(n);
                break;
            }
            ++n;
        }
        this.UserListLabel.setText(String.valueOf(Chat.P.ValidChannel) + " : " + this.UserList.countItems() + " People");
    }

    protected boolean isNetscape() {
        String string = System.getProperty("java.vendor");
        try {
            if (!isApplet) {
                return false;
            }
            return string.indexOf("Netscape") != -1;
        }
        catch (SecurityException securityException) {
            System.out.println("Unable to get VM vendor");
            System.out.println("Assuming non Netscpae browser");
            return false;
        }
    }

    public static void main(String[] stringArray) {
        isApplet = false;
        ChatClient = new Chat();
        ChatFrame = new AppletFrame(ChatClient, "Java Chat Client!");
        ChatFrame.setLayout(new BorderLayout(Chat.P.BorderHsp, Chat.P.BorderVsp));
        ChatFrame.add("North", new Canvas());
        ChatFrame.add("South", new Canvas());
        ChatFrame.add("West", new Canvas());
        ChatFrame.add("East", new Canvas());
        ChatFrame.add("Center", ChatClient);
        ChatFrameMenu = new MenuBar();
        FileMenu = new Menu("File");
        ExitMenu = new MenuItem("Exit");
        FileMenu.add(ExitMenu);
        ChatFrameMenu.add(FileMenu);
        ChatFrame.setMenuBar(ChatFrameMenu);
        ChatFrame.resize(ChatProperties.WindowWidth, ChatProperties.WindowHeight);
        ChatFrame.validate();
        ChatFrame.show();
    }

    static {
        isApplet = true;
    }
}

