Unit Twuch;
interface
uses
  Crt,UCH,TwScr,FParser;
{ Tradewars user configurable help driver }

Procedure SetHelpFile;

Procedure TradeHelp;

implementation
var
  TwHelpFile : string;

Procedure SetHelpFile;
var
  X,Y : integer;
BEGIN
  SaveScreen(X,Y);
  ClrScr;
  WriteLn(' Enter the name of the new help file ');
  ReadLn(TwHelpFile);
  RestoreScreen;
  NormalVideo;
  GotoXY(X,Y);
END;

Procedure TradeHelp;
var
  FName : string;
  F : text;
  n,X,Y,io : integer;
BEGIN
  SaveScreen(X,Y);
  ClrScr;
  FName := TwHelpFile;
  Assign(F,FName);
  {$I-} Reset(F); {$I+}
  io := ioresult;
  if io = 0 then begin
  ReadUCHMenu(F);
  REPEAT
    DisplayUCHMenu;
    n := SelectUCHMenuItem;
    If (n <> ExitUCHMenu) then begin
      ShowUCHMenuItem(n,FName);
    end;
  UNTIL (n = ExitUCHMenu);
  end
  else begin
    TextColor(LightRed);
    GotoXY(10,5);
    WriteLn(' The Help File [',TwHelpFile,'] Cannot Be Found. ');
    Delay(3000);
  end;
  RestoreScreen;
  NormalVideo;
  GotoXY(X,Y);
END;

Procedure HelpFileSetup;
const
  ComCfg = 'TWFT.CFG';
  OtherCfg = 'TWSHELL.CFG';
var
  F : text;
  j, io : integer;
  S : string;
  P : ParseType;
  toks : integer;
  tokstr : string;
  ec1 : Integer;
  t : Boolean;

BEGIN
  tokstr := ' ='+#10+#13+#8+#9;
  t := FALSE;
  if (ParamCount > 1) then begin
    for j := 1 to ParamCount-1 do begin
      if MatchToken(ParamStr(j),'help') then begin
        TwHelpFile := ParamStr(j+1);
        t := TRUE;
      end;
    end; { for j }
  end;
  if NOT t then begin
  Assign(F,ComCfg);
  {$I-} Reset(F); {$I+}
  io := ioresult;
  if io = 0 then begin
    While NOT EOF(F) do begin
      ReadLn(F,S);
      toks := Parse_Str(tokstr,S,P);
      if (toks > 0) and MatchToken(P.s[0],'help') then
        TwHelpFile := P.s[toks-1];
    end;
    Close(F);
  end
  else begin
    Assign(F,OtherCfg);
    {$I-} Reset(F); {$I+}
    io := ioresult;
    if io = 0 then begin
      While NOT EOF(F) do begin
        ReadLn(F,S);
        toks := Parse_Str(tokstr,S,P);
        if (toks > 0) and MatchToken(P.s[0],'help') then
          TwHelpFile := P.s[toks-1];
      end;
      Close(F);
    end
  end; { else begin }
  end; { if not t }
END;


BEGIN
  TwHelpFile := 'TWHELP.UCH';
  HelpFileSetup;
END.
