{$V-}
Unit TwTrad2;

{
Copyright (C) 1993 by David Myers.  All rights reserved.  Personal
copying and use of this code permitted.  This source cannot be
sold or distributed for more than the cost of media.
}

Interface
Uses
  Crt, FlyCom, FParser, TwBuffer, TwScr, TwAnsi, TwLine, TwTrade;
Var
  RobFactor : real;

Procedure Trade;

Procedure Steal;

Procedure FivePointSteal;

Procedure MultiSteal;

Procedure HalfSteal;

Procedure OnePortTrade;

Procedure RobAPort; { we're working on it... }

Implementation


Procedure Trade;
Label
  NoTrade;

Var
  Port1, Port2, Port1Buy, Port2Buy, tokstr, S : String;
  P1b, P1s : real3;
  P2b, P2s : real3;
  P1F, P2F : Real3;
  NTraded, MaxNBought : integer;
  P1_4Sale,P2_4Sale : integer;
  P1Haggle, P2Haggle : Integer;
  P1Buy, P2Buy : integer;
  TotHolds,SumHolds : integer;
  Holds : Int3;
  Loop : Boolean;
  X,Y,i,toks,ec1 : integer;
  P : parsetype;

BEGIN
  tokstr := ' ,:;'+#8+#9+#10+#13;
  SaveScreen(X,Y);
  Window(35,5,70,15);
  YellowVideo;
  ClrScr;
  Loop := TRUE;
  Write('           Port 1: ');
  BuildString(Port1);
  WriteLn;
  { tokenize the string and take the first token to kill any leading
    blanks or tabs }
  toks := Parse_Str(tokstr,Port1,P);
  If toks > 0 then
    Port1 := P.s[0]
  else goto NoTrade;
  Write('      Port 1 Type: ');
  BuildString(Port1Buy);
  WriteLn;
  toks := Parse_Str(tokstr,Port1Buy,P);
  If toks > 0 then
    Port1Buy := P.s[0]
  else goto NoTrade;

  { if somebody enters a port class, convert it to the 3 char string }
  If ((length(Port1Buy) = 1) and (isdigit(Port1Buy[1]))) then
    Port1Buy := ClassStr[Ord(Port1Buy[1]) - Ord('0')];
  Write('           Port 2: ');
  BuildString(Port2);
  WriteLn;
  toks := Parse_Str(tokstr,Port2,P);
  If toks > 0 then
    Port2 := P.s[0]
  else goto NoTrade;
  Write('      Port 2 Type: ');
  BuildString(Port2Buy);
  WriteLn;
  toks := Parse_Str(tokstr,Port2Buy,P);
  If toks > 0 then
    Port2Buy := P.s[0]
  else goto NoTrade;
  { if somebody enters a port class, convert it to the 3 char string }
  If ((length(Port2Buy) = 1) and (isdigit(Port2Buy[1]))) then
    Port2Buy := ClassStr[Ord(Port2Buy[1]) - Ord('0')];

  { Find out how many products we can trade and other tedious goodies }

  Process_Port_Pair(Port1Buy,Port2Buy,NTraded,P1Buy,P2Buy,
                    P1Haggle,P2Haggle,P1_4Sale,P2_4Sale);

  { if we have products to trade, then trade }
  If (NTraded > 0) THEN
    BEGIN
      WriteLn(' Num. Products Traded = ',NTraded);
      REPEAT
        Write(' How many Holds to Trade with : ');
        BuildString(S);
        WriteLn;
        toks := Parse_Str(tokstr,S,P);
        If (toks > 0) then begin
          Val(P.s[0],TotHolds,ec1);
          if ec1 <> 0 then
            TotHolds := -1;
        end
        else goto NoTrade;
      UNTIL (TotHolds > 0);
      if (TotHolds < 200) then begin
        for i := 1 to 3 do begin
          P1F[i] := DefaultFactor;
          P2F[i] := DefaultFactor;
          P1B[i] := DefaultBuy;
          P1S[i] := DefaultSell;
          P2B[i] := DefaultBuy;
          P2S[i] := DefaultSell;
        end;
      end
      else if (TotHolds < 251) then begin
        for i := 1 to 3 do begin
          P1F[i] := 1.43*DefaultFactor;
          P2F[i] := 1.43*DefaultFactor;
          P1B[i] := Sqrt(DefaultBuy);
          P1S[i] := Sqrt(DefaultSell);
          P2B[i] := Sqrt(DefaultBuy);
          P2S[i] := Sqrt(DefaultSell);
        end;
      end
      else begin
        for i := 1 to 3 do begin
          P1F[i] := 1.43*DefaultFactor;
          P2F[i] := 1.43*DefaultFactor;
          P1B[i] := Sqrt(Sqrt(DefaultBuy));
          P1S[i] := Sqrt(Sqrt(DefaultSell));
          P2B[i] := Sqrt(Sqrt(DefaultBuy));
          P2S[i] := Sqrt(Sqrt(DefaultSell));
        end;
      end;
      For i := 1 to 3 do begin
        Holds[i] := -1;
        If (Port1Buy[i] <> 'X') and (Port1Buy[i] <> 'Y') then begin
          Write(' How Many Holds For ',StrProd[i],': ');
          BuildString(S);
          WriteLn;
          toks := Parse_Str(tokstr,S,P);
          If (toks > 0) then begin
            Val(P.s[0],Holds[i],ec1);
            if ec1 <> 0 then
              Holds[i] := -1;
          end;
          { check for zero valued holds.  If Holds = 0, then
            user must not want to trade the product }
          If (Holds[i] = 0) then begin
            If Port1Buy[i] = 'S' then begin
              Port1Buy[i] := 'Y';
              Dec(P1Buy);
              { don't give product any holds if we aren't trading it }
            end;
            If Port1Buy[i] = 'B' then begin
              Port1Buy[i] := 'X';
              Dec(P1Haggle);
              { Can't Haggle for it if it isn't onboard }
            end;
            If Port2Buy[i] = 'S' then begin
              Port2Buy[i] := 'Y';
              Dec(P2Buy);
              { don't give product any holds if we aren't trading it }
            end;
            If Port2Buy[i] = 'B' then begin
              Port2Buy[i] := 'X';
              Dec(P2Haggle);
              { Can't haggle for it if it isn't onboard }
            end;
          end;
        end;
      end;

      { trap any weirdness before we divide by P1Buy or P2Buy }
      If (P1Buy < 1) then
        P1Buy := 1;
      If (P2Buy < 1) then
        P2Buy := 1;

      {
        idiot proof input. Set it up so that entering a number of
        holds = -1 equally divides holds between products.  Note
        algorithm works best when holds evenly divisible by 6.
        TWFT 0.94 and up:
        Note algorithm has been reworked so that any mixture of
        -1s, 0s, and positive hold numbers can be mixed.  If the
        sum of the number of holds is less than the number of
        total holds you enter, we assume the user knows what
        he is doing and do nothing.  If the number is greater
        than the total number of holds, we recalculate so that
        the trade can be completed.
      }
      SumHolds := 0;
      for i := 1 to 3 do
        If (Port1Buy[i] = 'S') then begin
          if (Holds[i] < 0) then
            Holds[i] := TotHolds div P1Buy;
          SumHolds := SumHolds + Holds[i];
        end;
      { split if user assigned all holds = 0 }
      If (SumHolds = 0) then
        Goto NoTrade;
      If (SumHolds > TotHolds) then
        for i := 1 to 3 do
          If (Port1Buy[i] = 'S') then
            Holds[i] := TotHolds div P1Buy;
      SumHolds := 0;
      for i := 1 to 3 do
        If (Port2Buy[i] = 'S') then begin
          if (Holds[i] < 0) then
            Holds[i] := TotHolds div P2Buy;
          SumHolds := SumHolds + Holds[i];
        end;
      If (SumHolds > TotHolds) then
        for i := 1 to 3 do
          If (Port2Buy[i] = 'S') then
            Holds[i] := TotHolds div P2Buy;
      { adjust haggle count for Y terms after S terms }
      CheckYs(Port1Buy,P1_4Sale);
      CheckYs(Port2Buy,P2_4Sale);
      NormalVideo;
      SelectWindow(2);
      RestoreScreen;
      GoToXY(X,Y);
      { notify user Trading Macro is active }
      TextColor(White);
      TextBackground(Cyan);
      SelectWindow(1);
      ClrScr;
      Write('      === ALT T- Tradewars Paired Port Trading. ALT Q Quits. ===      ');
      NormalVideo;
      SelectWindow(2);
      GoToXY(X,Y);

      { trading loop }

      REPEAT
      { Trade until a user types ALT-Q or routine hits exit condition}
      TradeAtAPort(Port1Buy,P1_4Sale,P1B,P1S,P1F,Holds,P1Haggle,Loop);
      If Loop then
        MoveToANewPort(Port2,Loop);
      If Loop then
      TradeAtAPort(Port2Buy,P2_4Sale,P2B,P2S,P2F,Holds,P2Haggle,Loop);
      If Loop then
        MoveToANewPort(Port1,Loop);
      UNTIL NOT Loop;
      SaveScreen(X,Y);
      TextColor(Yellow);
      TextBackground(Blue);
      GoToXY(10,10);WriteLn('                     ');
      GoToXY(10,11);WriteLn(' Exiting TRADE Macro ');
      GoToXY(10,12);WriteLn('                     ');
      Delay(3000);
      NormalVideo;
      RestoreScreen;
      GotoXY(X,Y);

    END { if NTraded > 0 }
  ELSE BEGIN

NoTrade:
    { no products to trade, so split }

    SelectWindow(2);
    RestoreScreen;
    GoToXY(X,Y);
    SaveScreen(X,Y);
    TextColor(White);
    TextBackground(Red);
    GoToXY(10,10);WriteLn('                                                ');
    GoToXY(10,11);WriteLn(' No products are traded between these two ports ');
    GoToXY(10,12);WriteLn('                                                ');
    Delay(3000);
    NormalVideo;
    RestoreScreen;
    GoToXY(X,Y);
  END;
END;


Procedure Steal;

Var
  Port1Buy, Port2Buy : String;
  P1b, P1s : real3;
  P1F : Real3;
  NTraded, MaxNBought : integer;
  P1_4Sale,P2_4Sale : integer;
  P1Haggle, P2Haggle : Integer;
  P1Buy, P2Buy : integer;
  TotHolds,SumHolds : integer;
  Holds : Int3;
  Loop, EarlyExit : Boolean;
  HasSold : Boolean;
  X,Y,i : integer;

BEGIN
  NoShowFudge := FALSE;
  SaveScreen(X,Y);
  Window(35,5,70,15);
  YellowVideo;
  ClrScr;
  Loop := TRUE;
  for i := 1 to 3 do begin
    P1F[i] := DefaultFactor;
    P1B[i] := DefaultBuy;
    P1S[i] := DefaultSell;
  end;
  Write('        Port Type: ');
  BuildString(Port1Buy);
  WriteLn;
  { if somebody enters a port class, convert it to the 3 char string }
  If ((length(Port1Buy) = 1) and (isdigit(Port1Buy[1]))) then
    Port1Buy := ClassStr[Ord(Port1Buy[1]) - Ord('0')];
  Port2Buy := Port1Buy;
  Port2Buy[3] := 'S';
  { Finding out how many products we can "trade" }

  Process_Port_Pair(Port1Buy,Port2Buy,NTraded,P1Buy,P2Buy,
                    P1Haggle,P2Haggle,P1_4Sale,P2_4Sale);

  { if we can sell equipment to this port, then steal }
  If (NTraded > 0) THEN
    BEGIN
      Write(' How many Holds to Trade with : ');
      ReadLn(TotHolds);
      For i := 1 to 3 do begin
        If i = 3 then
          Holds[i] := TotHolds
        else Holds[i] := 0;
      end;
      NormalVideo;
      SelectWindow(2);
      RestoreScreen;
      GoToXY(X,Y);
      { notify user Stealing Macro is active }
      TextColor(White);
      TextBackground(Cyan);
      SelectWindow(1);
      ClrScr;
      Write('      === ALT S- Tradewars Steal/Sell. ALT Q Quits. ===      ');
      NormalVideo;
      SelectWindow(2);
      GoToXY(X,Y);

      { stealing loop }
      HasSold := FALSE;
      REPEAT
      { Trade until a user types ALT-Q or routine hits exit condition}
      If Loop then begin
        TradeAtAPort(Port1Buy,P1_4Sale,P1B,P1S,P1F,Holds,P1Haggle,Loop);
        HasSold := TRUE;
      end;
      StealAtAPort(Loop,HasSold,Holds[3],STwo);
      UNTIL NOT Loop;
      SaveScreen(X,Y);
      TextColor(Yellow);
      TextBackground(Blue);
      GoToXY(10,10);WriteLn('                     ');
      GoToXY(10,11);WriteLn(' Exiting STEAL Macro ');
      GoToXY(10,12);WriteLn('                     ');
      Delay(3000);
      NormalVideo;
      RestoreScreen;
      GotoXY(X,Y);

    END { if NTraded > 0 }
  ELSE BEGIN

    { no Equipment to sell, so split }

    SelectWindow(2);
    RestoreScreen;
    GoToXY(X,Y);
    SaveScreen(X,Y);
    TextColor(White);
    TextBackground(Red);
    GoToXY(10,10);WriteLn('                                      ');
    GoToXY(10,11);WriteLn(' Equipment is not bought at this port ');
    GoToXY(10,12);WriteLn('                                      ');
    Delay(3000);
    NormalVideo;
    RestoreScreen;
    GoToXY(X,Y);
  END;
END;

Procedure FivePointSteal;

Var
  Port1Buy, Port2Buy : String;
  P1b, P1s : real3;
  P1F : Real3;
  NTraded, MaxNBought : integer;
  P1_4Sale,P2_4Sale : integer;
  P1Haggle, P2Haggle : Integer;
  P1Buy, P2Buy : integer;
  TotHolds,SumHolds : integer;
  Bp5p , Fo5p : longint;
  Holds : Int3;
  Loop : Boolean;
  HasSold : Boolean;
  X,Y,i : integer;

BEGIN
  NoShowFudge := FALSE;
  SaveScreen(X,Y);
  Window(35,5,70,15);
  YellowVideo;
  ClrScr;
  Loop := TRUE;
  for i := 1 to 3 do begin
    { none of these are used but it keeps process_port_pair happy }
    P1F[i] := DefaultFactor;
    P1B[i] := DefaultBuy;
    P1S[i] := DefaultSell;
  end;
  WriteLn('  5 Pt Steal/Sell:');
  Write('        Port Type: ');
  BuildString(Port1Buy);
  WriteLn;
  { if somebody enters a port class, convert it to the 3 char string }
  If ((length(Port1Buy) = 1) and (isdigit(Port1Buy[1]))) then
    Port1Buy := ClassStr[Ord(Port1Buy[1]) - Ord('0')];
  Port2Buy := Port1Buy;
  Port2Buy[3] := 'S';
  { Finding out how many products we can "trade" }

  Process_Port_Pair(Port1Buy,Port2Buy,NTraded,P1Buy,P2Buy,
                    P1Haggle,P2Haggle,P1_4Sale,P2_4Sale);

  { if we can sell equipment to this port, then steal }
  If (NTraded > 0) THEN
    BEGIN
      Write(' How many Holds to Trade with : ');
      ReadLn(TotHolds);
      For i := 1 to 3 do begin
        If i = 3 then
          Holds[i] := TotHolds
        else Holds[i] := 0;
      end;
      NormalVideo;
      SelectWindow(2);
      RestoreScreen;
      GoToXY(X,Y);
      { notify user Stealing Macro is active }
      TextColor(White);
      TextBackground(Cyan);
      SelectWindow(1);
      ClrScr;
      Write('      === ALT 5- 5 Point Steal/Sell. ALT Q Quits. ===      ');
      NormalVideo;
      SelectWindow(2);
      GoToXY(X,Y);

      { stealing loop }
      BP5P := 0;
      FO5P := 0;
      HasSold := FALSE;
      REPEAT
      { Trade until a user types ALT-Q or routine hits exit condition}
      If Loop then begin
        FivePointTrade(Port1Buy,P1_4Sale,BP5P,Fo5p,Holds,P1Haggle,Loop);
        HasSold := TRUE;
      end;
      StealAtAPort(Loop,HasSold,Holds[3],SFive);
      UNTIL NOT Loop;
      SaveScreen(X,Y);
      TextColor(Yellow);
      TextBackground(Blue);
      GoToXY(10,10);WriteLn('                     ');
      GoToXY(10,11);WriteLn(' Exiting STEAL Macro ');
      GoToXY(10,12);WriteLn('                     ');
      Delay(3000);
      NormalVideo;
      RestoreScreen;
      GotoXY(X,Y);

    END { if NTraded > 0 }
  ELSE BEGIN

    { no Equipment to sell, so split }

    SelectWindow(2);
    RestoreScreen;
    GoToXY(X,Y);
    SaveScreen(X,Y);
    TextColor(White);
    TextBackground(Red);
    GoToXY(10,10);WriteLn('                                      ');
    GoToXY(10,11);WriteLn(' Equipment is not bought at this port ');
    GoToXY(10,12);WriteLn('                                      ');
    Delay(3000);
    NormalVideo;
    RestoreScreen;
    GoToXY(X,Y);
  END;
END;


Procedure MultiSteal;
Const
  Risk = 0.0333333333; { assuming 1/30 chance of getting caught }

Var
  Port1Buy, Port2Buy, ExpStr : String;
  P1b, P1s : real3;
  P1F : Real3;
  NTraded, MaxNBought : integer;
  P1_4Sale,P2_4Sale : integer;
  P1Haggle, P2Haggle : Integer;
  P1Buy, P2Buy : integer;
  TotHolds,SumHolds : integer;
  Bp5p , Fo5p : longint;
  Holds : Int3;
  Loop : Boolean;
  HasSold : Boolean;
  X,Y,i : integer;
  experience, MostEff, EffHolds,ec1 : integer;
  eff,neweff,rtemp : real;
  OneMinusRisk, lnOMR, NRisk : real;
  holdspt, newholds, maxcyc, nturns, turns, xsteal : integer;
  StealHolds : integer;


BEGIN
  NoShowFudge := FALSE;
  OneMinusRisk := 1.0 - Risk;
  lnOMR := ln(OneMinusRisk);
  SaveScreen(X,Y);
  Window(35,5,70,15);
  YellowVideo;
  ClrScr;
  Loop := TRUE;
  for i := 1 to 3 do begin
    { none of these are used but it keeps process_port_pair happy }
    P1F[i] := DefaultFactor;
    P1B[i] := DefaultBuy;
    P1S[i] := DefaultSell;
  end;
  WriteLn('  Multi Steal/Sell: ');
    Write('         Port Type: ');
  BuildString(Port1Buy);
  WriteLn;
  { if somebody enters a port class, convert it to the 3 char string }
  If ((length(Port1Buy) = 1) and (isdigit(Port1Buy[1]))) then
    Port1Buy := ClassStr[Ord(Port1Buy[1]) - Ord('0')];
  Port2Buy := Port1Buy;
  Port2Buy[3] := 'S';
  { Finding out how many products we can "trade" }

  Process_Port_Pair(Port1Buy,Port2Buy,NTraded,P1Buy,P2Buy,
                    P1Haggle,P2Haggle,P1_4Sale,P2_4Sale);

  { if we can sell equipment to this port, then steal }
  If (NTraded > 0) THEN
    BEGIN
      Write('  Your Experience : ');
      BuildString(ExpStr);WriteLn;
      Write(' How many Holds to Trade with : ');
      ReadLn(TotHolds);
      experience := 0;
      If (Length(ExpStr) > 0) then begin
        Val(ExpStr,experience,ec1);
        if (ec1 <> 0) then
          experience := 0;
      end;
      if (experience > 0) then begin
        rtemp := experience / 100;
        holdspt := round(5*rtemp); { round to nearest 5 holds of exp/20 }
        if (holdspt >= totholds) then begin
          stealholds := totholds;
          mosteff := 1;
          {
            trading efficiency = (holds sold per turn - risk*#holds that can
            be lost per turn - risk*loss of holds that could be stolen with
            lost experience per turn)
          }
          eff := (stealholds - Risk*(stealholds + experience/200))
                 /(mosteff + 1.0);
        end
        else begin
          maxcyc := totholds div holdspt + 1;
          mosteff := 0;
          eff := 0.0;
          stealholds := 0;
          for turns := 1 to maxcyc do begin
            NRisk := 1.0 - exp(turns*lnOMR);
            nturns := turns + 1;
            if (turns*holdspt > TotHolds) then
              newholds := TotHolds div turns
            else newholds := holdspt;
            { ok, how efficient is this potential loop? }
            {
              efficiency = turns*holds/# turns for loop -
                           cumulative risk for loop turns * (
                           mean number of holds to be lost +
                           holds equivalent to 10% of exp)/
                           # turns for loop
            }
            neweff := (turns*newholds - NRisk*
                      (newholds*(turns+1)/2 + experience/200))/nturns;
            if (neweff > eff) then begin
              mosteff := turns;
              eff := neweff;
              stealholds := newholds;
            end;
          end; { for turns }
        end;
      end
      else begin
        StealHolds := TotHolds;
        MostEff := 1;
        eff := stealholds*(1 - Risk)/(mosteff + 1.0);
      end;
      For i := 1 to 3 do begin
        If i = 3 then
          Holds[i] := StealHolds*MostEff
        else Holds[i] := 0;
      end;
      Writeln(' Stealing ',StealHolds:3,' Holds for ');
      WriteLn(' ',MostEff:1,' Consecutive Turns.');
      WriteLn(' Eff = ',Eff:7:2,' holds/turn.');
      Delay(2500);
      NormalVideo;
      SelectWindow(2);
      RestoreScreen;
      GoToXY(X,Y);
      { notify user Stealing Macro is active }
      TextColor(White);
      TextBackground(Cyan);
      SelectWindow(1);
      ClrScr;
      Write('      === ALT 6 - MultiSteal Steal/Sell. ALT Q Quits. ===      ');
      NormalVideo;
      SelectWindow(2);
      GoToXY(X,Y);

      { stealing loop }
      BP5P := 0;
      FO5P := 0;
      HasSold := FALSE;
      REPEAT
      { Trade until a user types ALT-Q or routine hits exit condition}
      If Loop then begin
        FivePointTrade(Port1Buy,P1_4Sale,BP5P,Fo5p,Holds,P1Haggle,Loop);
        HasSold := TRUE;
      end;
      xsteal := 0;
      While ((xsteal < Mosteff) and Loop) do begin
        StealAtAPort(Loop,HasSold,StealHolds,SMulti);
        Inc(xsteal);
      end;
      UNTIL NOT Loop;
      SaveScreen(X,Y);
      TextColor(Yellow);
      TextBackground(Blue);
      GoToXY(10,10);WriteLn('                     ');
      GoToXY(10,11);WriteLn(' Exiting STEAL Macro ');
      GoToXY(10,12);WriteLn('                     ');
      Delay(3000);
      NormalVideo;
      RestoreScreen;
      GotoXY(X,Y);

    END { if NTraded > 0 }
  ELSE BEGIN

    { no Equipment to sell, so split }

    SelectWindow(2);
    RestoreScreen;
    GoToXY(X,Y);
    SaveScreen(X,Y);
    TextColor(White);
    TextBackground(Red);
    GoToXY(10,10);WriteLn('                                      ');
    GoToXY(10,11);WriteLn(' Equipment is not bought at this port ');
    GoToXY(10,12);WriteLn('                                      ');
    Delay(3000);
    NormalVideo;
    RestoreScreen;
    GoToXY(X,Y);
  END;
END;

Procedure HalfSteal;
Const
  Risk = 0.0333333333; { assuming 1/30 chance of getting caught }

Var
  Port1Buy, Port2Buy, ExpStr : String;
  P1b, P1s : real3;
  P1F : Real3;
  NTraded, MaxNBought : integer;
  P1_4Sale,P2_4Sale : integer;
  P1Haggle, P2Haggle : Integer;
  P1Buy, P2Buy : integer;
  TotHolds,SumHolds : integer;
  Bp5p , Fo5p : longint;
  Holds : Int3;
  Loop : Boolean;
  HasSold : Boolean;
  X,Y,i : integer;
  experience, MostEff, EffHolds,ec1 : integer;
  eff,neweff,rtemp : real;
  OneMinusRisk, lnOMR, NRisk : real;
  holdspt, newholds, maxcyc, nturns, turns, xsteal : integer;
  StealHolds : integer;


BEGIN
  OneMinusRisk := 1.0 - Risk;
  lnOMR := ln(OneMinusRisk);
  SaveScreen(X,Y);
  Window(35,5,70,15);
  YellowVideo;
  ClrScr;
  Loop := TRUE;
  for i := 1 to 3 do begin
    { none of these are used but it keeps process_port_pair happy }
    P1F[i] := DefaultFactor;
    P1B[i] := DefaultBuy;
    P1S[i] := DefaultSell;
  end;
  WriteLn('   Half Steal/Sell: ');
    Write('         Port Type: ');
  BuildString(Port1Buy);
  WriteLn;
  { if somebody enters a port class, convert it to the 3 char string }
  If ((length(Port1Buy) = 1) and (isdigit(Port1Buy[1]))) then
    Port1Buy := ClassStr[Ord(Port1Buy[1]) - Ord('0')];
  Port2Buy := Port1Buy;
  Port2Buy[3] := 'S';
  { Finding out how many products we can "trade" }

  Process_Port_Pair(Port1Buy,Port2Buy,NTraded,P1Buy,P2Buy,
                    P1Haggle,P2Haggle,P1_4Sale,P2_4Sale);

  { if we can sell equipment to this port, then steal }
  If (NTraded > -1) THEN
    BEGIN
      Write('  Your Experience : ');
      BuildString(ExpStr);WriteLn;
      Write(' How many Holds to Trade with : ');
      ReadLn(TotHolds);
      experience := 0;
      If (Length(ExpStr) > 0) then begin
        Val(ExpStr,experience,ec1);
        if (ec1 <> 0) then
          experience := 0;
      end;
      if (experience > 0) then begin
        rtemp := experience / 100;
        holdspt := round(5*rtemp); { round to nearest 5 holds of exp/20 }
        if (holdspt >= totholds) then begin
          stealholds := totholds;
          mosteff := 1;
          {
            trading efficiency = (holds sold per turn - risk*#holds that can
            be lost per turn - risk*loss of holds that could be stolen with
            lost experience per turn)
          }
          eff := (stealholds - Risk*(stealholds + experience/200))
                 /(mosteff + 1.0);
        end
        else begin
          maxcyc := totholds div holdspt + 1;
          mosteff := 0;
          eff := 0.0;
          stealholds := 0;
          for turns := 1 to maxcyc do begin
            NRisk := 1.0 - exp(turns*lnOMR);
            nturns := turns + 1;
            if (turns*holdspt > TotHolds) then
              newholds := TotHolds div turns
            else newholds := holdspt;
            { ok, how efficient is this potential loop? }
            {
              efficiency = turns*holds/# turns for loop -
                           cumulative risk for loop turns * (
                           mean number of holds to be lost +
                           holds equivalent to 10% of exp)/
                           # turns for loop
            }
            neweff := (turns*newholds - NRisk*
                      (newholds*(turns+1)/2 + experience/200))/nturns;
            if (neweff > eff) then begin
              mosteff := turns;
              eff := neweff;
              stealholds := newholds;
            end;
          end; { for turns }
        end;
      end
      else begin
        StealHolds := TotHolds;
        MostEff := 1;
        eff := stealholds*(1 - Risk)/(mosteff + 1.0);
      end;
      For i := 1 to 3 do begin
        If i = 3 then
          Holds[i] := StealHolds*MostEff
        else Holds[i] := 0;
      end;
      Writeln(' Stealing ',StealHolds:3,' Holds for ');
      WriteLn(' ',MostEff:1,' Consecutive Turns.');
      WriteLn(' Eff = ',Eff:7:2,' holds/turn.');
      Delay(2500);
      NormalVideo;
      SelectWindow(2);
      RestoreScreen;
      GoToXY(X,Y);
      { notify user Stealing Macro is active }
      TextColor(White);
      TextBackground(Cyan);
      SelectWindow(1);
      ClrScr;
      Write('      === ALT 7 - HalfSteal Steal/Sell. ALT Q Quits. ===      ');
      NormalVideo;
      SelectWindow(2);
      GoToXY(X,Y);

      { stealing loop }
      BP5P := 0;
      FO5P := 0;
      HasSold := FALSE;
      { Steal *Once*}
      xsteal := 0;
      While ((xsteal < Mosteff) and Loop) do begin
        StealAtAPort(Loop,HasSold,StealHolds,SHalf);
        Inc(xsteal);
      end;
      SaveScreen(X,Y);
      TextColor(Yellow);
      TextBackground(Blue);
      GoToXY(10,10);WriteLn('                          ');
      GoToXY(10,11);WriteLn(' Exiting Half-STEAL Macro ');
      GoToXY(10,12);WriteLn('                          ');
      Delay(3000);
      NormalVideo;
      RestoreScreen;
      GotoXY(X,Y);

    END { if NTraded > 0 }
  ELSE BEGIN

    { no Equipment to sell, so split }

    SelectWindow(2);
    RestoreScreen;
    GoToXY(X,Y);
    SaveScreen(X,Y);
    TextColor(White);
    TextBackground(Red);
    GoToXY(10,10);WriteLn('                                      ');
    GoToXY(10,11);WriteLn(' Equipment is not bought at this port ');
    GoToXY(10,12);WriteLn('                                      ');
    Delay(3000);
    NormalVideo;
    RestoreScreen;
    GoToXY(X,Y);
  END;
END;


Procedure OnePortTrade;

{ cribbed from the Trade macro }

Const
  ClassList:ARRAY[0 .. 9] of Integer = (0,4,5,6,1,2,3,8,7,7);
Label
  NoTrade;

Var
  Port1Buy, Port2Buy, tokstr, S : String;
  P1b, P1s, P1F : Real3;
  Buysquared, SellSquared : real;
  NTraded, MaxNBought : integer;
  P1_4Sale,P2_4Sale : integer;
  P1Haggle, P2Haggle : Integer;
  P1Buy, P2Buy : integer;
  TotHolds,SumHolds : integer;
  Holds : Int3;
  Loop : Boolean;
  X,Y,i,toks,ec1 : integer;
  P : parsetype;

BEGIN
  tokstr := ' ,:;'+#8+#9+#10+#13;
  SaveScreen(X,Y);
  Window(35,5,70,15);
  YellowVideo;
  ClrScr;
  Loop := TRUE;
  { tokenize the string and take the first token to kill any leading
    blanks or tabs }
  Write('      Port Class: ');
  BuildString(Port1Buy);
  WriteLn;
  toks := Parse_Str(tokstr,Port1Buy,P);
  If toks > 0 then
    Port1Buy := P.s[0]
  else goto NoTrade;

  { if somebody enters a port class, convert it to the 3 char string }
  If ((length(Port1Buy) = 1) and (isdigit(Port1Buy[1]))) then begin
    Port2Buy := ClassStr[ClassList[Ord(Port1Buy[1]) - Ord('0')]];
    Port1Buy := ClassStr[Ord(Port1Buy[1]) - Ord('0')];
  end
  else goto NoTrade;

  { Find out how many products we can trade and other tedious goodies }

  Process_Port_Pair(Port1Buy,Port2Buy,NTraded,P1Buy,P2Buy,
                    P1Haggle,P2Haggle,P1_4Sale,P2_4Sale);

  { if we have products to trade, then trade }
  If (NTraded > 0) THEN
    BEGIN
      WriteLn(' Num. Products Traded = ',NTraded);
      REPEAT
        Write(' How many Holds to Trade with : ');
        BuildString(S);
        WriteLn;
        toks := Parse_Str(tokstr,S,P);
        If (toks > 0) then begin
          Val(P.s[0],TotHolds,ec1);
          if ec1 <> 0 then
            TotHolds := 32000;
        end
        else TotHolds := 32000;
      UNTIL (TotHolds > 0);
      BuySquared := DefaultBuy*DefaultBuy;
      SellSquared := DefaultSell*DefaultSell;
      if (TotHolds < 200) then begin
        for i := 1 to 3 do
          P1F[i] := DefaultFactor;
        P1B[1] := Buysquared;
        P1B[2] := (DefaultBuy + Buysquared)/2;
        P1B[3] := DefaultBuy;
        P1S[1] := Sellsquared;
        P1S[2] := (DefaultSell + SellSquared)/2;
        P1S[3] := DefaultSell;
      end
      else if (TotHolds < 251) then begin
        for i := 1 to 3 do begin
          P1F[i] := 1.43*DefaultFactor;
          P1B[i] := Sqrt(DefaultBuy);
          P1S[i] := Sqrt(DefaultSell);
        end;
      end
      else begin
        for i := 1 to 3 do begin
          P1F[i] := 1.43*DefaultFactor;
          P1B[i] := Sqrt(Sqrt(DefaultBuy));
          P1S[i] := Sqrt(Sqrt(DefaultSell));
        end;
      end;
      For i := 1 to 3 do begin
        Holds[i] := TotHolds;
        If (Port1Buy[i] <> 'X') and (Port1Buy[i] <> 'Y') then begin
          Write(' How Many Holds For ',StrProd[i],': ');
          BuildString(S);
          WriteLn;
          toks := Parse_Str(tokstr,S,P);
          If (toks > 0) then begin
            Val(P.s[0],Holds[i],ec1);
            if ec1 <> 0 then
              Holds[i] := TotHolds;
          end;
          { check for zero valued holds.  If Holds = 0, then
            user must not want to trade the product }
          If (Holds[i] = 0) then begin
            If Port1Buy[i] = 'S' then begin
              Port1Buy[i] := 'Y';
              Dec(P1Buy);
              { don't give product any holds if we aren't trading it }
            end;
            If Port1Buy[i] = 'B' then begin
              Port1Buy[i] := 'X';
              Dec(P1Haggle);
              { Can't Haggle for it if it isn't onboard }
            end;
          end;
        end;
      end;


      { adjust haggle count for Y terms after S terms }
      CheckYs(Port1Buy,P1_4Sale);
      SumHolds := 0;
      NormalVideo;
      SelectWindow(2);
      RestoreScreen;
      GoToXY(X,Y);
      { notify user Trading Macro is active }
      TextColor(White);
      TextBackground(Cyan);
      SelectWindow(1);
      ClrScr;
      Write('      === Tradewars Single Port Trading. ALT Q Quits. ===      ');
      NormalVideo;
      SelectWindow(2);
      GoToXY(X,Y);

      { beginning of trade }

      TradeAtAPort(Port1Buy,P1_4Sale,P1B,P1S,P1F,Holds,P1Haggle,Loop);

      { end of trade }

      SaveScreen(X,Y);
      TextColor(Yellow);
      TextBackground(Blue);
      GoToXY(10,10);WriteLn('                            ');
      GoToXY(10,11);WriteLn(' Exiting SINGLE TRADE Macro ');
      GoToXY(10,12);WriteLn('                            ');
      Delay(3000);
      NormalVideo;
      RestoreScreen;
      GotoXY(X,Y);

    END { if NTraded > 0 }
  ELSE BEGIN

NoTrade:
    { no products to trade, so split }

  END;
END;


Procedure RobAPort; { we're working on it... }
label
  TheEnd,RobLoopEnd;
var
  Loop : boolean;
  toks,X,Y,ec1 : integer;
  tstr, istr, S, ExpStr : string;
  P : ParseType;
  temp1,temp2,temp3 : boolean;
  ToRob, Experience,Credits : longint;

BEGIN
   Loop := TRUE;
   Tstr := ' '+#8+#9+#10+#13;
   SaveScreen(X,Y);
   Window(35,5,70,15);
   YellowVideo;
   ClrScr;
   Loop := TRUE;
  { tokenize the string and take the first token to kill any leading
    blanks or tabs }
   Writeln('  Rob Macro:');
   Write(' Experience: ');
   BuildString(ExpStr);
   WriteLn;
   SelectWindow(2);
   RestoreScreen;
   GoToXY(X,Y);
   toks := Parse_Str(tstr,ExpStr,P);
   If toks > 0 then begin
     Val(P.s[0],Experience,ec1);
     if ec1 <> 0 then
       Experience := -1;
   end
   else goto TheEnd;
   If Experience < 1 then goto TheEnd;
   REPEAT
   If NOT FastXmit then Delay(1000);
   X := WhereX; Y := WhereY;
   SelectWindow(1);
   TextBackground(Cyan);
   ClrScr;
   Write(' Stealing Credits. ');
   NormalVideo;
   SelectWindow(2);
   GoToXY(X,Y);
   Async_Send('P');
   REPEAT
     GetALine(toks,tstr,istr,'?',P,Loop);
     temp1 := MatchToken(P.s[toks-1],'?');
   UNTIL ((NOT Loop) or temp1);
   If NOT Loop then goto RobLoopEnd;
   If NOT FastXmit then Delay(1000);
   Async_Send('R');
   REPEAT
     GetALine(toks,tstr,istr,']',P,Loop);
     temp1 := MatchToken(P.s[toks-1],'[Pause]');
   UNTIL ((NOT Loop) or temp1);
   If Not Loop then goto RobLoopEnd;
   If NOT FastXmit then Delay(1000);
   Async_Send(#13);
   REPEAT
     GetALine(toks,tstr,istr,')',P,Loop);
     temp1 := MatchToken(P.s[toks-1],'(?=Help)');
   UNTIL ((NOT Loop) or temp1);
   If Not Loop then goto RobLoopEnd;
   If NOT FastXmit then Delay(1000);
   Async_Send('R');
   REPEAT
     GetALine(toks,tstr,istr,')',P,Loop);
     temp1 := MatchToken(P.s[toks-1],'quit)');
     If MatchToken(P.s[1],'Trade') then begin
       Credits := Str_to_Tw_Int(P.s[10]);
       Credits := trunc(Credits/0.9);
     end;
   UNTIL ((NOT Loop) or temp1);
   If Not Loop then goto RobLoopEnd;
   If (Credits < 1) then Credits := 0;
   ToRob := round(Experience * RobFactor);
   If (Credits < ToRob) then begin
     ToRob := Credits;
     Credits := 0;
   end;
   Str(ToRob,S);
   S := S + #13;
   Async_Send_String(S);
   REPEAT
     GetALine(toks,tstr,istr,'!.',P,Loop);
     X := WhereX; Y := WhereY;
     SelectWindow(1);
     TextBackground(Cyan);
     ClrScr;
     Write(' Rob Successful? ');
     NormalVideo;
     SelectWindow(2);
     GoToXY(X,Y);
     temp1 := MatchToken(P.s[toks-1],'Busted!');
     temp2 := MatchToken(P.s[toks-1],'Success!');
     temp3 := MatchToken(P.s[toks-1],'point(s).');
   UNTIL ((NOT Loop) or temp1 or temp2 or temp3);
   If NOT Loop then goto RobLoopEnd;
   If temp1 then begin
     Loop := FALSE;
     Alarm;
   end;
   if temp2 or temp3 then begin
     REPEAT
       GetALine(toks,tstr,istr,'?',P,Loop);
       temp1 := MatchToken(P.s[toks-1],'=Help)?');
       X := WhereX; Y := WhereY;
       SelectWindow(1);
       TextBackground(Cyan);
       ClrScr;
       Write(' End of Rob? ');
       NormalVideo;
       SelectWindow(2);
       GoToXY(X,Y);
     UNTIL ((NOT Loop) or temp1);
   end;
RobLoopEnd:
   UNTIL ((NOT Loop) or (Credits < 1));
   { other stuff }
   { exit the program }
  TheEnd:
    SaveScreen(X,Y);
    TextColor(White);
    TextBackground(Red);
    GoToXY(10,10);WriteLn('                  ');
    GoToXY(10,11);WriteLn(' End of Rob Macro ');
    GoToXY(10,12);WriteLn('                  ');
    Delay(3000);
    NormalVideo;
    RestoreScreen;
    GoToXY(X,Y);
END;

BEGIN { beginning of module }
  RobFactor := 0.125;
END.