Unit TWLine;
{
Copyright (C) 1993 by David Myers.  All rights reserved.  Personal
copying and use of this code permitted.  This source cannot be
sold or distributed for more than the cost of media.
}
interface
uses Crt,FlyCom,FParser,TwBuffer,TWAnsi;
var
  FastXmit : boolean;
  UniverseSize : integer;

Procedure ShortAlarm;

Procedure Alarm;

Procedure GetaLine(Var T : integer; Var Seps, SS : string;
                   Sterm : string; Var P : parsetype; Var Loop : boolean);
implementation

FUNCTION isins(c : char;var s : string) : boolean;

{ determines if a character c is in string s}

var
  t : boolean;
  i : integer;
BEGIN
  t := FALSE;
  i := 1;
  while ((t = FALSE) and (i <= length(s))) do BEGIN
    if (c = s[i]) then
      t := TRUE;
    inc(i);
  END;
  isins := t;
END;

Procedure ShortAlarm;
BEGIN
  Sound(440); Delay(100);Nosound; Delay(200);
  Sound(660); Delay(100);Nosound; Delay(200);
  Sound(440); Delay(100);Nosound; Delay(200);
END;

Procedure Alarm;
BEGIN
  Sound(440); Delay(100);Nosound; Delay(200);
  Sound(660); Delay(100);Nosound; Delay(200);
  Sound(440); Delay(100);Nosound; Delay(200);
  Sound(440); Delay(100);Nosound; Delay(200);
  Sound(660); Delay(100);Nosound; Delay(200);
  Sound(440); Delay(100);Nosound; Delay(200);
  Sound(440); Delay(100);Nosound; Delay(200);
  Sound(660); Delay(100);Nosound; Delay(200);
  Sound(440); Delay(100);Nosound; Delay(200);
END;

Procedure GetaLine(Var T : integer; Var Seps, SS : string;
                   Sterm : string; Var P : parsetype; Var Loop : boolean);
{ this procedure gets a line of serial input from the modem and
  parses it.  If tokens are greater than zero, it returns the string
  as well as its parsed version.  Loop is used to supply a termination
  signal to the calling program.

  VARIABLES:

  INPUT:

  Sterm - a list of characters used to terminate strings (other than
          a newline (CHR(10)) character
  Seps  - a list of characters that separate a string into tokens.
          Typically, this is a string consisting of a space, a tab,
          a newline and a return.
  Loop  - a boolean variable equal to TRUE.

  OUTPUT

  T - the number of tokens in the parsed string

  SS - the whole input string

  P - ParseType, a record as follows:

  P.count : an integer equal to the # of tokens in the record
  P.s[20] : 20 strings, which contain the tokens of SS in the
             order P.s[0] to P.s[count-1]

  Loop - If ALT-Q is typed while GetALine is running, string
  processing is terminated and Loop is returned with the value
  FALSE.

  }
Var
  count : integer;
  charin : char;

BEGIN
  T := 0;
  count := 0;
  SS[0] := chr(count);
  WHILE (Loop and (T < 1)) DO
    BEGIN
      If Async_Receive(CharIn) then
        BEGIN
          If BufferisOpen then
            AddToBuffer(CharIn);
          If (CharIn = #27) and AnsiOn then
            Async_Ansi
          Else begin
          { using 2nd buffer for CIM captures now. This buffer doesn't
           see Ansi, we trap it in the above sequence. }
          If Buffer2isOpen then
            Addto2Buffer(Charin);
          Write(CharIn);
          end;
          If CharIn = #12 then
            ClrScr;
          If Ord(CharIn) > 31 THEN
            BEGIN
              Inc(count);
              SS[count] := CharIn;
              SS[0] := chr(count);
            END;
          If (CharIn = #10) or (isins(Charin,Sterm)) or (SS[0] > chr(79)) then
            BEGIN
              T := Parse_Str(Seps,SS,P);
            END;
          CharIn := #0;
        END
      ELSE BEGIN
        If KeyPressed then
          BEGIN
            CharIn := ReadKey;
            IF (CharIn = #0) THEN
              BEGIN
               Charin := ReadKey;
               If (Charin = #16) THEN { ALT-Q exits }
                 Loop := FALSE;
              END
            ELSE Async_Send(CharIn); {keep this a free-flowing terminal}
          END;
      END;
    END;
END;

Procedure IsFast;
var
  i : integer;

BEGIN
  If ParamCount > 0 then begin
    for i := 1 to ParamCount do
      if MatchToken(ParamStr(i),'fast') then
        FastXmit := TRUE;
  end;
END;

Procedure ReadCL_USize(var Usize : Integer);
var
  j, temp, ec1 : integer;
BEGIN
  If ParamCount > 1 then begin
    for j := 1 to ParamCount-1 do
      if MatchToken(ParamStr(j),'usize') then begin
        Val(ParamStr(j+1),temp,ec1);
        if (ec1 = 0) then
          if ((temp > 999) and (temp < 5001)) then
            Usize := temp;
      end;
  end;
END;


BEGIN
  FastXmit := FALSE;
  IsFast;
  UniverseSize := 1000;
  ReadCL_USize(UniverseSize);
END.
