;
; Glass TTY via FOSSIL
;

COM equ 1

; Allows TASM to assemble this file

ifdef ??version
	masm51
	quirks
endif

include keyasm.h

_code segment byte
  if COM
	org	0100H
  endif
	assume cs:_code
_start:
  if COM
	assume ds:_code, es:_code
  else
	mov ax,cs
	mov ds,ax
	assume ds:_code
  endif
	jmp _begin

port	dw 0
isansi	dw 0

copr	db 'Glass-TTY Terminal Program via FOSSIL driver V 1.00',13,10
	db 'Copyright (C) 1992  David Nugent & Unique Computing Pty Ltd',13,10
	db 'Press Alt-F10 for assistance',13,10
_copr	equ $
abrt	db 'Abort - no FOSSIL driver loaded!',13,10,'$'
help	db 27,'[2J',27,'[0;0H',27,'[47;30m'
shelp	db 13
	db ' - Keys Help --------------------- ',13,10
	db '|                                 |',13,10
	db '|  Alt-X     Exit Terminal        |',13,10
	db '|  Alt-C     Clear screen         |',13,10
	db '|  Alt-F10   Display Help Screen  |',13,10
	db '|                                 |',13,10
	db ' --------------------------------- ',13,10
_shelp	equ $
	db 27,'[0m'
_help	equ $
a_cls	db 27,'[2J',0
a_ncol	db 27,'[0m',0
a_test	db 27,'[1;80H',0
__test	db 8,8,8,8,8,8,8,0
a_warn	db 7, 'WARNING: No ANSI driver present!',13,10, 0
_begin:
	mov ah,04H			; Init FOSSIL
	mov dx,port
	int 014H
	cmp AX,01954H
	je @F
	mov dx,offset abrt
	mov ah,9
	int 021H
	mov al,1
	jmp _quit

@@:
	mov DX,offset a_test
	call ansi
	mov AH,12H
	int 014H
	cmp DX,0079
	je @F
	mov DX,offset __test
	call ansi
	jmp SHORT @C
@@:
	mov isansi,1
	mov DX,offset a_cls
	call ansi
	mov DX,offset a_ncol
	call ansi
@C:
	mov DX,offset copr
	mov CX,_copr - copr
	call strdisp
	cmp isansi,1
	je _main
	mov DX,offset a_warn
	call ansi
_main:
	mov ah,0cH			; Peek character from modem
	mov dx,port
	int 014H
	cmp ax,-1
	je @F
	mov ah,02H
	mov dx,port
	int 014H
	mov ah,13H
	int 014H
@@:
	mov ah,0DH			; Test keyboard for character
	int 014H
	cmp ax,-1
	je _main
	mov ah,0eH
	int 014H
	or al,al
	jne _ontty
	cmp ax,altx
	je _exit
	cmp ax,altf10
	je _dhelp
	cmp ax,altc
	je _cls
	jmp _main
_cls:
	cmp isansi,0
	jne @R
	mov CX,25
	mov AX,130AH
@@:
	push AX
	int 014H
	pop AX
	loop @B
	mov AX,130DH
	int 014H
	jmp _main
@R:
	mov dx,offset a_cls
	call ansi
	jmp _main
_dhelp:
	cmp isansi,0
	jne @F
	mov dx,offset shelp
	mov cx,_shelp - shelp
	jmp SHORT @I
@@:
	mov dx,offset help
	mov cx,_help - help
@I:
	call strdisp
	jmp _main

_ontty:
	mov ah,01H
	mov dx,port
	int 014H
	jmp _main

_exit:
	mov ah,05H
	mov dx,port
	int 014H
	xor al,al
_quit:
	mov AH,04cH
	int 021H

;
; Display an ansi sequence
;

ansi:
	push si
	push ax
	push cx
	mov si,dx
	xor cx,cx
@@:
	lodsb
	or al,al
	je @F
	inc cx
	jmp @B
@@:
	call strdisp
	pop cx
	pop ax
	pop cx
	ret

;
; Display a string to screen via FOSSIL
;
strdisp:
	push si
	push dx
	push ax
	push cx
	mov si,dx
@@:
	lodsb
	mov ah,13H
	int 014H
	loop @B
	pop cx
	pop ax
	pop dx
	pop si
	retn

_code ends

end _start
