/* misc.h - miscellaneous structures that are needed in more than one file */
#include "copyright.h"

#ifndef _MISC_H
#define _MISC_H

#ifndef	lint
static char *misc_RCSid = "$Id: misc.h,v 1.7 1995/03/21 00:00:42 ambar Exp $";
USE(misc_RCSid);
#endif

#include "mushdb.h"
#include "flags.h"

/* Search structure, used by @search and search(). */

typedef struct search_type SEARCH;
  struct search_type {
      int s_wizard;
      dbref s_owner;
      dbref s_rst_owner;
      int s_rst_type;
      FLAGSET s_fset;
      dbref s_parent;
      char *s_rst_name;
      char *s_rst_eval;
      int low_bound;
      int high_bound;
  };

/* Stats structure, used by @stats and stats(). */

typedef struct stats_type STATS;
  struct stats_type {
      int s_total;
      int s_rooms;
      int s_exits;
      int s_things;
      int s_players;
      int s_garbage;
  };

extern int FDECL(search_setup, (dbref, char *, SEARCH *));
extern void FDECL(search_perform, (dbref, dbref, SEARCH *));
extern int FDECL(get_stats, (dbref, dbref, STATS *));

#endif
