/* functions.h - declarations for functions & function processing */
#include "copyright.h"

#ifndef __FUNCTIONS_H
#define __FUNCTIONS_H

#ifndef	lint
static char functions_RCSid[] = "$Id: functions.h,v 1.4 1995/01/19 03:07:01 ambar Exp $";
USE(functions_RCSid);
#endif

  typedef struct fun {
      const char *name;		/* function name */
      void (*fun) ();		/* handler */
      int nargs;		/* Number of args needed or expected */
      int flags;		/* Function flags */
      int perms;		/* Access to function */
  }
FUN;

  typedef struct ufun {
      const char *name;		/* function name */
      dbref obj;		/* Object ID */
      int atr;			/* Attribute ID */
      int flags;		/* Function flags */
      int perms;		/* Access to function */
      struct ufun *next;	/* Next ufun in chain */
  } UFUN;

#define	FN_VARARGS	1	/* Function allows a variable # of args */
#define	FN_NO_EVAL	2	/* Don't evaluate args to function */
#define	FN_PRIV		4	/* Perform user-def function as holding obj */

extern void NDECL(init_functab);
extern void FDECL(list_functable, (dbref));

#endif
