/* flags.h - object flags */
#include "copyright.h"

#ifndef __FLAGS_H
#define __FLAGS_H

#ifndef	lint
static char flags_RCSid[] = "$Id: flags.h,v 1.6 1995/03/21 00:00:21 ambar Exp $";
USE(flags_RCSid);
#endif

#include "htab.h"

#define	FLAG_EXT	0x1	/* Lives in extended flag word */

/* Object types */
#define	TYPE_ROOM 	0x0
#define	TYPE_THING 	0x1
#define	TYPE_EXIT 	0x2
#define	TYPE_PLAYER 	0x3
#define	TYPE_ZONE	0x4
#define	TYPE_GARBAGE	0x5
#define	NOTYPE		0x7
#define	TYPE_MASK 	0x7

/* First word of flags */
#define	SEETHRU		0x00000008	/* Can see through to the other side */
#define	WIZARD		0x00000010	/* gets automatic control */
#define	LINK_OK		0x00000020	/* anybody can link to this room */
#define	DARK		0x00000040	/* Don't show contents or presence */
#define	JUMP_OK		0x00000080	/* Others may @tel here */
#define	STICKY		0x00000100	/* Object goes home when dropped */
#define	DESTROY_OK	0x00000200	/* Others may @destroy */
#define	HAVEN		0x00000400	/* No killing here, or no pages */
#define	QUIET		0x00000800	/* Prevent 'feelgood' messages */
#define	HALT		0x00001000	/* object cannot perform actions */
#define	TRACE		0x00002000	/* Generate evaluation trace output */
#define	GOING		0x00004000	/* object is available for recycling */
#define	MONITOR		0x00008000	/* Process ^x:action listens on obj? */
#define	MYOPIC		0x00010000	/* See things as nonowner/nonwizard */
#define	PUPPET		0x00020000	/* Relays ALL messages to owner */
#define	CHOWN_OK	0x00040000	/* Object may be @chowned freely */
#define	ENTER_OK	0x00080000	/* Object may be ENTERed */
#define	VISUAL		0x00100000	/* Everyone can see properties */
#define	IMMORTAL	0x00200000	/* Object can't be killed */
#define	HAS_STARTUP	0x00400000	/* Load some attrs at startup */
#define	OPAQUE		0x00800000	/* Can't see inside */
#define	VERBOSE		0x01000000	/* Tells owner everything it does. */
#define	INHERIT		0x02000000	/* Gets owner's privs. (i.e. Wiz) */
#define	NOSPOOF		0x04000000	/* Report originator of all actions. */
#define	ROBOT		0x08000000	/* Player is a ROBOT */
#define	SAFE		0x10000000	/* Need /override to @destroy */
#define	CONTROL_OK	0x20000000	/* ControlLk specifies who ctrls me */
#define	HEARTHRU	0x40000000	/* Can hear out of this obj or exit */
#define	TERSE		0x80000000	/* Only show room name on look */

/* Second word of flags */
#define	KEY		0x00000001	/* No puppets */
#define	ABODE		0x00000002	/* May @set home here */
#define	FLOATING	0x00000004	/* Inhibit Floating room.. msgs */
#define	UNFINDABLE	0x00000008	/* Cant loc() from afar */
#define	PARENT_OK	0x00000010	/* Others may @parent to me */
#define	LIGHT		0x00000020	/* Visible in dark places */
#define	HAS_LISTEN	0x00000040	/* Internal: LISTEN attr set */
#define	HAS_FWDLIST	0x00000080	/* Internal: FORWARDLIST attr set */
#define ZONE_PARENT	0x00000100	/* Check as local master room */
#define STOP_MATCH	0x00000200	/* Stop matching commands if found */
#define HAS_COMMANDS	0x00000400	/* Check it for $commands */
#define BOUNCE		0x00000800	/* Forward messages to contents */
#define HTML		0x00010000	/* Player supports HTML */
#define	SUSPECT		0x10000000	/* Report some activities to wizards */
#define	BUILDER		0x20000000	/* Player may build */
#define	CONNECTED	0x40000000	/* Player is connected */
#define	SLAVE		0x80000000	/* Disallow most commands */

/* Flags from prior versions of MUSH */
#define	PERN_SLAVE	0x00000080
#define	PERN_KEY	0x00000008
#define	PERN_NOSPOOF	0x00200000
#define	PERN_SUSPECT	0x04000000
#define	PERN_VERBOSE	0x00000080
#define	PERN_IMMORTAL	0x00002000
#define	PERN_MONITOR	0x00200000
#define	PERN_SAFE	0x04000000
#define	PERN_UNFIND	0x02000000
#define	V2_ACCESSED	0x00008000
#define	V3_MARKED	0x00010000
#define	V4_GAGGED	0x00000080
#define	V4_SUSPECT	0x20000000
#define	V6OBJ_KEY	0x00000008
#define	V6_BUILDER	0x00000008
#define	V6_FLOATING	0x00000008
#define	V6EXIT_KEY	0x00000080
#define	V6_SUSPECT	0x00000080
#define	V6_CONNECT	0x00000200
#define	V6_ABODE	0x00000200
#define	V6ROOM_JUMPOK	0x00002000
#define	V6PLYR_UNFIND	0x00002000
#define	V6ROOM_UNFIND	0x08000000
#define V6_SLAVE	0x10000000

/* Flags from MUSE */
#define	MUSE_BUILD	0x00000010
#define	MUSE_SLAVE	0x00000080
#define	MUSE_KEY	0x00000010
#define	MUSE_DEST_OK	0x00000200
#define	MUSE_ABODE	0x00000200
#define	MUSE_SEETHRU	0x00000200
#define	MUSE_UNFIND	0x00001000

#define	MUSE_CHOWN_OK	0x00000020
#define	MUSE_DARK	0x00000040
#define	MUSE_STICKY	0x00000100
#define	MUSE_HAVEN	0x00000400
#define	MUSE_INHERIT	0x00002000
#define	MUSE_GOING	0x00004000
#define	MUSE_PUPPET	0x00020000
#define	MUSE_LINK_OK	0x00040000
#define	MUSE_ENTER_OK	0x00080000
#define	MUSE_VISUAL	0x00100000
#define	MUSE_OPAQUE	0x00800000
#define	MUSE_QUIET	0x01000000

/* Flags from TinyMUD */
#define	MUD_ABODE	0x00000800
#define	MUD_ROBOT	0x00004000
#define	MUD_CHOWN_OK	0x00008000

/* ---------------------------------------------------------------------------
 * FLAGENT: Information about object flags.
 */

  typedef struct flag_entry {
      const char *flagname;	/* Name of the flag */
      int flagvalue;		/* Which bit in the object is the flag */
      char flaglett;		/* Flag letter for listing */
      int flagflag;		/* Ctrl flags for this flag (recursive? :-) */
      int listperm;		/* Who sees this flag when set */
      int (*handler) ();	/* Handler for setting/clearing this flag */
  }
FLAGENT;

/* ---------------------------------------------------------------------------
 * OBJENT: Fundamental object types
 */

  typedef struct object_entry {
      const char *name;
      char lett;
      int perm;
      int flags;
  }
OBJENT;
extern OBJENT object_types[8];

#define	OF_CONTENTS	0x0001
#define OF_LOCATION	0x0002
#define	OF_EXITS	0x0004
#define	OF_HOME		0x0008
#define	OF_DROPTO	0x0010
#define	OF_OWNER	0x0020

  typedef struct flagset {
      FLAG word1;
      FLAG word2;
  } FLAGSET;

extern void NDECL(init_flagtab);
extern void FDECL(display_flagtab, (dbref));
extern void FDECL(flag_set, (dbref, dbref, char *, int));
extern char *FDECL(flag_description, (dbref, dbref));
extern FLAGENT *FDECL(find_flag, (dbref, char *));
extern char *FDECL(decode_flags, (dbref, FLAG, int));
extern int FDECL(has_flag, (dbref, dbref, char *));
extern char *FDECL(unparse_object, (dbref, dbref, int));
extern char *FDECL(unparse_object_numonly, (dbref));
extern int FDECL(convert_flags, (dbref, char *, FLAGSET *, FLAG *));
extern void FDECL(decompile_flags, (dbref, dbref, char *));
extern int FDECL(Guest, (dbref));

#define unparse_flags(p,t) decode_flags(p,Flags(t),Flags2(t))

#define	GOD ((dbref) 1)

/* ---------------------- Object Permission/Attribute Macros */
/* IS(X,T,F)		- Is X of type T and have flag F set? */
/* Typeof(X)		- What object type is X */
/* God(X)		- Is X player #1 */
/* Guest(X)		- Is X the GUEST player (now a function) */
/* Robot(X)		- Is X a robot player */
/* Wizard(X)		- Does X have wizard privs */
/* Immortal(X)		- Is X unkillable */
/* Alive(X)		- Is X a player or a puppet */
/* Dark(X)		- Is X dark */
/* WHODark(X)		- Should X be hidden from the WHO report */
/* Builder(X)		- Is X allowed to add on to the db */
/* Floating(X)		- Prevent 'disconnected room' msgs for room X */
/* Quiet(X)		- Should 'Set.' messages et al from X be disabled */
/* Verbose(X)		- Should owner receive all commands executed? */
/* Trace(X)		- Should owner receive eval trace output? */
/* Player_haven(X)	- Is the owner of X no-page */
/* Haven(X)		- Is X no-kill(rooms) or no-page(players) */
/* Halted(X)		- Is X halted (not allowed to run commands)? */
/* Suspect(X)		- Is X someone the wizzes should keep an eye on */
/* Slave(X)		- Should X be prevented from db-changing commands */
/* Zone(X)		- Should we treat this room like a local master? */
/* Safe(X,P)		- Does P need the /OVERRIDE switch to @destroy X? */
/* Monitor(X)		- Should we check for ^xxx:xxx listens on player? */
/* Terse(X)		- Should we only show the room name on a look? */
/* Myopic(X)		- Should things as if we were nonowner/nonwiz */
/* Audible(X)		- Should X forward messages? */
/* Bouncer(X)		- Should X pass all messages to its contents? */
/* Findroom(X)		- Can players in room X be found via @whereis? */
/* Unfindroom(X)	- Is @whereis blocked for players in room X? */
/* Findable(X)		- Can @whereis find X */
/* Unfindable(X)	- Is @whereis blocked for X */
/* No_robots(X)		- Does X disallow robot players from using */
/* Has_location(X)	- Is X something with a location (ie plyr or obj) */
/* Has_home(X)		- Is X something with a home (ie plyr or obj) */
/* Has_contents(X)	- Is X something with contents (ie plyr/obj/room) */
/* Good_obj(X)		- Is X inside the DB and have a valid type? */
/* Good_owner(X)	- Is X a good owner value? */
/* Going(X)		- Is X marked GOING? */
/* Inherits(X)		- Does X inherit the privs of its owner */
/* Examinable(P,X)	- Can P look at attribs of X */
/* MyopicExam(P,X)	- Can P look at attribs of X (obeys MYOPIC) */
/* Controls(P,X)	- Can P force X to do something */
/* Affects(P,X)		- (Controls in MUSH V1) Is P wiz or same owner as X */
/* Abode(X)		- Is X an ABODE room */
/* Link_exit(P,X)	- Can P link from exit X */
/* Linkable(P,X)	- Can P link to X */
/* Mark(x)		- Set marked flag on X */
/* Unmark(x)		- Clear marked flag on X */
/* Marked(x)		- Check marked flag on X */
/* See_attr(P,X,A,O,F)	- Can P see text attr A on X if attr has owner O */
/* Set_attr(P,X,A,F)	- Can P set/change text attr A (with flags F) on X */
/* Read_attr(P,X,A,O,F)	- Can P see attr A on X if attr has owner O */
/* Write_attr(P,X,A,F)	- Can P set/change attr A (with flags F) on X */

#define	IS(thing,type,flag) ((Typeof(thing)==(type)) && (Flags(thing) & (flag)))
#define	Typeof(x)	(Flags(x) & TYPE_MASK)
#define	God(x)		((x) == GOD)
#define	Robot(x)	(isPlayer(x) && ((Flags(x) & ROBOT) != 0))
#define	Alive(x)	(isPlayer(x) || (Puppet(x) && Has_contents(x)))
#define OwnsOthers(x)	((object_types[Typeof(x)].flags & OF_OWNER) != 0)
#define	Has_location(x)	((object_types[Typeof(x)].flags & OF_LOCATION) != 0)
#define	Has_contents(x)	((object_types[Typeof(x)].flags & OF_CONTENTS) != 0)
#define	Has_exits(x)	((object_types[Typeof(x)].flags & OF_EXITS) != 0)
#define	Has_home(x)	((object_types[Typeof(x)].flags & OF_HOME) != 0)
#define	Has_dropto(x)	((object_types[Typeof(x)].flags & OF_DROPTO) != 0)
#define Home_ok(x)	((object_types[Typeof(x)].flags & OF_HOME) != 0)
#define isPlayer(x)	(Typeof(x) == TYPE_PLAYER)
#define	isRoom(x)	(Typeof(x) == TYPE_ROOM)
#define isExit(x)	(Typeof(x) == TYPE_EXIT)
#define isThing(x)	(Typeof(x) == TYPE_THING)
#define isZone(x)	(Typeof(x) == TYPE_ZONE)

#define	Good_obj(x)	(((x) >= 0) && ((x) < mudstate.db_top) && \
			 (Typeof(x) <= TYPE_ZONE))
#define	Good_owner(x)	(Good_obj(x) && OwnsOthers(x))

#define Transparent(x)	((Flags(x) & SEETHRU) != 0)
#define Link_ok(x)	(((Flags(x) & LINK_OK) != 0) && Has_contents(x))
#define	Wizard(x)	((Flags(x) & WIZARD) || \
			 ((Flags(Owner(x)) & WIZARD) && Inherits(x)))
#define	Dark(x)		(((Flags(x) & DARK) != 0) && (Wizard(x) || !Alive(x)))
#define Jump_ok(x)	(((Flags(x) & JUMP_OK) != 0) && Has_contents(x))
#define Sticky(x)	((Flags(x) & STICKY) != 0)
#define Destroy_ok(x)	((Flags(x) & DESTROY_OK) != 0)
#define	Haven(x)	((Flags(x) & HAVEN) != 0)
#define	Player_haven(x)	((Flags(Owner(x)) & HAVEN) != 0)
#define	Quiet(x)	((Flags(x) & QUIET) != 0)
#define	Halted(x)	((Flags(x) & HALT) != 0)
#define	Trace(x)	((Flags(x) & TRACE) != 0)
#define	Going(x)	((Flags(x) & GOING) != 0)
#define	Monitor(x)	((Flags(x) & MONITOR) != 0)
#define	Myopic(x)	((Flags(x) & MYOPIC) != 0)
#define	Puppet(x)	((Flags(x) & PUPPET) != 0)
#define Chown_ok(x)	((Flags(x) & CHOWN_OK) != 0)
#define Enter_ok(x)	(((Flags(x) & ENTER_OK) != 0) && \
			 Has_location(x) && Has_contents(x))
#define Visual(x)	((Flags(x) & VISUAL) != 0)
#define	Immortal(x)	((Flags(x) & IMMORTAL) || \
			 ((Flags(Owner(x)) & IMMORTAL) && Inherits(x)))
#define	Opaque(x)	((Flags(x) & OPAQUE) != 0)
#define	Verbose(x)	((Flags(x) & VERBOSE) != 0)
#define	Inherits(x)	(((Flags(x) & INHERIT) != 0) || \
			 ((Flags(Owner(x)) & INHERIT) != 0) || \
			 ((x) == Owner(x)))
#define	Nospoof(x)	((Flags(x) & NOSPOOF) != 0)
#define	Safe(x,p)	(OwnsOthers(x) || \
			 (Flags(x) & SAFE) || \
			 (mudconf.safe_unowned && (Owner(x) != Owner(p))))
#define Control_ok(x)	((Flags(x) & CONTROL_OK) != 0)
#define	Audible(x)	((Flags(x) & HEARTHRU) != 0)
#define	Terse(x)	((Flags(x) & TERSE) != 0)
#define Key(x)		((Flags2(x) & KEY) != 0)
#define	Abode(x)	(((Flags2(x) & ABODE) != 0) && Home_ok(x))
#define	Floating(x)	((Flags2(x) & FLOATING) != 0)
#define	Findable(x)	((Flags2(x) & UNFINDABLE) == 0)
#define	Hideout(x)	((Flags2(x) & UNFINDABLE) != 0)
#define	Parent_ok(x)	((Flags2(x) & PARENT_OK) != 0)
#define	Light(x)	((Flags2(x) & LIGHT) != 0)
#define	Suspect(x)	((Flags2(Owner(x)) & SUSPECT) != 0)
#define	Builder(x)	((Flags2(Owner(x)) & BUILDER) || Wizard(x))
#define	Connected(x)	(((Flags2(x) & CONNECTED) != 0) && \
			 (Typeof(x) == TYPE_PLAYER))
#define	Slave(x)	((Flags2(Owner(x)) & SLAVE) != 0)
#define Zone(x)		((Flags2(x) & ZONE_PARENT) != 0)
#define Stop_Match(x)	((Flags2(x) & STOP_MATCH) != 0)
#define Has_Commands(x)	((Flags2(x) & HAS_COMMANDS) != 0)
#define Bouncer(x)	((Flags2(x) & BOUNCE) != 0)
#define Hidden(x)	((Flags(x) & DARK) != 0)

#define H_Startup(x)	((Flags(x) & HAS_STARTUP) != 0)
#define H_Fwdlist(x)	((Flags2(x) & HAS_FWDLIST) != 0)
#define H_Listen(x)	((Flags2(x) & HAS_LISTEN) != 0)

#define	s_Halted(x)	s_Flags((x), Flags(x) | HALT)
#define	s_Going(x)	s_Flags((x), Flags(x) | GOING)
#define	s_Connected(x)	s_Flags2((x), Flags2(x) | CONNECTED)
#define c_Connected(x)	s_Flags2((x), Flags2(x) & ~CONNECTED)

#define Parentable(p,x)	(Controls(p,x) || \
			 (Parent_ok(x) && could_doit(p,x,A_LPARENT)))
#define	Examinable(p,x)	(((Flags(x) & VISUAL) != 0) || \
			 (Wizard(p)) || \
			 (Owner(p) == Owner(x)))
#define	MyopicExam(p,x)	(((Flags(x) & VISUAL) != 0) || \
			 (!Myopic(p) && (Wizard(p) || (Owner(p) == Owner(x)))))
#define	Controls(p,x)	(Good_obj(x) && \
			 (!(God(x) && !God(p))) && \
			 (Wizard(p) || \
			  ((Owner(p) == Owner(x)) && \
			   (Inherits(p) || !Inherits(x)))))
#define	Affects(p,x)	(Good_obj(x) && \
			 (!(God(x) && !God(p))) && \
			 (Wizard(p) || \
			  (Owner(p) == Owner(x))))
#define	Mark(x)		(mudstate.markbits->chunk[(x)>>3] |= \
			 mudconf.markdata[(x)&7])
#define	Unmark(x)	(mudstate.markbits->chunk[(x)>>3] &= \
			 ~mudconf.markdata[(x)&7])
#define	Marked(x)	(mudstate.markbits->chunk[(x)>>3] & \
			 mudconf.markdata[(x)&7])
#define	Mark_all(i)	for ((i)=0; (i)<((mudstate.db_top+7)>>3); (i)++) \
mudstate.markbits->chunk[i]=0xff
#define	Unmark_all(i)	for ((i)=0; (i)<((mudstate.db_top+7)>>3); (i)++) \
mudstate.markbits->chunk[i]=0x0
#define	Link_exit(p,x)	((Typeof(x) == TYPE_EXIT) && \
			 ((Location(x) == NOTHING) || Controls(p,x)))
#define	Linkable(p,x)	(Good_obj(x) && \
			 (Has_contents(x)) && \
			 (((Flags(x) & LINK_OK) != 0) || \
			  Controls(p,x)))
#define	See_attr(p,x,a,o,f) \
(!((a)->flags & (AF_INTERNAL|AF_IS_LOCK)) && \
 (God(p) || \
  ((f) & AF_VISUAL) || \
  ((Examinable(p,x) || (Owner(p) == (o))) && \
   !(((a)->flags | f) & (AF_DARK|AF_MDARK))) || \
  (Wizard(p) && !((a)->flags & AF_DARK)) || \
  !((a)->flags & (AF_DARK|AF_MDARK|AF_ODARK))))
#define See_attr_explicit(p,x,a,o,f) \
(!((a)->flags & (AF_INTERNAL|AF_IS_LOCK)) && \
 (((f) & AF_VISUAL) || \
  ((Owner(p) == (o)) && \
   !(((a)->flags | f) & (AF_DARK|AF_MDARK)))))
#define	Set_attr(p,x,a,f) \
(!((a)->flags & (AF_INTERNAL|AF_IS_LOCK)) && \
 (God(p) || \
  (!God(x) && !(f & AF_LOCK) && \
   ((Controls(p,x) && \
     !(((a)->flags | f) & (AF_WIZARD|AF_GOD))) || \
    (Wizard(p) && \
     !((a)->flags & AF_GOD))))))
#define	Read_attr(p,x,a,o,f) \
(!((a)->flags & AF_INTERNAL) && \
 (God(p) || \
  ((f) & AF_VISUAL) || \
  ((Examinable(p,x) || (Owner(p) == o)) && \
   !(((a)->flags | f) & (AF_DARK|AF_MDARK))) || \
  (Wizard(p) && !((a)->flags & AF_DARK)) || \
  !((a)->flags & (AF_DARK|AF_MDARK|AF_ODARK))))
#define	Write_attr(p,x,a,f) \
(!((a)->flags & AF_INTERNAL) && \
 (God(p) || \
  (!God(x) && !(f & AF_LOCK) && \
   ((Controls(p,x) && \
     !(((a)->flags | f) & (AF_WIZARD|AF_GOD))) || \
    (Wizard(p) && \
     !((a)->flags & AF_GOD))))))
#define	Has_power(p,x)	(check_access((p),powers_nametab[x].flag))
#define	Html(x)	((Flags2(x) & HTML) != 0)
#define	s_Html(x) s_Flags2((x), Flags2(x) | HTML)
#define c_Html(x) s_Flags2((x), Flags2(x) & ~HTML)

#endif
