/* config.h */
#ifndef CONFIG_H
#define CONFIG_H

#ifndef	lint
static char config_RCSid[] = "$Id: config.h,v 1.9 1995/03/29 23:42:49 ambar Exp $";
USE(config_RCSid);
#endif

#include "copyright.h"

/* Compile time options */

/* FLOATING_POINTS: 
 * Select whether or not you want normal MUSH-functions to be conducted with
 * floating-point numbers: add(), mul(), gt(), lt(), and so forth. Note
 * that floating-point-specific functions like cos() are nearly useless
 * without this defined. However, many MUSHes have no need of this sort of
 * function, and since floating-point operations are significantly slower
 * than integer operations on most processors, those who care about CPU
 * usage may want to undefine this.
 */
#define FLOATING_POINTS

/* PUEBLO_SUPPORT:
 * Select whether or not to support the HTML extensions of the
 * Pueblo client. (See http://www.chaco.com/pueblo/ for details.)
 */
/* #define PUEBLO_SUPPORT */

/* NO_LAG_CHECK:
 * Select whether or not you want to be warned of commands which exceed
 * a certain amount of real time to execute.
 */
/* #define NO_LAG_CHECK */

/* PARANOID_EMIT:
 * Select whether or not you want to insist that @emit, @pemit and friends
 * require the player Affecting the target object. (Right now it is always
 * possible if the target is nearby.)
 */
/* #define PARANOID_EMIT */

/* COMMA_IN_SAY:
 * Select whether or not you want a comma in "says". The default is the
 * traditional but grammatically incorrect no-comma.
 */
/* #define COMMA_IN_SAY */

/* TEST_MALLOC:	Defining this makes a malloc that keeps track of the number
 *		of blocks allocated.  Good for testing for Memory leaks.
 */
/* #define TEST_MALLOC */

/* MSTATS:	Defining the following allows you to get stats and usage info
 *		if you use the gnu-malloc package.  It can be used in
 *		conjuction with the above, but why?
 */
/* #define MSTATS */

/* ATR_NAME:	Define if you want name to be stored as an attribute on the
 *		object rather than in the object structure.
 */
/* #define ATR_NAME */

#define CONF_FILE "netmush.conf"        /* Default config file */

#define PUEBLO_SUPPORT_MSG "This world is Pueblo 1.0 enhanced\r\n\r\n"

/* length of the DOING field */
#define DOING_LEN 41

 /* #define TEST_MALLOC *//* Keep track of block allocs */
 /* #define MSTATS *//* Gnu-malloc stats */

#define PLAYER_NAME_LIMIT	16	/* Max length for player names */
#define NUM_ENV_VARS		10	/* Number of env vars (%0 et al) */
#define MAX_ARG			100	/* max # args from command processor */
#define MAX_GLOBAL_REGS		10	/* r() registers */
#define MAX_GUESTS		32	/* Max # of guests at one time */

/* ---------------------------------------------------------------------------
 * Database R/W flags.
 */

#define MANDFLAGS	(V_LINK|V_PARENT|V_XFLAGS|V_TQUOTAS|V_CMDSFLAG|V_ALPHA_ATTR)	/* Everyone has these */
#define OFLAGS1		(V_GDBM|V_ATRKEY)	/* GDBM has these */

#define OFLAGS2		(V_ATRNAME|V_ATRMONEY)

#define OUTPUT_VERSION	10	/* Version 10 */
#define OUTPUT_FLAGS	(MANDFLAGS|OFLAGS1|OFLAGS2)
 /* format for dumps */
#define UNLOAD_VERSION	10	/* version for export */
#define UNLOAD_OUTFLAGS	(MANDFLAGS)	/* format for export */

/* magic lock cookies */
#define NOT_TOKEN	'!'
#define AND_TOKEN	'&'
#define OR_TOKEN	'|'
#define LOOKUP_TOKEN	'*'
#define NUMBER_TOKEN	'#'
#define INDIR_TOKEN	'@'	/* One of these two should go. */
#define CARRY_TOKEN	'+'	/* One of these two should go. */
#define IS_TOKEN	'='
#define OWNER_TOKEN	'$'

/* matching attribute tokens */
#define AMATCH_CMD	'$'
#define AMATCH_LISTEN	'^'

/* delimiters for various things */
#define EXIT_DELIMITER	';'
#define ARG_DELIMITER	'='
#define ARG_LIST_DELIM	','

/* These chars get replaced by the current item from a list in commands and
 * functions that do iterative replacement, such as @apply_marked, dolist,
 * the eval= operator for @search, and iter().
 */

#define BOUND_VAR	"##"

/* amount of object endowment, based on cost */
#define OBJECT_ENDOWMENT(cost) (((cost)/mudconf.sacfactor) +mudconf.sacadjust)

/* !!! added for recycling, return value of object */
#define OBJECT_DEPOSIT(pennies) \
(((pennies)-mudconf.sacadjust)*mudconf.sacfactor)


#ifdef VMS
#define unlink delete
#define gmtime localtime
#define DEV_NULL "NL:"
#define READ socket_read
#define WRITE socket_write
#else
#define DEV_NULL "/dev/null"
#define READ read
#define WRITE write
#endif

#ifdef BRAIN_DAMAGE		/* a kludge to get it to work on a mutant
				 * DENIX system */
#undef toupper
#endif

#ifdef TEST_MALLOC
extern int malloc_count;

#define XMALLOC(x,y) (fprintf(stderr,"Malloc: %s\n", (y)), malloc_count++, \
		      (char *)malloc((x)))
#define XFREE(x,y) (fprintf(stderr, "Free: %s\n", (y)), \
                    ((x) ? malloc_count--, free((x)) : (x)))
#else
#define XMALLOC(x,y) (char *)malloc((x))
#define XFREE(x,y) (free((x)))
#endif /* TEST_MALLOC */

#ifdef MSTATS
  struct mstats_value {
      int blocksize;
      int nfree;
      int nused;
  };

#endif /* MSTATS */

#define MA_CACHE_WIDTH	4	/* Number of leaves in a MA cache entry */

#endif /* CONFIG_H */
