/* command.h - declarations used by the command processor */
#include "copyright.h"

#ifndef __COMMAND_H
#define __COMMAND_H

#ifndef	lint
static char command_RCSid[] = "$Id: command.h,v 1.7 1995/03/20 23:59:50 ambar Exp $";
USE(command_RCSid);
#endif

#include "mushdb.h"

#define CMD_NO_ARG(name) \
extern void FDECL(name, (dbref, dbref, int))
#define CMD_ONE_ARG(name) \
extern void FDECL(name, (dbref, dbref, int, char *))
#define CMD_ONE_ARG_CMDARG(name) \
extern void FDECL(name, (dbref, dbref, int, char *, char *[], int))
#define CMD_TWO_ARG(name) \
extern void FDECL(name, (dbref, dbref, int, char *, char *))
#define CMD_TWO_ARG_CMDARG(name) \
extern void FDECL(name, (dbref, dbref, int, char *, char *, char*[], int))
#define CMD_TWO_ARG_ARGV(name) \
extern void FDECL(name, (dbref, dbref, int, char *, char *[], int))
#define CMD_TWO_ARG_ARGV_CMDARG(name) \
extern void FDECL(name, (dbref, dbref, int, char *, char *[], int, char*[], int))

/* Command function handlers */
CMD_ONE_ARG_CMDARG(do_apply_marked);	/* Apply command to marked objects */
CMD_TWO_ARG(do_admin);		/* Change config parameters */
CMD_TWO_ARG(do_alias);		/* Change the alias of something */
CMD_TWO_ARG(do_attribute);	/* Manage user-named attributes */
CMD_ONE_ARG(do_boot);		/* Force-disconnect a player */
CMD_TWO_ARG(do_chown);		/* Change object or attribute owner */
CMD_TWO_ARG(do_chownall);	/* Give away all of someone's objs */
CMD_TWO_ARG(do_clone);		/* Create a copy of an object */
CMD_NO_ARG(do_comment);		/* Ignore argument and do nothing */
CMD_TWO_ARG(do_create);		/* Create a new object */
CMD_ONE_ARG(do_cut);		/* Truncate contents or exits list */
CMD_NO_ARG(do_dbck);		/* Consistency check */
CMD_TWO_ARG(do_decomp);		/* Reproduce commands to recrete obj */
CMD_ONE_ARG(do_destroy);	/* Destroy an object */
CMD_TWO_ARG_ARGV(do_dig);	/* Dig a new room */
CMD_ONE_ARG(do_doing);		/* Set doing string in WHO report */
CMD_TWO_ARG_CMDARG(do_dolist);	/* Iterate command on list members */
CMD_ONE_ARG(do_drop);		/* Drop an object */
CMD_NO_ARG(do_dump);		/* Dump the database */
CMD_TWO_ARG_ARGV(do_edit);	/* Edit one or more attributes */
CMD_ONE_ARG(do_enter);		/* Enter an object */
CMD_ONE_ARG(do_entrances);	/* List exits and links to loc */
CMD_ONE_ARG(do_examine);	/* Examine an object */
CMD_ONE_ARG(do_find);		/* Search for name in database */
CMD_TWO_ARG(do_fixdb);		/* Database repair functions */
CMD_TWO_ARG_CMDARG(do_force);	/* Force someone to do something */
CMD_ONE_ARG_CMDARG(do_force_prefixed);	/* #<num> <cmd> variant of FORCE */
CMD_TWO_ARG(do_function);	/* Make iser-def global function */
CMD_ONE_ARG(do_get);		/* Get an object */
CMD_TWO_ARG(do_give);		/* Give something away */
CMD_ONE_ARG(do_global);		/* Enable/disable global flags */
CMD_ONE_ARG(do_halt);		/* Remove commands from the queue */
CMD_ONE_ARG(do_help);		/* Print info from help files */
CMD_NO_ARG(do_inventory);	/* Print what I am carrying */
CMD_TWO_ARG(do_kill);		/* Kill something */
CMD_ONE_ARG(do_last);		/* Get recent login info */
CMD_NO_ARG(do_leave);		/* Leave the current object */
CMD_TWO_ARG(do_link);		/* Set home, dropto, or dest */
CMD_ONE_ARG(do_list);		/* List contents of internal tables */
CMD_ONE_ARG(do_list_file);	/* List contents of message files */
CMD_TWO_ARG(do_lock);		/* Set a lock on an object */
CMD_ONE_ARG(do_look);		/* Look here or at something */
CMD_NO_ARG(do_markall);		/* Mark or unmark all objects */
CMD_ONE_ARG(do_motd);		/* Set/list MOTD messages */
CMD_ONE_ARG(do_move);		/* Move about using exits */
CMD_TWO_ARG_ARGV(do_mvattr);	/* Move attributes on object */
CMD_TWO_ARG(do_mudwho);		/* WHO for inter-mud page/who suppt */
CMD_TWO_ARG(do_name);		/* Change the name of something */
CMD_TWO_ARG(do_newpassword);	/* Change passwords */
CMD_TWO_ARG(do_notify);		/* Notify or drain semaphore */
CMD_TWO_ARG_ARGV(do_open);	/* Open an exit */
CMD_TWO_ARG(do_page);		/* Send message to faraway player */
CMD_TWO_ARG(do_parent);		/* Set parent field */
CMD_TWO_ARG(do_password);	/* Change my password */
CMD_TWO_ARG(do_pcreate);	/* Create new characters */
CMD_TWO_ARG(do_pemit);		/* Messages to specific player */
CMD_ONE_ARG(do_poor);		/* Reduce wealth of all players */
CMD_ONE_ARG(do_ps);		/* List contents of queue */
CMD_ONE_ARG(do_queue);		/* Force queue processing */
CMD_TWO_ARG(do_quota);		/* Set or display quotas */
CMD_NO_ARG(do_readcache);	/* Reread text file cache */
CMD_NO_ARG(do_rwho);		/* Open or close conn to rem RWHO */
CMD_ONE_ARG(do_say);		/* Messages to all */
CMD_NO_ARG(do_score);		/* Display my wealth */
CMD_ONE_ARG(do_search);		/* Search for objs matching criteria */
CMD_TWO_ARG(do_set);		/* Set flags or attributes */
CMD_TWO_ARG(do_setattr);	/* Set object attribute */
CMD_TWO_ARG(do_setvattr);	/* Set variable attribute */
CMD_ONE_ARG(do_shutdown);	/* Stop the game */
CMD_ONE_ARG(do_stats);		/* Display object type breakdown */
CMD_ONE_ARG(do_sweep);		/* Check for listeners */
CMD_TWO_ARG_ARGV_CMDARG(do_switch);	/* Execute cmd based on match */
CMD_TWO_ARG(do_teleport);	/* Teleport elsewhere */
CMD_ONE_ARG(do_timewarp);	/* Warp various timers */
CMD_TWO_ARG(do_toad);		/* Turn a tinyjerk into a tinytoad */
CMD_TWO_ARG_ARGV(do_trigger);	/* Trigger an attribute */
CMD_ONE_ARG(do_unlock);		/* Remove a lock from an object */
CMD_ONE_ARG(do_unlink);		/* Unlink exit or remove dropto */
CMD_ONE_ARG(do_use);		/* Use object */
CMD_NO_ARG(do_version);		/* List MUSH version number */
CMD_TWO_ARG_ARGV(do_verb);	/* Execute a user-created verb */
CMD_TWO_ARG_CMDARG(do_wait);	/* Perform command after a wait */
CMD_ONE_ARG(do_wipe);		/* Mass-remove attrs from obj */

typedef struct cmdentry CMDENT;
  struct cmdentry {
      char *cmdname;
      NAMETAB *switches;
      int perms;
      int extra;
      int callseq;
      void (*handler) ();
  };

/* Command handler call conventions */

#define CS_NO_ARGS	0x0000	/* No arguments */
#define CS_ONE_ARG	0x0001	/* One argument */
#define CS_TWO_ARG	0x0002	/* Two arguments */
#define CS_NARG_MASK	0x0003	/* Argument count mask */
#define CS_ARGV		0x0004	/* ARG2 is in ARGV form */
#define CS_INTERP	0x0010	/* Interpret ARG2 if 2 args, ARG1 if 1 */
#define CS_NOINTERP	0x0020	/* Never interp ARG2 if 2 or ARG1 if 1 */
#define CS_CAUSE	0x0040	/* Pass cause to old command handler */
#define CS_UNPARSE	0x0080	/* Pass unparsed cmd to old-style handler */
#define CS_CMDARG	0x0100	/* Pass in given command args */
#define CS_STRIP	0x0200	/* Strip braces even when not interpreting */
#define	CS_STRIP_AROUND	0x0400	/* Strip braces around entire string only */

/* Command permission flags */

#define CA_PUBLIC	0x00000000	/* No access restrictions */
#define CA_GOD		0x00000001	/* GOD only... */
#define CA_WIZARD	0x00000002	/* Wizards only */
#define CA_BUILDER	0x00000004	/* Builders only */
#define CA_IMMORTAL	0x00000008	/* Immortals only */
#define CA_ROBOT	0x00000010	/* Robots only */

#define CA_NO_HAVEN	0x00001000	/* Not by HAVEN players */
#define CA_NO_ROBOT	0x00002000	/* Not by ROBOT players */
#define CA_NO_SLAVE	0x00004000	/* Not by SLAVE players */
#define CA_NO_SUSPECT	0x00008000	/* Not by SUSPECT players */
#define CA_NO_GUEST	0x00010000	/* Not by GUEST players */

#define CA_GBL_BUILD	0x01000000	/* Requires the global BUILDING flag */
#define CA_GBL_INTERP	0x02000000	/* Requires the global INTERP flag */
#define CA_DISABLED	0x04000000	/* Command completely disabled */
#define	CA_NO_DECOMP	0x08000000	/* Don't include in @decompile */

#define CA_LOCATION	0x10000000	/* Invoker must have location */
#define CA_CONTENTS	0x20000000	/* Invoker must have contents */
#define CA_PLAYER	0x40000000	/* Invoker must be a player */
#define CF_DARK		0x80000000	/* Command doesn't show up in list */

extern int FDECL(check_access, (dbref, int));
extern char *FDECL(process_command, (dbref, dbref, int, char *, char *[], int));

#endif
