;****************************************************************************
;*                                                                          *
;* This is a program that displays PC-text-mode style windows on the        *
;* gameboy. It uses the actual 8x8 font from PC mode 13h.                   *
;*                                                                          *
;* Credits to :                                                             *
;*              Jeff Frohweim                                               *
;*              Marat Fayzullin                                             *
;*              Hero Zero                                                   *
;*              Jens Christian Restemeier                                   *
;*              Dr. Pan/Anthrox                                             *                                                            *
;*                                                                          *
;*              And anyone else who has ever released gameboy source code,  *
;*              tools, or emulators                                         *
;*                                                                          *
;* This program is 100% freeware. Feel free to use the code I have written  *
;* in whole or part in any of your creations, JUST AS LONG AS YOU CREDIT ME *
;* AND THE ABOVE PEOPLE.                                                    *
;*                                                                          *
;* TH/31/1/96 tomh@globalnet.co.uk                                          *
;*                                                                          *
;****************************************************************************

.LIST
.SYM "TextBOY.SYM"
.org $0000
        reti                    ; Set all irq vectors to do nothing.
.org $0040                      ; VBlank IRQ
        reti                    ; Do nothing
.org $0048                      ; LCDC Status IRQ
        reti                    ; Do nothing
.org $0050                      ; Timer Owerflow
        reti                    ; Do nothing
.org $0058                      ; Serial Transfear Completion
        reti                    ; Do nothing
.org $0060                      ; Hmm, this is a weird one
                                ; Im not sure how this one works
                                ; Transition from high to low
                                ; of pin p10-p13
                                ; I think Its a hardware thing
        reti                    ; Do nothing :)
                                ; Irqs done..


;****************************************************************************
;* Cartridge data block                                                     *
;* Don't meddle with this                                                   *
;****************************************************************************
.org $0100                                                                 ;*
.byte $00,$C3                                                              ;*
.dw start                                                                  ;* 
.byte $CE,$ED,$66,$66,$CC,$0D,$00,$0B,$03,$73,$00,$83                      ;*
.byte $00,$0C,$00,$0D,$00,$08,$11,$1F,$88,$89,$00,$0E,$DC,$CC,$6E,$E6      ;*
.byte $DD,$DD,$D9,$99,$BB,$BB,$67,$63,$6E,$0E,$EC,$CC,$DD,$DC,$99,$9F      ;*
.byte $BB,$B9,$33,$3E             ;                                         *
.byte "Gameboy Windows "          ;                                         *
.byte $00,$00,$00                 ; Not used                                *
.byte $03                         ; Cart type   ROM + RAM + BAT + MBC1      *
.byte $00                         ; ROM Size    32k                         *
.byte $02                         ; RAM Size     8k                         *
.byte $CD,$AB                     ; Maker ID    $ABCD = Tom                 *
.byte $01                         ; Version     =1                          *
.byte $DA                         ; Complement check (Important)            *
.byte $FF,$FF                     ; Cheksum (Who cares)                     *
;****************************************************************************

;****************************************************************************
;*                                                                          *
;*                                                     *
;*                                                                    *
;*                                                                  *
;*                                                                    *
;*                                                     *
;*                                                                          *
;****************************************************************************
start:                          ; This is addr $0150
        ld      sp, $FFF4       ; Put the stack where the GB wants it
        ld      a, 0            ; No IRQs at all
        ldh     ($FF),a         ; clear IRQ reg
        call    init_screen     ; set up LCD
        call    nor_col         ; Normal palette
        call    move_char       ; copy in tiles
        call    screen_on       ; switch the screen on
        call    title_screen    ; show the title screen
        ld      bc, $11         ;
        ld      de, $55         ;
        call    draw_box        ; draw a box on2 the screen
endprog:
        jr      endprog

;****************************************************************************
;*                                                                          *
;* This waits util we are in vertical blanking.                             *
;* Its best to wait for 'VBL' b4 messing with the screen                    *
;*                                                                          *
;****************************************************************************

waitvbl:                        ; Wait for VBL
        ldh     a, ($40)        ;
        add     a,a             ;
        ret     nc              ;
notyet:                         ;
        ldh     a, ($44)        ;
        cp      $90             ; $90 and bigger = in VBL
        jr      nz,notyet       ; Loop until it $90
        ret

;****************************************************************************
;*                                                                          *
;* This sets all the colours to white                                       *
;*                                                                          *
;****************************************************************************

white:                          ; All colors to transparent
        ld     a,$00            ; 00000000 = white
        ldh    ($47),a          ; save to BG pal ctrl
        ret                     ; return

;****************************************************************************
;*                                                                          *
;* This sets all the colours to black                                       *
;*                                                                          *
;****************************************************************************

black:                          ; All colors to black
        ld      a,$FF           ; all black
        ldh     ($47),a         ; write to ctrlr
        ret                     ; return

;****************************************************************************
;*                                                                          *
;* This sets all the colours to normal                                      *
;*                                                                          *
;****************************************************************************

nor_col:                        ; Sets the colors to normal palette
        ld      a,%11100100     ; grey 3=11 (Black)
                                ; grey 2=10 (Dark grey)
                                ; grey 1=01 (Ligth grey)
                                ; grey 0=00 (Transparent)
        ldh     ($47),a         ; write it
        ret                     ; return

;****************************************************************************
;*                                                                          *
;* Copy in our reet smart ASCII font                                        *
;*                                                                          *
;****************************************************************************

move_char:
        ld      d, 0            ; 256
        ld      e, 8            ; 4 times = 1024 bytes, write twice = 2k
        ld      hl, $8000       ; dest
        ld      bc, charset     ; source
lp1:                            ;
        ld      a, (bc)         ; get byte
        ld      (hli), a        ; save byte
        ld      (hli), a        ; twice
        inc     bc              ; next byte of char
        dec     d               ; dec counter
        jr      nz, lp1         ; loop
        dec     e               ; next loop
        jr      nz, lp1         ; loop
        ret                     ; exit

;****************************************************************************
;*                                                                          *
;* Joypad routine                                                           *
;* This reads the joypad, and leaves result in A                            *
;* 11111111 - Right                                                         *
;* |||||||----Left                                                          *
;* ||||||-----Up                                                            *
;* |||||------Down                                                          *
;* ||||-------A                                                             *
;* |||--------B                                                             *
;* ||---------Select                                                        *
;* |----------Start                                                         *
;*                                                                          *
;****************************************************************************

joypad:
	ld	a,20h
        ldh     ($00), a
        ldh     a, ($00)
        ldh     a, ($00)
        ldh     a, ($00)
	cpl
	and	0fh
	swap	a
	ld	b,a
	ld	a,10h
        ldh     ($00), a
        ldh     a, ($00)
        ldh     a, ($00)
        ldh     a, ($00)
        ldh     a, ($00)
        ldh     a, ($00)
        ldh     a, ($00)
	cpl
	and	0fh
	or	b
        swap    a
	ret

;****************************************************************************
;*                                                                          *
;* ClrScr :- this clears the background screen to 0                         *
;*                                                                          *
;****************************************************************************

clrscr:
        call    waitvbl
        ld      e, 32           ; 32 rows
        ld      hl, $9800       ; destination
        ld      a, 0            ; val = 0
clrloop2:                       ;
        ld      d, 32           ; 32 cols
clrloop:                        ;
        ld      (hli), a        ; save it, inc HL
        dec     d               ; cycle
        jr      nz, clrloop     ; next loop
        dec     e               ; dec loop ctr
        jr      nz, clrloop2    ; next cycle
        ret                     ; exit

;****************************************************************************
;*                                                                          *
;* Multiply routine                                                         *
;* HL = A x E                                                               *
;*                                                                          *
;****************************************************************************

mul:
        ld      hl, 0
        ld      d, h
mul_loop:
        or      a
        jr      z, endp
        rra
        jr      nc, loop1
        add     hl, de
loop1:
        push    de
        push    hl
        pop     de
        pop     hl
        add     hl, hl
        push    de
        push    hl
        pop     de
        pop     hl
        jr      loop1
endp:
        ret

;****************************************************************************
;*                                                                          *
;* Divide routine                                                           *
;*                          L                                               *
;*                         ---                                              *
;*                          C                                               *
;* L = quotient                                                             *
;* H = remainder                                                            *
;*                                                                          *
;****************************************************************************

div:    ld      b, 8
        ld      h, 0
div1:   add     hl, hl
        ld      a, h
        sub     c
        jr      c, div2
        ld      a, h
        inc     l
div2:
        dec     b
        jr      nz, div1
        ret

;****************************************************************************
;*                                                                          *
;* This switches on the sprites                                             *
;*                                                                          *
;****************************************************************************

show_sprites:
        ldh     a, ($40)        ; lcd ctrlr port
        set     1, a            ; set the bit
        ldh     ($40), a        ; write it
        ret                     ; exit

;****************************************************************************
;*                                                                          *
;* This switches off the sprites                                            *
;*                                                                          *
;****************************************************************************

hide_sprites:
        ldh     a, ($40)        ; lcd ctrlr port
        res     1, a            ; set the bit
        ldh     ($40), a        ; write it
        ret                     ; exit

;****************************************************************************
;*                                                                          *
;* Write some text on2 the screen (background)                              *
;* Regs :                                                                   *
;*       HL : ptr to text                                                   *
;*       B  : Xpos                                                          *
;*       C  : Ypos                                                          *
;*                                                                          *
;* This piece of code is a bloody mess, coz of the Z80's deficiency at      *
;* dealing with 16-bit quantities                                           *
;****************************************************************************

write_text:
        push    hl              ; save text ptr
        ld      h, 0            ; load pos'n
        ld      l, c            ; load Y
        add     hl, hl          ; shift it left 5 times
        add     hl, hl          ; so we mul by 32
        add     hl, hl          ; which happens to be the
        add     hl, hl          ; width of the GB's 
        add     hl, hl          ; BG tile buffer
        ld      c, b            ; load x into low reg
        ld      b, 0            ; clear high, so have X in BC
        add     hl, bc          ; add to y offset
        ld      de, $9800       ; load BG tile buffer
        add     hl, de          ; add offset to it
        ld      d, h            ; now copy this
        ld      e, l            ; into DE
        pop     hl              ; restore string ptr
text_loop:
        ld      a, (hli)        ; load char, and point to next one
        or      a               ; set up flags for A
        ret     z               ; if zero, exit
        ld      (de), a         ; write it
        inc     de              ; next tile
        jr      text_loop       ; cycle

;****************************************************************************
;*                                                                          *
;* This code sets all of the screen to the char spec'd in A                 *
;*                                                                          *
;****************************************************************************

set_char:
        ld      hl, $9800       ; BG tile buf
        ld      d, 32
su_wloop:
        ld      e, 32
write_loop:
        ld      (hli), a        ; write it
        dec     e
        jr      nz, write_loop
        dec     d
        jr      nz, su_wloop
        ret

;****************************************************************************
;*                                                                          *
;* This code copies the screen pointed to in BC into the background tile    *
;* buffer                                                                   *
;*                                                                          *
;****************************************************************************

cp_screen:
        ld      hl, $9800       ; target
        ld      d, 32           ; 32 rows
wloop2:                         ;
        ld      e, 32           ; 32 cols
hole1:                          ; wait for access
        ldh     a,(41h)         ; wait for access to video RAM
        and     2               ;
        jr      nz,hole1        ;
wloop1:                         ; FIRE!!! 16 bytes to the VRAM sah!
        ld      a,(bc)          ; copy byte
        ld      (hli), a        ; save
        inc     bc              ; next byte
        dec     e               ; loop
        jr      nz, wloop1      ; 
        dec     d               ; next row
        jr      nz, wloop2      ; wait for next access
        ret                     ; exit

;****************************************************************************
;*                                                                          *
;* Switch the screen on                                                     *
;*                                                                          *
;****************************************************************************

screen_on:
        call    waitvbl         ; Must be in VBL before turning the screen On.
        ldh     a, ($40)        ; load old val
        set     7, a            ; SET bit 7
        ldh     ($40), a        ; write back
        ret

;****************************************************************************
;*                                                                          *
;* Switch the screen off                                                    *
;*                                                                          *
;****************************************************************************

screen_off:
        call    waitvbl         ; Must be in VBL before turning the screen On.
        ldh     a, ($40)        ; load old val
        res     7, a            ; reset bit 7
        ldh     ($40), a        ; write back
        ret

;****************************************************************************
;*                                                                          *
;* Set up the screen                                                        *
;*                                                                          *
;****************************************************************************

init_screen:
        call    waitvbl
        ld      a, $13          ; bg, obj, $9800, $8000, nowin, etc
        ldh     ($40), a
        ld      a, 0
        ldh     ($41),a         ; LCDC Status
        nop                     ; wait (just in case h/ware is slow)
        ldh     ($42),a         ; Screen scroll Y=0
        nop                     ; wait (just in case h/ware is slow)
        ldh     ($43),a         ; Screen scroll X=0
        ret

;****************************************************************************
;*                                                                          *
;* This code draws the title screen, and waits for the user to press start  *
;* It then blanks the screen, and returns control (no nasty cheapo text     *
;* debris then y'see)                                                       *
;*                                                                          *
;****************************************************************************

title_screen:
        call    waitvbl
        ld      hl,$9800
        ld      bc, title_text
        ld      d,$00
        ld      e,$04           ; 256*4=1024=32x32=One whole GB Screen
title_copy:
        ld      a,(bc)
        ld      (hli), a
        inc     bc
        dec     d
        jr      nz, title_copy
        dec     e
        jr      nz, title_copy
wait_for_key:
        call    joypad
        and     $80
        jr      z, wait_for_key
blank:
        call    waitvbl
        ld      hl, $9800
        ld      b, 4
        ld      c, 0
        ld      a, 0
blank_loop:
        ld      (hli), a
        dec     c
        jr      nz, blank_loop
        dec     b
        jr      nz, blank_loop
        ret

;****************************************************************************
;*                                                                          *
;* This code draws a box. This is used to outline the window, ready to be   *
;* filled and used.                                                         *
;* Regs:                                                                    *
;*         B = X1                                                           *
;*         C = Y1                                                           *
;*         D = X2                                                           *
;*         E = Y2                                                           *
;*                                                                          *
;****************************************************************************

draw_box:
        ld      a, ' '          ;
        call    fillbox         ; fill in the box we're gonna draw ...
        push    bc              ; save important stuff
        push    de              ; for later use
        ld      h, c            ; save some stuff in2 HL, which ain't used
        ld      l, e            ; next Y. so we have saved Y's ...
        ld      e, ''          ;
        call    hline           ; write top line ...
        ld      e, ''          ; fill char
        ld      c, l            ; load y2
        call    hline           ; write bottom line
; now we have the following vals in the following regs ...
; B = x1
; E = 
; D = x2
; C = y2
; H = y1
; L = y2
        ld      e, b            ; our X, which is X1
        ld      b, h            ; put y1 & y2
        ld      c, l            ; in2 BC
        ld      h, d            ; save X2 4 l8r ...
        ld      d, ''          ; vertical char
        call    vline           ; draw that ...
        ld      e, h            ; get x2
        call    vline           ; draw that one ...
        pop     de              ; this little trick upd8s the regs with their        
        pop     bc              ; stack values, and keeps the stack the same
        push    bc              ;
        push    de              ;
        ld      h, b            ; save x1
        ld      a, ''          ; 
        call    drawchar        ; put corner char
        ld      b, d            ; load x2
        ld      a, ''          ; print this char
        call    drawchar        ;
        ld      c, e            ; now move on2 the lower line ...
        ld      b, h            ; restore x1
        ld      a, ''          ;
        call    drawchar        ;
        ld      b, d            ; get X2
        ld      a, ''          ;
        call    drawchar        ;
        pop     de              ;                                             
        pop     bc              ; vals off the stack ...
        ret                     ; all done !!!!

;****************************************************************************
;*                                                                          *
;* This code just draws a char onto the screen at a spec'd pos              *
;*                                                                          *
;* Regs:                                                                    *
;*       B = X                                                              *
;*       C = Y                                                              *
;*       A = char#                                                          *
;*                                                                          *
;****************************************************************************

drawchar:
        push    af              ;
        push    bc              ;
        push    de              ;
        push    hl              ;
        ld      h, 0            ;
        ld      l, c            ;
        add     hl, hl          ; mul hl by 32 to get row offset ...
        add     hl, hl          ;
        add     hl, hl          ;
        add     hl, hl          ;
        add     hl, hl          ;
        ld      d, 0            ;
        ld      e, b            ; get x offset
        add     hl, de          ;
        ld      de, $9800       ; offset in memory
        add     hl, de          ;
        push    af              ;
drawcharwait:                   ;
        ldh     a,(41h)         ;
        and     2               ;
        jr      nz,drawcharwait ;
        pop     af              ;
        ld      (hl), a         ; write the char
        pop     hl              ;
        pop     de              ;
        pop     bc              ;
        pop     af              ;
        ret                     ;

;****************************************************************************
;*                                                                          *
;* This draws a horizontal line in the BG buffer                            *
;* Regs:                                                                    *
;*       B = x1                                                             *
;*       C = yline                                                          *
;*       D = x2                                                             *
;*       E = fill char                                                      *
;*                                                                          *
;****************************************************************************

hline:
        push    af              ;
        push    bc              ; save all regs
        push    de              ;
        push    hl              ; 
        ld      a, d            ; find width
        sub     b               ; of line        
        inc     a               ; to draw
        push    af              ; and save it
        ld      l, c            ; get y line
        ld      h, 0            ;
        add     hl, hl          ;
        add     hl, hl          ;
        add     hl, hl          ;
        add     hl, hl          ;
        add     hl, hl          ; * 32 for addx in buffer
        ld      c, b            ;
        ld      b, 0            ; copy just X into BC
        add     hl, bc          ; and add it to HL
        ld      bc, $9800       ; addx of buffer
        add     hl, bc          ; add to current offset
        pop     af              ; get back loop count
        ld      c, a            ; and put in C
hlinewait:                      ;
        ldh     a,(41h)         ; now wait for access to VRAM
        and     2               ;
        jr      nz, hlinewait   ;
        ld      a, e            ; get fill char
fill_hline:                     ;
        ld      (hli), a        ; save char
        dec     c               ; next loop
        jr      nz, fill_hline  ; do next
        pop     hl              ; restore all regs
        pop     de              ;
        pop     bc              ;
        pop     af              ;
        ret

;****************************************************************************
;*                                                                          *
;* This code draws a vertical line                                          *
;* Regs:                                                                    *
;*         B=y1                                                             *
;*         C=y2                                                             *
;*         D=fill char                                                      *
;*         E=x                                                              *
;*                                                                          *
;****************************************************************************

vline:
        push    af              ;
        push    bc              ; save all
        push    de              ;                
        push    hl              ;
        ld      a, c            ; find width of vline
        sub     b               ;
        inc     a               ;
        push    af              ; save size of vline
        ld      l, b            ; load HL with y1
        ld      h, 0            ;
        add     hl, hl          ;
        add     hl, hl          ;
        add     hl, hl          ;
        add     hl, hl          ;
        add     hl, hl          ; * 32 for row across
        ld      b, d            ; temp save fill char
        ld      d, 0            ; just X in de
        add     hl, de          ; now add in X
        ld      de, $9800       ; bg tile buffer offset
        add     hl, de          ; add in
        pop     af              ; get back line size
        ld      c, a            ; and save in C
vlinewait:                      ;
        ldh     a,(41h)         ; now wait for access to VRAM
        and     2               ;
        jr      nz, vlinewait   ;
        ld      a, b            ; get fill char
        ld      de, 32          ; amount to get to next row
vline_loop:                     ;
        ld      (hl), a         ; write
        add     hl, de          ; next row
        dec     c               ;
        jr      nz, vline_loop  ; next pixel
        pop     hl              ;
        pop     de              ;
        pop     bc              ; restore and return
        pop     af              ;
        ret                     ;

;****************************************************************************
;*                                                                          *
;* This code will fill a box from (b, c) to (d, e) with char A              *
;* Used for blanking out screen for boxes 2 be drawn on2                    *
;*                                                                          *
;****************************************************************************

fillbox:
        push    af              ;
        push    bc              ;
        push    de              ;
        push    hl              ; save regs... nice clean code
        ld      h, a            ; save char 4 now ...
        ld      a, e            ; find out how many lines ...
        sub     c               ;
        inc     a               ; blah
        jr      z, no_fill      ;
        ld      l, a            ; stick it in L
        ld      a, h            ; get back fill char
fill_loop:
        call    hline           ; draw the line
        inc     c               ;
        dec     l               ; check if done
        jr      nz, fill_loop   ;
no_fill:                        ;
        pop     hl              ;
        pop     de              ;
        pop     bc              ;
        pop     af              ;
        ret                     ;
;****************************************************************************
;
;           
;                        
;                
;                        
;                      
;
;****************************************************************************
#include        "font.inc"

.org $3000
title_text:
.byte             "Gameboy Windows v1.0"
.org $3020
.byte             "--------------------"
.org $3040
.byte             "This is a simple    "
.org $3060
.byte             "program that I have "
.org $3080
.byte             "written, for drawing"
.org $30A0
.byte             "little windows onto "
.org $30C0
.byte             "the gameboy. This   "
.org $30E0
.byte             "code will come in   "
.org $3100
.byte             "useful for GUI's if "
.org $3120
.byte             "anyone wants to do  "
.org $3140
.byte             "some work with this "
.org $3160
.byte             "--------------------"
.org $3180
.byte             "Look out for new    "
.org $31A0
.byte             "versions, which     "
.org $31C0
.byte             "should be able to   "
.org $31E0
.byte             "use the usual little"
.org $3200                           
.byte             "icons and things.   "
.org $3220
.byte             "--------------------"
;****************************************************************************
.end

