/***************************************************************************

  vidhrdw.c

  Functions to emulate the video hardware of the machine.

***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "z80.h"
#include "machine.h"
#include "gfxdecod.h"
#include "vidhrdw.h"
#include "roms.h"
#include "memmap.h"
#include "osdepend.h"

#include <allegro.h>

#define FRAMES_PER_SECOND 60


int             X,
                Y;
int             count1,
                spritenum,
                colour,
                direction;
int             offset_value;
int             i;


void            vh_setcolor(char red, char green, char blue, unsigned short color)
{
    color = 3 * color;
    pal[color++] = red;
    pal[color++] = green;
    pal[color] = blue;
}

 /* to speed up video refresh */
/***************************************************************************

  Initialize the video hardware. Returns 0 if successful.
  This usually involves no more than loading the graphics roms, decoding
  them and store the graphics somewhere.

  In the case of Arcade, since we support several different games, we also
  pick the appropriate palette and lookup table.

***************************************************************************/
int             vh_init(const char *gamename)
{
    int             i,
                    gameemulated;
    char           *tmpstorage;

    if ((tmpstorage = malloc(0x4000)) == 0)
        return 1;

    i = 0;
    while (gamevidinfo[i].name && stricmp(gamename, gamevidinfo[i].name) != 0)
        i++;
    gameemulated = i;

    if (gameemulated == MOONCRST)
    {
        base = 0x9000;
        MAXCHARS = 512;
        MAXSPRITES = 128;
        MAXPALETTES = 16;
    }
    else if (gameemulated == FROGGER)
    {
        base = 0xa800;
        MAXCHARS = 256;
        MAXSPRITES = 64;
        MAXPALETTES = 16;
    }
    else if ((gameemulated == AMIDAR) ||
             (gameemulated == TURTLES))
    {
        base = 0x9000;
        MAXCHARS = 256;
        MAXSPRITES = 64;
        MAXPALETTES = 16;
    }
    else if (gameemulated == THEEND)
    {
        base = 0x4800;
        MAXCHARS = 256;
        MAXSPRITES = 64;
        MAXPALETTES = 16;
    }
    else
    {                           // Galaxian and the rest
        base = 0x5000;
        MAXCHARS = 256;
        MAXSPRITES = 64;
        MAXPALETTES = 16;
    }
    if (readroms(tmpstorage, gamevidinfo[i].gfxrom, gamename) != 0)
    {

        free(tmpstorage);
        return 1;
    }

    decodechars(tmpstorage);
    decodesprites();

    free(tmpstorage);


    return 0;
}



/***************************************************************************

  Start the video hardware emulation, that is set up a gfx mode, load the
  appropriate palette, and return. Returns 0 if successful.

***************************************************************************/
int             vh_start(void)
{
    int             i;

    osd_create_display(graphicsmode);

    for (i = 0; i < COLOR_CODES; i++)
    {
        vh_setcolor(0, 0, 0, i * 4);
        vh_setcolor(gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 1] * 3],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 1] * 3 + 1],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 1] * 3 + 2],
                    (i * 4) + 1);
        vh_setcolor(gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 2] * 3],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 2] * 3 + 1],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 2] * 3 + 2],
                   (i * 4) + 2);
        vh_setcolor(gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 3] * 3],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 3] * 3 + 1],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 3] * 3 + 2],
                    (i * 4) + 3);
    }

    osd_set_palette();

    return 0;
}



/***************************************************************************

  Stop the video hardware emulation.

***************************************************************************/
void            vh_stop(void)
{
    osd_close_display();


}


/***************************************************************************

  Redraw the screen.

***************************************************************************/
void            vh_screenrefresh(void)
{

    clear(piccie);

// Draw the characters themselves, shifted into the correct place.
// The are done as sprites so that they can overlay the real sprites.

    for (Y = 0; Y < 32; Y++)
    {
        for (X = 0; X < 32; X++)
        {
            offset_value = RAM[base + (31 - Y) * 32 + X];
            draw_sprite(piccie, chars[offset_value][RAM[base + 0x801 + X * 2]],
                        ((Y * 8 + (unsigned char) RAM[base + 0x800 + X * 2]) % 256), X * 8);
        }
    }

// Blit the sprites. Since the background is cleared and updated every time
// there's really no need to copy the backgrounds.
// First the alien sprites
// Data format is X, num/orientation, colour, Y

    for (count1 = base + 0x840; count1 < base + 0x860; count1 += 4)
    {
        X = RAM[count1];
        spritenum = RAM[count1 + 1];
        colour = RAM[count1 + 2];
        Y = RAM[count1 + 3];
        direction = spritenum >> 6;

//direction now holds the flipping info 0x80 vertical 0x40 horizontal

        spritenum &= 0x3f;
        if (gameemulated == MOONCRST)
        {
            if (Sprite & 0x40)
                if ((spritenum > 31) && (spritenum < 48))
                    spritenum = (spritenum & 0x1f) | Sprite;
        }
        else if ((gameemulated == GALAXIAN) || (gameemulated == GALNAMCO) ||
                (gameemulated == GALAPX) || (gameemulated == SUPGALAX) ||
                (gameemulated == GALTURBO))
        {
                if (spritenum > 49)
                    spritenum = 49;
        }

//there's only 0x40 possible sprites, besides above 0x40 is only the
//flipping info mentioned above.

        if (X && Y && spritenum)
            switch (direction)
            {
            case (0):
                draw_sprite(piccie, sprites[spritenum][colour], X, Y);
                break;
            case (1):
                draw_sprite_v_flip(piccie, sprites[spritenum][colour], X, Y);
                break;
            case (2):
                draw_sprite_h_flip(piccie, sprites[spritenum][colour], X, Y);
                break;
            default:
                draw_sprite_vh_flip(piccie, sprites[spritenum][colour], X, Y);
                break;
            }

    }

// Next the players bullets (Not sure how big they should be)
// Data format is ??, X, ??, -Y

    for (count1 = base + 0x860; count1 < base + 0x880; count1 += 4)
    {
        X = RAM[count1 + 1];
        Y = 256 - RAM[count1 + 3];  // Y is inverted
        if (X && Y)
        {
            if (count1 < base + 0x872)
                vline(piccie, X, Y - 4, Y - 2, 1);  // them - white
            else
                vline(piccie, X, Y - 4, Y - 2, 7);  // us - yellow

        }
    }


    /* if the test key is pressed, let the user change the dip switches */
    if (osd_key_pressed(OSD_KEY_F9))
    {
        int             d,
                        c;

        for (i = OSD_KEY_F1; i <= OSD_KEY_F6; i++)
        {
            if (osd_key_pressed(i))
            {
                d = 1;
                for (c = OSD_KEY_F1; c < i; c++)
                    d <<= 1;
                dsw1 ^= d;
                while (osd_key_pressed(i)); /* wait for the key to be
                                             * released */
                break;
            }
        }
    }
    osd_update_display();


}
