PROGRAM King_of_The_Hill_Trivia; { Version 14.2B }

{$G1}{$P1}

CONST
 maxplayers   = 28;                    { This should be left alone           }
 bbsname      = 'The Theatre of Vampires';  { This is shown on return to the BBS  }
 filelocation = 'C:\BBS\HILL\';        { Notice the \ on the end of the line }
 trashplace   = 'GFILES\TRASHCAN.TXT'; { See History file for explanation    }
 version      = 'Version 14.2';        { Current Version of KOTH Trivia      }
 lowwinscore  = 75000.0;               { Minimum score required to win games }
 updatesl     = 250;                   { Minimum security level for update   }
 gamelength   = 15;                    { Number of days before win seacrh    }

TYPE stp     = string[10];
     str     = string[160];
     userrec = Record
                name:string[25];
                realname:string[14];
                laston:stp;
                linelen:byte;
                pagelen:byte;
                sl:byte;
                age:byte;
                sex:char;
                callsign:string[8];
                gold:real;
               End;
     player  = Record
                realname:string[41];
                name:stp;
                position:byte;
                score:real;
                waiting:real;
                bonus:real;
                laston:byte;
                nextquestion:byte;
               End;
     hall    = Record
                points:real;
                winner:str;
                datein:stp;
                getwin:integer;
               End;
     tested  = Record
                person:stp;
                winner:byte;
               End;
     asking  = Record
                question:str;
                answer:str;
                whose:str;
                right:integer;
                asked:integer;
               End;
     regs    = Record
                ax,bx,cx,dx,bp,si,di,ds,es,flags:integer;
               End;

VAR
 thisuser                                               : userrec;
 playerrecd                                             : player;
 hallrecd                                               : hall;
 testedrecd                                             : tested;
 askingrecd                                             : asking;
 rp                                                     : regs;
 playerfile,tempplfile                                  : file of player;
 hallfile                                               : file of hall;
 testedfile,temperfile                                  : file of tested;
 askingfile,addaskfile,tempasfile                       : file of asking;
 bentst,b1,canplay,hangup,incom,okansi,played,psl,
 showonly,so,reroll,keepon,got1right,wintime            : boolean;
 count,oppnum,planum,p1,p2,p3,tl1,tl2,today,tp1,
 tp2,tq1,tq2,winpla,dpc,logged                          : byte;
 cc                                                     : char;
 payoff1,payoff2,ptsavl,startquestion,
 usernum,w,x,y,z                                        : integer;
 playerscore,tb1,tb2,timeleft,timeon,
 bestscore,hp1,hp2,ts1,ts2,tw1,tw2,xxr                  : real;
 challange1,challange2,hd1,hd2,oppnam,planam,tn1,tn2    : stp;
 game,gametype,hw1,hw2,playerreal,q,q1,s,r,r1,tt,t1,u   : str;
 trn1,trn2                                              : string[41];
 datapath,gfilespath,sysopffn                           : string[80];
 sysopf                                                 : text[1024];
 text1                                                  : text;

Function Timer:real;
var
 h,m,s,t:real;
Begin
 rp.ax:=44*256;
 msdos(rp);
 h:=(rp.cx div 256);
 m:=(rp.cx mod 256);
 s:=(rp.dx div 256);
 t:=(rp.dx mod 256);
 Timer:=h*3600+m*60+s;
End;

Procedure SYSOPLOG(c:integer;i:str);
Begin
 if (not so) or incom then
 Begin
  s:='       ';
  if (c>=0) and (c<=7) then
  Begin
   s:=s+(#03);
   str(c,q);
   s:=s+q;
  End;
  s:=s+i;
  writeln(sysopf,s);
 End;
End;

Function Date:str;
 Function Tch(i:str):str;
 Begin
  if length(i)>2 then i:=copy(i,length(i)-1,2) else
  if length(i)=1 then i:='0'+i;
  Tch:=i;
 End;
var m,d,y:string[4];
Begin
 rp.ax:=$2a00;
 msdos(rp);
 str(rp.cx,y);
 str(rp.dx mod 256,d);
 str(rp.dx shr 8,m);
 Date:=Tch(m)+'/'+Tch(d)+'/'+Tch(y);
End;

Function Value(i:str):integer;
var n,n1:integer;
Begin
 val(i,n,n1);
 if n1<>0 then
 Begin
  i:=copy(i,1,n1-1);
  val(i,n,n1)
 End;
 Value:=n;
 if i='' then Value:=0;
End;

Function Cstr(i:integer):str;
var c:str;
Begin
 str(i,c);
 Cstr:=c;
End;

Procedure COLOR(c:integer); forward;

Procedure PROMPT(i:str);
var c:integer;cc:char;
Begin
 if (not hangup) then for c:=1 to length(i) do
 Begin
  if (i[c]=#10) then COLOR(0);
  write(i[c]);
 End;
End;

Procedure COLOR;
var i:str;
Begin
 i:=#3+chr(ord('0')+c);
 PROMPT(i);
End;

Procedure PRINT(i:str);
Begin
 PROMPT(i+chr(13)+chr(10));
End;

Procedure NEWLINE;
Begin
 PROMPT(chr(13)+chr(10));
End;

Procedure QUESTION(i:str);
Begin
 COLOR(5);
 PROMPT(i);
End;

Function Cstrr(rl:real;base:integer):str;
var c1,c2,c3:integer;i:str;r1,r2:real;
Begin
 if rl<=0.0 then Cstrr:='0' else
 Begin
  r1:=ln(rl)/ln(1.0*base);
  r2:=exp(ln(1.0*base)*(trunc(r1)));
  i:='';
  while (r2>0.999) do
  Begin
   c1:=trunc(rl/r2);
   i:=i+copy('0123456789ABCDEF',c1+1,1);
   rl:=rl-c1*r2;
   r2:=r2/(1.0*base);
  End;
  Cstrr:=i;
 End;
End;

Function Empty:boolean;
Begin
 rp.ax:=$0b00;
 msdos(rp);
 if (rp.ax and $00ff)=$00 then Empty:=true
 else Empty:=false;
End;

Function Setright(s:str;x:integer):str;
Begin
 while length(s)<x do s:=' '+s;
 Setright:=s;
End;

Procedure CENTERIT(var i:str);
var n,n1:integer;
Begin
 if i[1]=#2 then i:=copy(i,2,length(i)-1);
 n:=length(i);
 n1:=1;
 while (n1<=length(i)) do
 Begin
  if i[n1]=#3 then
  Begin
   n:=n-2;
   n1:=n1+1;
  End;
  n1:=n1+1;
 End;
 if n<thisuser.linelen then
 i:=copy('                                               ',1,
 (thisuser.linelen-n) div 2)+i;
End;

Procedure RETURN;
Begin
 close(sysopf);
 halt;
End;

Function Getnumber:integer;
var
 t,x:real;
 b:integer;
Begin
 reset(askingfile);
 rp.ax:=44*256;
 msdos(rp);
 t:=(rp.cx div 256);
 x:=(0.01*(t/24));
 t:=(rp.cx mod 256);
 x:=x+(0.09+(t/60));
 t:=(rp.dx div 256);
 x:=x+(0.30*(t/60));
 t:=(rp.dx mod 256);
 x:=x+(0.60*(t/100));
 b:=round(x*100);
 if b>100 then b:=b-100;
 Getnumber:=round(b*filesize(askingfile)/100)-1;
 close(askingfile);
End;

Procedure RETURNTOBBS;
Begin
 NEWLINE;
 if played then
 Begin
  close(playerfile);
  close(askingfile);
  close(testedfile);
 End;
 COLOR(5);
 s:='Returning to '+bbsname;
 CENTERIT(s);
 PROMPT(s);
 COLOR(0);
 delay(500);
 write(chr(12));
 RETURN;
End;

Procedure GETKEY(var c:char;tm:integer;b:byte);
var starttime:real;
Begin
 starttime:=Timer;
 c:=#00;
 while (Empty) and (c=#00) do
 Begin
  if (Timer-starttime>tm) then
  case b of
   0 : c:=chr(13);
   1 : Begin
        hangup:=true;
        RETURNTOBBS;
       End;
   2 : c:='Q';
  End;
 End;
 if c=#00 then
 Begin
  rp.ax:=$0800;
  msdos(rp);
  c:=chr(rp.ax and $00ff);
 End;
End;

Function Ask:boolean;
var c:char;
Begin
 if not hangup then
 Begin
  COLOR(1);
  repeat
   GETKEY(c,30,0);
   c:=upcase(c);
  until (c='Y') or (c='N') or (c=chr(13)) or hangup;
  if c='N' then
  Begin
   PRINT('No');
   Ask:=false;
  End
  else
  Begin
   PRINT('Yes');
   Ask:=true;
  End;
  if hangup then Ask:=false;
 End;
End;

Procedure INPUT(var i:str;ml:integer;tme:integer);
var timein:real;cp:integer;c:char;
Begin
 if not hangup then
 Begin
  cp:=1;
  timein:=Timer;
  repeat
   GETKEY(c,tme,0);
   if (Timer-timein>tme) then c:=chr(13);
   if c<>#13 then
   Begin
    c:=upcase(c);
    if (c>=' ') and (c<chr(127)) then if cp<=ml then
    Begin
     i[cp]:=c;
     cp:=cp+1;
     write(c);
    End else else
    case ord(c) of
     8    :if cp>1 then
           Begin
            c:=chr(8);
            write(#8#32#8);
            cp:=cp-1;
           End;
     21,24:while cp<>1 do
           Begin
            cp:=cp-1;
            write(#8#32#8);
           End;
    End;
   End;
  until (c=#13) or (c=#14) or hangup;
  i[0]:=chr(cp-1);
  NEWLINE;
 End;
End;

Procedure ONEKEY(var c:char;ch:str);
Begin
 repeat
  GETKEY(c,30,1);
  c:=upcase(c);
 until (pos(c,ch)>0) or hangup;
 if hangup then c:=ch[1];
 PRINT(c);
End;

Procedure GETCALLERDATA;
var i:str;n:integer;
Begin
 assign(text1,paramstr(1));
 {$I-}reset(text1);{$I+}
 if ioresult=0 then
 Begin
  readln(text1,usernum);
  readln(text1,thisuser.name);
  readln(text1,thisuser.realname);
  readln(text1,thisuser.callsign);
  readln(text1,thisuser.age);
  readln(text1,thisuser.sex);
  readln(text1,thisuser.gold);
  readln(text1,thisuser.laston);
  readln(text1,thisuser.linelen);
  readln(text1,thisuser.pagelen);
  readln(text1,n);
  psl:=(n>=updatesl);
  readln(text1,n);
  readln(text1,n);
  so:=(n=1);
  readln(text1,n);
  okansi:=(n=1);
  readln(text1,n);
  incom:=(n=1);
  readln(text1,timeleft);
  readln(text1,gfilespath);
  readln(text1,datapath);
  readln(text1,i);
  close(text1);
  sysopffn:=gfilespath+i;
  assign(sysopf,sysopffn);
  {$I-}append(sysopf);{$I+}
  if (ioresult<>0) then
  Begin
   rewrite(sysopf);
  End;
 End
 else
 Begin
  writeln('Error 1');
  halt;
 End;
 hangup:=false;
 timeon:=Timer;
End;

Function Trashname(s:str):boolean;
var done:boolean;ss:str;
Begin
 Trashname:=false;
 done:=false;
 assign(text1,trashplace);
 {$I-}reset(text1);{I+}
 if ioresult<>0 then exit;
 repeat
  readln(text1,ss);
  if s=ss then Trashname:=true;
  if eof(text1) then done:=true;
 until done;
 close(text1);
End;

Procedure MAKEPLAYERFILE;
var reg:regs;
Begin
 with reg do
 Begin
  ax:=$2a00;
  msdos(reg);
  today:=lo(dx);
 End;
 rewrite(playerfile);
 with playerrecd do
 Begin
  realname:='System Info Record';
  name:='Dummy File';
  position:=21;
  score:=0;
  waiting:=0;
  bonus:=0;
  laston:=today;
  nextquestion:=0;
  write(playerfile,playerrecd);
  realname:='No One Yet';
  name:='__________';
  position:=0;
  score:=0;
  waiting:=0;
  bonus:=0;
  laston:=0;
  nextquestion:=0;
  for count:=1 to maxplayers do write(playerfile,playerrecd);
 End;
 close(playerfile);
End;

Procedure MAKETESTEDFILE;
Begin
 rewrite(testedfile);
 with testedrecd do
 Begin
  person:='Dummy';
  winner:=0;
 End;
 write(testedfile,testedrecd);
 close(testedfile);
End;

Procedure MAKEQUESTIONFILE;
Begin
 write(chr(12));
 NEWLINE;NEWLINE;NEWLINE;
 COLOR(1);
 s:='You are missing the question file.  You need the file in your';
 CENTERIT(s);
 PRINT(s);
 COLOR(1);
 s:=filelocation+' directory for the program to work.  We will now create';
 CENTERIT(s);
 PRINT(s);
 COLOR(1);
 s:='one.  Get some questions ready, hit any key to continue.     ';
 CENTERIT(s);
 PROMPT(s);
 GETKEY(cc,60,0);
 rewrite(askingfile);
 repeat
  write(chr(12));
  NEWLINE;NEWLINE;NEWLINE;
  COLOR(2);
  s:='You MUST enter at least one question for the game to work properly!';
  CENTERIT(s);
  PRINT(s);
  NEWLINE;
  COLOR(2);
  s:='Enter a question (DONE or <CR> to begin the game)';
  CENTERIT(s);
  PRINT(s);
  COLOR(5);
  q:='';
  INPUT(q,80,180);
  if hangup then RETURNTOBBS;
  if (q='') or (q='DONE') then
  Begin
   close(askingfile);
   write(chr(12));
   exit;
  End;
  NEWLINE;
  COLOR(2);
  s:='Enter the answer to this question';
  CENTERIT(s);
  PRINT(s);
  COLOR(5);
  r:='';
  INPUT(r,80,180);
  if hangup then RETURNTOBBS;
  NEWLINE;NEWLINE;
  QUESTION('Is this information correct? (Y/n) ');
  if Ask then
  Begin
   with askingrecd do
   Begin
    question:=q;
    answer:=r;
    whose:='XX';
    right:=0;
    asked:=0;
    write(askingfile,askingrecd);
   End;
  End;
 until q='';
 close(askingfile);
End;

Procedure SHOWPLAYERS;
Begin
 reset(playerfile);
 for z:=0 to 28 do
 Begin
  write(chr(12));
  NEWLINE;NEWLINE;
  seek(playerfile,z);
  read(playerfile,playerrecd);
  with playerrecd do
  Begin
   COLOR(2);
   if z>0 then PRINT('Player name         : '+realname) else PRINT(realname);
   COLOR(2);
   if z>0 then PRINT('Game handle         : '+name) else NEWLINE;
   COLOR(2);
   if z=0 then PRINT('Days until log off  : '+Cstr(position))
   else PRINT('Position            : '+Cstr(position));
   COLOR(2);
   if z>0 then PRINT('Current score       : '+Cstrr(score,10));
   COLOR(2);
   if z>0 then PRINT('Points waiting      : '+Cstrr(waiting,10));
   COLOR(2);
   if z>0 then PRINT('Bonus points        : '+Cstrr(bonus,10));
   COLOR(2);
   if z=0 then PRINT('Date of last reset  : '+Cstr(laston))
   else PRINT('Days since played   : '+Cstr(laston));
   COLOR(2);
   if z>0 then PRINT('Next question asked : '+Cstr(nextquestion));
   NEWLINE;
  End;
  COLOR(1);
  PRINT('  1: Record correct, proceed.');
  COLOR(1);
  PRINT('  2: Record incorrect, fix it.');
  NEWLINE;
  COLOR(1);
  PRINT('  Q> Quit.');
  NEWLINE;NEWLINE;
  PROMPT('Enter the number/letter for what you want to do :  ');
  GETKEY(cc,30,2);
  cc:=upcase(cc);
  if cc='Q' then
  Begin
   close(playerfile);
   reset(playerfile);
   exit;
  End;
  if cc='2' then
  Begin
   write(chr(12));
   NEWLINE;NEWLINE;
   if z>0 then
   Begin
    PROMPT('Enter the new player name       : ');
    INPUT(q1,80,180);
    if hangup then RETURNTOBBS;
    if q1<>'' then with playerrecd do realname:=q1;
    PROMPT('Enter the new game handle       : ');
    INPUT(q1,80,180);
    if hangup then RETURNTOBBS;
    if q1<>'' then with playerrecd do name:=q1;
    PRINT('The position can''t be changed');
    PROMPT('Enter the new score             : ');
    INPUT(q1,10,180);
    if hangup then RETURNTOBBS;
    if q1<>'' then
    Begin
     val(q1,xxr,y);
     with playerrecd do score:=xxr;
    End;
    PROMPT('Enter the new waiting value     : ');
    INPUT(q1,10,180);
    if hangup then RETURNTOBBS;
    if q1<>'' then
    Begin
     val(q1,xxr,y);
     with playerrecd do waiting:=xxr;
    End;
    PROMPT('Enter the new bonus value       : ');
    INPUT(q1,10,180);
    if hangup then RETURNTOBBS;
    if q1<>'' then val(q1,xxr,y) else xxr:=0;
    if xxr<0 then xxr:=0;
    with playerrecd do bonus:=xxr;
    PROMPT('Enter the new days since played : ');
    INPUT(q1,10,180);
    if hangup then RETURNTOBBS;
    if q1<>'' then
    Begin
     val(q1,x,y);
     with playerrecd do laston:=x;
    End;
    PROMPT('Enter the new next question     : ');
    INPUT(q1,10,180);
    if hangup then RETURNTOBBS;
    if q1<>'' then
    Begin
     val(q1,x,y);
     with playerrecd do nextquestion:=x;
    End;
   End;
   if z=0 then
   Begin
    PROMPT('Enter the days until log off          : ');
    INPUT(q1,10,180);
    if hangup then RETURNTOBBS;
    if q1<>'' then
    Begin
     val(q1,x,y);
     with playerrecd do position:=x;
    End;
    PROMPT('Enter the new date (for forced reset) : ');
    INPUT(q1,10,180);
    if hangup then RETURNTOBBS;
    if q1<>'' then
    Begin
     val(q1,x,y);
     with playerrecd do laston:=x;
    End;
   End;
  End;
  seek(playerfile,z);
  write(playerfile,playerrecd);
 End;
 close(playerfile);
 write(chr(12));
End;

Procedure DAILYRESET;
var daystilloff:integer;
Begin
 xxr:=0;
 reroll:=true;
 SYSOPLOG(5,'King Trivia Daily Update - '+gametype);
 NEWLINE;
 COLOR(1);
 PRINT('Now doing daily maintenance...');
 assign(tempplfile,filelocation+'koth-'+game+'.tmp');
 rewrite(tempplfile);
 reset(playerfile);
 seek(playerfile,0);
 read(playerfile,playerrecd);
 with playerrecd do
 Begin
  laston:=today;
  daystilloff:=position;
 End;
 seek(playerfile,0);
 write(tempplfile,playerrecd);
 p3:=0;
 COLOR(5);
 for count:=1 to maxplayers do
 Begin
  seek(playerfile,count);
  read(playerfile,playerrecd);
  with playerrecd do
  Begin
   if name<>'__________' then
   Begin
    waiting:=waiting+((29-position)*10);
    laston:=succ(laston);
   End;
   if laston<=daystilloff then
   Begin
    if score>xxr then xxr:=score;
    position:=count-p3;
    write(tempplfile,playerrecd);
    PROMPT('+');
   End
   else
   Begin
    p3:=succ(p3);
    if name<>'__________' then
    SYSOPLOG(1,'Deleted King Trivia Player: #'+Cstr(position)+' '+name+', '+realname);
   End;
  End;
 End;
 COLOR(2);
 for count:=1 to p3 do
 Begin
  with playerrecd do
  Begin
   realname:='No One Yet';
   name:='__________';
   position:=28-p3+count;
   score:=0;
   waiting:=0;
   bonus:=0;
   laston:=0;
   nextquestion:=0;
   position:=0;
  End;
  write(tempplfile,playerrecd);
  PROMPT('-');
 End;
 close(playerfile);
 close(tempplfile);
 erase(playerfile);
 rename(tempplfile,filelocation+'koth-'+game+'.plf');
 reset(hallfile);
 seek(hallfile,0);
 read(hallfile,hallrecd);
 if hallrecd.getwin>0 then hallrecd.getwin:=hallrecd.getwin-1;
 if xxr>lowwinscore then hallrecd.points:=xxr else hallrecd.points:=lowwinscore;
 Begin
  seek(hallfile,0);
  write(hallfile,hallrecd);
 End;
 close(hallfile);
 write(chr(12));
End;

Procedure CHECKDATE;
var reg:regs;
Begin
 reroll:=false;
 with reg do
 Begin
  ax:=$2a00;
  msdos(reg);
  today:=lo(dx);
 End;
 reset(playerfile);
 seek(playerfile,0);
 read(playerfile,playerrecd);
 close(playerfile);
 if playerrecd.laston<>today then DAILYRESET;
End;

Function Centerstring(s:str;x:byte):str;
Begin
 y:=round(int((x-length(s))/2));
 for z:=1 to y do s:=' '+s;
 while length(s)<x do s:=s+' ';
 Centerstring:=s;
End;

Function Getnextplayer(x:byte):stp;
Begin
 reset(playerfile);
 seek(playerfile,x);
 read(playerfile,playerrecd);
 close(playerfile);
 with playerrecd do Getnextplayer:=name;
End;

Procedure SHOWBOARD;
Begin
 write(chr(12));
 count:=1;
 s:=#03+'2HIGH SCORE';
 for y:=1 to 58 do s:=s+' ';
 s:=s+'LATEST WIN';
 s:=Centerstring(s,80);
 PRINT(s);
 count:=1;
 for w:=1 to 7 do
 Begin
  s:='';
  for x:=1 to w do
  Begin
   s:=s+' '+Centerstring(Getnextplayer(count),10);
   count:=succ(count);
  End;
  s:=s+' ';
  if w=1 then
  Begin
   r:=Centerstring(hw1,10);
   for y:=1 to 24 do r:=r+' ';
   r:=r+#03+'6'+s+#03+'0';
   for y:=1 to 22 do r:=r+' ';
   r:=r+Centerstring(hw2,10);
   PRINT(r);
   r:=Centerstring(Cstrr(hp1,10),10);
   for y:=1 to 58 do r:=(r+' ');
   r:=r+Centerstring(Cstrr(hp2,10),10);
   PRINT(r);
  End;
  if w=2 then
  Begin
   s:=(' '+hd1+'                   '+#03+'1'+s);
   s:=(s+'                  '+#03+'0'+hd2);
   PRINT(s);
  End;
  if w>2 then
  Begin
   COLOR(1);
   CENTERIT(s);
   PRINT(s);
  End;
  if w>1 then NEWLINE;
 End;
End;

Procedure PLAY; FORWARD;

Procedure NOMOREROOM;
Begin
 if psl then showonly:=true else
 Begin
  SHOWBOARD;
  SYSOPLOG(6,'Tried Logging On '+gametype+' King Trivia, Game Full');
  NEWLINE;NEWLINE;
  COLOR(2);
  PRINT('I''m sorry, but this section is full.  Let the SYSOP know please!');
  NEWLINE;
  delay(2000);
  PLAY;
 End;
End;

Procedure ADDPLAYER;
Begin
 write(chr(12));
 NEWLINE;NEWLINE;NEWLINE;
 COLOR(1);
 PRINT('You seem to be a new player.  Wait while I find a slot for you...');
 delay(500);
 NEWLINE;
 x:=0;
 repeat
  COLOR(1);
  PROMPT('Enter an alias (3 - 10 characters) for the game: ');
  COLOR(2);
  INPUT(s,10,180);
  if hangup then RETURNTOBBS;
  if Trashname(s) then s:='';
  if length(s)<3 then
  Begin
   NEWLINE;
   COLOR(6);
   PRINT(#07+'Sorry, bad choice...  Try again!'+#07);
  End;
  x:=succ(x);
  if (x=3) and (length(s)<3) then PLAY;
 until length(s)>2;
 seek(playerfile,planum);
 read(playerfile,playerrecd);
 x:=Getnumber;
 with playerrecd do
 Begin
  realname:=thisuser.name;
  name:=s;
  position:=planum;
  score:=0;
  waiting:=0;
  bonus:=0;
  laston:=1;
  nextquestion:=x;
 End;
 seek(playerfile,planum);
 write(playerfile,playerrecd);
 close(playerfile);
 SYSOPLOG(2,'New King Trivia Player ('+gametype+') : #'+Cstr(planum)+' '+s);
 logged:=1;
 reset(playerfile);
 write(chr(12));
End;

Procedure CHECKFORPLAYER;
var
 asked,joingame : boolean;
 s              : str;
Begin
 asked:=false;
 joingame:=false;
 b1:=false;
 count:=1;
 reset(playerfile);
 repeat
  seek(playerfile,count);
  read(playerfile,playerrecd);
  with playerrecd do
  Begin
   if realname=thisuser.name then
   Begin
    if ((not reroll) and (logged=0)) then logged:=2;
    b1:=true;
    planum:=count;
   End;
  End;
  count:=succ(count);
 until (b1) or (eof(playerfile));
 close(playerfile);
 if not b1 then
 Begin
  count:=1;
  reset(playerfile);
  repeat
   seek(playerfile,count);
   read(playerfile,playerrecd);
   with playerrecd do
   Begin
    if realname='No One Yet' then
    Begin
     if psl then
     Begin
      NEWLINE;NEWLINE;
      asked:=true;
      COLOR(2);
      s:='Do you want to join the game? ';
      CENTERIT(s);
      PROMPT(s);
      COLOR(3);
      PROMPT('(Y/n) ');
      COLOR(1);
      if Ask then joingame:=true;
     End;
     if ((joingame) and (psl)) or not(psl) then
     Begin
      b1:=true;
      planum:=count;
      ADDPLAYER;
     End;
    End;
   End;
   count:=succ(count);
  until (b1) or (eof(playerfile)) or (asked);
  close(playerfile);
 End;
 if not b1 then NOMOREROOM
End;


Procedure MAKENEWHALLFILE;
Begin
 rewrite(hallfile);
 hallrecd.points:=lowwinscore;
 hallrecd.winner:='----------';
 hallrecd.datein:='XX/XX/XX';
 hallrecd.getwin:=gamelength;
 for x:=0 to 2 do
 Begin
  seek(hallfile,x);
  write(hallfile,hallrecd);
 End;
 close(hallfile);
 reset(hallfile);
End;

Procedure UPDATEHALLWINNERS;
Begin
 reset(playerfile);
 seek(playerfile,1);
 read(playerfile,playerrecd);
 s:=playerrecd.name;
 {$I-}reset(hallfile);{$I+}
 if ioresult<>0 then MAKENEWHALLFILE;
 seek(hallfile,0);
 read(hallfile,hallrecd);
 hallrecd.points:=lowwinscore;
 hallrecd.getwin:=gamelength;
 seek(hallfile,0);
 write(hallfile,hallrecd);
 seek(hallfile,1);
 read(hallfile,hallrecd);
 if playerscore>hallrecd.points then
 Begin
  hallrecd.points:=playerscore;
  hallrecd.winner:=s;
  hallrecd.datein:=Date;
  seek(hallfile,1);
  write(hallfile,hallrecd);
 End;
 seek(hallfile,2);
 read(hallfile,hallrecd);
 hallrecd.points:=playerscore;
 hallrecd.winner:=s;
 hallrecd.datein:=Date;
 seek(hallfile,2);
 write(hallfile,hallrecd);
 close(hallfile);
End;
Procedure CHANGEHALLSCORE;
Begin
 {I-}reset(hallfile);{I+}
 if ioresult<>0 then MAKENEWHALLFILE;
 seek(hallfile,0);
 read(hallfile,hallrecd);
 hallrecd.points:=playerscore;
 seek(hallfile,0);
 write(hallfile,hallrecd);
End;

Procedure GETHALLDATA;
Begin
 assign(hallfile,filelocation+'koth-'+game+'.hal');
 {$I-}reset(hallfile);{$I+}
 if ioresult<>0 then MAKENEWHALLFILE;
 seek(hallfile,0);
 read(hallfile,hallrecd);
 with hallrecd do
 Begin
  bestscore:=points;
  wintime:=getwin=0;
 End;
 seek(hallfile,1);
 read(hallfile,hallrecd);
 with hallrecd do
 Begin
  hp1:=points;
  hw1:=winner;
  hd1:=datein;
 End;
 seek(hallfile,2);
 read(hallfile,hallrecd);
 with hallrecd do
 Begin
  hp2:=points;
  hw2:=winner;
  hd2:=datein;
 End;
 close(hallfile);
End;

Procedure PREPAREGAME;
Begin
 bentst:=false;
 canplay:=false;
 showonly:=false;
 assign(playerfile,filelocation+'koth-'+game+'.plf');
 {$I-}reset(playerfile);{$I+}
 if ioresult<>0 then MAKEPLAYERFILE;
 close(playerfile);
 assign(testedfile,filelocation+'koth-'+game+'.tst');
 assign(askingfile,filelocation+'koth-'+game+'.ask');
 {$I-}reset(askingfile);{$I+}
 if ioresult<>0 then
 Begin
  if psl then MAKEQUESTIONFILE else
  Begin
   NEWLINE;
   COLOR(1);
   PRINT('I''m sorry but the SYSOP has not created all the necessary files');
   COLOR(1);
   PRINT('that are part of the game.  Please E-Mail him and have him make');
   COLOR(1);
   PRINT('a question file.  Until then this section is dead.  You MAY be');
   COLOR(1);
   PRINT('able to play other section of the game.');
   NEWLINE;NEWLINE;
   COLOR(2);
   PRINT('Strike any key to continue');
   GETKEY(cc,60,0);
   PLAY;
  End;
 End;
 close(askingfile);
 CHECKDATE;
 CHECKFORPLAYER;
End;

Procedure ADDQUESTIONS;
Begin
 write(chr(12));
 NEWLINE;NEWLINE;NEWLINE;
 COLOR(2);
 PROMPT('Enter a question for the ');
 COLOR(1);
 PROMPT(gametype);
 COLOR(2);
 PRINT(' trivia game (DONE or <CR> to quit)');
 COLOR(5);
 INPUT(s,80,180);
 if hangup then RETURNTOBBS;
 if (s='DONE') or (s='') then exit;
 NEWLINE;
 COLOR(2);
 PRINT('Enter the answer to this question');
 COLOR(5);
 INPUT(r,80,180);
 if hangup then RETURNTOBBS;
 if r='' then exit;
 NEWLINE;NEWLINE;
 QUESTION('Is this information correct? (Y/n) ');
 if Ask then
 Begin
  assign(addaskfile,filelocation+'koth-'+game+'.new');
  {$I-}reset(addaskfile);{$I+}
  if ioresult<>0 then rewrite(addaskfile) else
  seek(addaskfile,filesize(addaskfile));
  with askingrecd do
  Begin
   question:=s;
   answer:=r;
   if so then whose:='XX' else whose:=playerreal;
   right:=0;
   asked:=0;
   write(addaskfile,askingrecd);
  End;
  close(addaskfile);
 End;
 delay(500);
 if psl then ADDQUESTIONS;
 write(chr(12));
End;

Procedure CHECKNEWQUESTIONS;
Begin
 write(chr(12));
 NEWLINE;NEWLINE;
 assign(addaskfile,filelocation+'koth-'+game+'.new');
 {$I-}reset(addaskfile);{$I+}
 if ioresult<>0 then
 Begin
  COLOR(1);
  PRINT('There are no new questions now.');
  delay(500);
  exit;
 End;
 assign(tempasfile,filelocation+'koth-'+game+'.tmp');
 rewrite(tempasfile);
 w:=0;
 for x:=0 to filesize(addaskfile)-1 do
 Begin
  seek(addaskfile,x);
  read(addaskfile,askingrecd);
  with askingrecd do
  Begin
   COLOR(1);
   PRINT('The question is');
   PRINT(question);
   COLOR(1);
   PRINT('The answer is');
   PRINT(answer);
   COLOR(1);
   PRINT('It was added by');
   PRINT(whose);
   NEWLINE;
   PRINT('  1: Add this item to the question file.');
   PRINT('  2: Do not accept this question.');
   PRINT('  3: Skip this question.');
   PRINT('  Q: Quit.');
   NEWLINE;NEWLINE;
   PROMPT('Enter the number/letter for what you want to do :  ');
   ONEKEY(cc,'123Q');
   case cc of
    'Q':Begin
         while x<filesize(addaskfile) do
         Begin
          seek(addaskfile,x);
          read(addaskfile,askingrecd);
          seek(tempasfile,filesize(tempasfile));
          write(tempasfile,askingrecd);
          x:=succ(x);
         End;
         close(tempasfile);
         close(addaskfile);
         erase(addaskfile);
         rename(tempasfile,filelocation+'koth-'+game+'.new');
         exit;
        End;
    '1':Begin
         reset(askingfile);
         seek(askingfile,filesize(askingfile));
         write(askingfile,askingrecd);
         close(askingfile);
         if whose<>'XX' then
         Begin
          NEWLINE;
          if psl and (not so) then q1:='250' else
          Begin
           PROMPT('Enter the bonus for this question : ');
           INPUT(q1,10,180);
           if hangup then RETURNTOBBS;
          End;
          reset(playerfile);
          y:=0;
          repeat
           y:=y+1;
           seek(playerfile,y);
           read (playerfile,playerrecd);
          until (playerrecd.realname=whose) or eof(playerfile);
          if playerrecd.realname=whose then
          Begin
           if q1<>'' then val(q1,xxr,z) else xxr:=0;
           if xxr<0 then xxr:=0;
           with playerrecd do bonus:=bonus+xxr;
           seek(playerfile,y);
           write(playerfile,playerrecd);
           close(playerfile);
          End;
         End;
         if eof(addaskfile) then
         Begin
          NEWLINE;NEWLINE;NEWLINE;
          COLOR(2);
          PRINT('There are no more new questions to review.');
         End;
         delay(500);
         write(chr(12));
         NEWLINE;NEWLINE;
        End;
    '2':Begin
         if eof(addaskfile) then
         Begin
          NEWLINE;NEWLINE;NEWLINE;
          COLOR(2);
          PRINT('There are no more new questions to review.');
         End;
         delay(500);
         write(chr(12));
         NEWLINE;NEWLINE;
        End;
    '3':Begin
         w:=succ(w);
         seek(tempasfile,filesize(tempasfile));
         write(tempasfile,askingrecd);
         if eof(addaskfile) then
         Begin
          NEWLINE;NEWLINE;NEWLINE;
          COLOR(2);
          PRINT('There are no more new questions to review.');
         End;
         delay(500);
         write(chr(12));
         NEWLINE;NEWLINE;
        End;
   End;
  End;
 End;
 close(tempasfile);
 close(addaskfile);
 erase(addaskfile);
 if w>0 then rename(tempasfile,filelocation+'koth-'+game+'.new') else erase(tempasfile);
End;

Procedure CHECKQUESTIONFILE;
Begin
 write(chr(12));
 {$I-}reset(askingfile);{$I+}
 if ioresult<>0 then
 Begin
  rewrite(askingfile);
  with askingrecd do
  Begin
   question:='What planet does the moon IO orbit?';
   answer:='JUPITER';
   whose:='XX';
   right:=0;
   asked:=0;
   for x:=1 to 10 do write(askingfile,askingrecd);
  End;
 End;
 close(askingfile);
End;

Procedure PICKSTARTINGPOINT;
Begin
 PRINT('There are '+s+' questions in the file now...');
 PROMPT('With which question do you want to start? ');
 INPUT(r,3,180);
 if hangup then RETURNTOBBS;
 if r='' then x:=1 else val(r,x,z);
 if (x>filesize(askingfile)) or (x<1) then
 Begin
  PRINT('Invalid question number.');
  delay(500);
  write(chr(12));
  PICKSTARTINGPOINT;
 End else startquestion:=x;
End;

Procedure MAKENEWFILE;
Begin
 assign(tempasfile,filelocation+'koth-'+game+'.tmp');
 rewrite(tempasfile);
 {$I-}reset(askingfile);{$I+}
 str(filesize(askingfile),s);
 PICKSTARTINGPOINT;
 if startquestion>1 then
 Begin
  NEWLINE;
  COLOR(5);
  PROMPT('Starting question is # ');
  COLOR(1);
  PRINT(Setright(Cstr(startquestion),3));
  COLOR(5);
  PROMPT('Now storing question # ');
  COLOR(1);
  for x:=0 to startquestion-2 do
  Begin
   prompt(Setright(Cstr(x+1),3));
   seek(askingfile,x);
   read(askingfile,askingrecd);
   seek(tempasfile,filesize(tempasfile));
   write(tempasfile,askingrecd);
   prompt(#08+#08+#08);
  End;
 End;
 for y:=startquestion-1 to filesize(askingfile)-1 do
 Begin
  write(chr(12));
  str(y+1,s);
  seek(askingfile,y);
  read(askingfile,askingrecd);
  with askingrecd do
  Begin
   q:=question;
   r:=answer;
   tt:=whose;
   w:=right;
   z:=asked;
  End;
  COLOR(5);
  PRINT('This is question #'+s+'...');
  NEWLINE;
  COLOR(2);
  PRINT(q);
  COLOR(2);
  PRINT(r);
  COLOR(2);
  PRINT('Added by: '+tt);
  NEWLINE;
  COLOR(7);
  if z>0 then xxr:=w/z*100 else xxr:=0.0;
  PRINT('Times right '+Cstr(w)+', Times asked '+Cstr(z)+', Correct response '+Cstrr(xxr,10)+'%');
  NEWLINE;
  COLOR(1);
  PRINT('  1: Item correct, proceed to next item.');
  COLOR(1);
  PRINT('  2: Item incorrect, fix it.');
  COLOR(1);
  PRINT('  3: Item incorrect, delete it.');
  COLOR(1);
  PRINT('  Q: Quit');
  NEWLINE;
  PROMPT('Enter the number/letter for what you want to do :  ');
  ONEKEY(cc,'Q123');
  case cc of
   'Q':Begin
        COLOR(2);
        write('Copying remining records.');
        seek(tempasfile,filesize(tempasfile));
        write(tempasfile,askingrecd);
        y:=succ(y);
        while y<filesize(askingfile) do
        Begin
         seek(askingfile,y);
         read(askingfile,askingrecd);
         seek(tempasfile,filesize(tempasfile));
         write(tempasfile,askingrecd);
         y:=succ(y);
        End;
        close(askingfile);
        close(tempasfile);
        erase(askingfile);
        rename(tempasfile,filelocation+'koth-'+game+'.ask');
        exit;
       End;
   '1':Begin
        seek(tempasfile,filesize(tempasfile));
        write(tempasfile,askingrecd);
       End;
   '2':Begin
        NEWLINE;NEWLINE;
        PRINT('Enter the new question');
        INPUT(q1,80,180);
        if hangup then RETURNTOBBS;
        NEWLINE;
        PRINT('Enter the new answer');
        INPUT(r1,80,180);
        if hangup then RETURNTOBBS;
        NEWLINE;
        PRINT('Enter the new person adding the data');
        INPUT(t1,41,180);
        QUESTION('Reset the % correct data? (Y/n) ');
        if Ask then
        Begin
         w:=0;
         z:=0;
        End;
        if hangup then RETURNTOBBS;
        if q1<>'' then q:=q1;
        if r1<>'' then r:=r1;
        if t1<>'' then tt:=t1;
        askingrecd.question:=q;
        askingrecd.answer:=r;
        askingrecd.whose:=tt;
        askingrecd.right:=w;
        askingrecd.asked:=z;
        seek(tempasfile,filesize(tempasfile));
        write(tempasfile,askingrecd);
       End;
   '3':Begin
        NEWLINE;
        PRINT('Question deleted.');
        delay(500);
       End;
  End;
 End;
 close(askingfile);
 close(tempasfile);
 erase(askingfile);
 rename(tempasfile,filelocation+'koth-'+game+'.ask');
End;

Procedure EDITQUESTIONFILE;
Begin
 CHECKQUESTIONFILE;
 MAKENEWFILE;
End;

Procedure EDITHALLFILE;
Begin
 {$I-}reset(hallfile);{$I+}
 If ioresult<>0 then MAKENEWHALLFILE;
 x:=0;
 while x<3 do
 Begin
  write(#12);
  seek(hallfile,x);
  read(hallfile,hallrecd);
  COLOR(2);
  if x=0 then PRINT('Current High Score  : '+Cstrr(hallrecd.points,10)) else
  if x=1 then PRINT('All-Time High Score : '+Cstrr(hallrecd.points,10)) else
  PRINT('Latest High Score   : '+Cstrr(hallrecd.points,10));
  COLOR(2);
  if x>0 then
  Begin
   PRINT('Player              : '+hallrecd.winner);
   COLOR(2);
   PRINT('Date Won            : '+hallrecd.datein);
  End else
  Begin
   PRINT('Days Until Next Win : '+Cstr(hallrecd.getwin));
   NEWLINE;
  End;
  NEWLINE;
  COLOR(1);
  PRINT('  1: Item correct, proceed to next item.');
  COLOR(1);
  PRINT('  2: Item incorrect, fix it.');
  COLOR(1);
  PRINT('  Q: Quit.');
  NEWLINE;
  COLOR(1);
  PROMPT('Enter the number/letter for what you want to do :  ');
  ONEKEY(cc,'12Q');
  case(cc) of
   'Q':x:=3;
   '2':Begin
        NEWLINE;NEWLINE;
        if x=0 then
        Begin
         PROMPT('Enter the current hi-score   : ');
         INPUT(q1,10,180);
         if hangup then RETURNTOBBS;
         PROMPT('Enter the days until re-roll : ');
         INPUT(r1,10,180);
         if hangup then RETURNTOBBS;
         if q1<>'' then
         Begin
          val(q1,xxr,y);
          if xxr>0 then with hallrecd do points:=xxr;
         End;
         if r1<>'' then
         Begin
          val(r1,z,y);
          if z>0 then with hallrecd do getwin:=z;
         End;
        End else
        Begin
         PROMPT('Enter the record hi-score    : ');
         INPUT(q1,10,180);
         if hangup then RETURNTOBBS;
         PROMPT('Enter the winner''s name      : ');
         INPUT(r1,10,180);
         if hangup then RETURNTOBBS;
         PROMPT('Enter the date of the win    : ');
         INPUT(t1,8,180);
         if hangup then RETURNTOBBS;
         if q1<>'' then
         Begin
          val(q1,xxr,z);
          if xxr>0 then with hallrecd do points:=xxr;
         End;
         if r1<>'' then with hallrecd do winner:=r1;
         if t1<>'' then with hallrecd do datein:=t1;
        End;
        seek(hallfile,x);
        write(hallfile,hallrecd);
       End;
  End;
  x:=succ(x);
 End;
 close(hallfile);
End;

Procedure ASKIFPLAYING; forward;

Procedure UPDATEMENU;
var done:boolean;
Begin
 done:=false;
 repeat
  b1:=true;
  assign(addaskfile,filelocation+'koth-'+game+'.new');
  {$I-}reset(addaskfile);{$I+}
  if ioresult<>0 then b1:=false else close(addaskfile);
  write(chr(12));
  NEWLINE;NEWLINE;NEWLINE;
  COLOR(2);
  PRINT('1: Add Questions to Question File');
  COLOR(2);
  PRINT('2: Check/Edit Current Question File');
  if b1 then COLOR(6) else COLOR(2);
  PRINT('3: Check New Questions');
  COLOR(2);
  PRINT('4: Edit Player File');
  COLOR(2);
  PRINT('5: Edit Hi-Score File');
  COLOR(2);
  PRINT('Q: Quit file maintenance');
  NEWLINE;
  COLOR(1);
  PROMPT('Enter a number from above to proceed : ');
  ONEKEY(cc,'Q12345');
  case(cc) of
   'Q':done:=true;
   '1':ADDQUESTIONS;
   '2':EDITQUESTIONFILE;
   '3':CHECKNEWQUESTIONS;
   '4':SHOWPLAYERS;
   '5':EDITHALLFILE;
  End;
 until done;
 write(chr(12));
 SHOWBOARD;
 ASKIFPLAYING;
End;

Procedure ONCEADAY;
Begin
 NEWLINE;
 COLOR(6);
 PRINT('I''m sorry, but you have played today already.');
 GETKEY(cc,15,0);
 PLAY;
End;

Procedure CHECKELIGIBILITY;
Begin
 reset(playerfile);
 seek(playerfile,planum);
 read(playerfile,playerrecd);
 with playerrecd do
 Begin
  playerreal:=realname;
  planam:=name;
  playerscore:=score;
  if laston<>0 then canplay:=true;
 End;
 close(playerfile);
 NEWLINE;
 if (not canplay) and (not psl) then ONCEADAY else if logged=2 then
 Begin
  SYSOPLOG(7,'Played King Trivia - '+gametype);
  logged:=1;
 End;
End;

Procedure SHOWCHALLENGERECORD;
Begin
 x:=0;
 y:=0;
 {$I-}reset(testedfile);{$I+}
 if ioresult=0 then
 Begin
  for count:=1 to filesize(testedfile)-1 do
  Begin
   seek(testedfile,count);
   read(testedfile,testedrecd);
   with testedrecd do
   Begin
    if person=planam then
    Begin
     bentst:=true;
     x:=succ(x);
     if winner=0 then y:=succ(y);
    End;
   End;
  End;
  close(testedfile);
  PRINT('You have been challanged '+Cstr(x)+' times:  Won '+Cstr(y)+', Lost '+Cstr(x-y)+'.');
 End;
End;

Procedure ASKIFPLAYING;
Begin
 b1:=true;
 assign(addaskfile,filelocation+'koth-'+game+'.new');
 {$I-}reset(addaskfile);{$I+}
 if ioresult<>0 then b1:=false else close(addaskfile);
 if not showonly then
 Begin
  SHOWCHALLENGERECORD;
  reset(playerfile);
  seek(playerfile,planum);
  read(playerfile,playerrecd);
  with playerrecd do
  Begin
   tt:='You now have '+Cstrr(score,10)+' points, ';
   tt:=tt+Cstrr(waiting,10)+' points waiting, ';
   tt:=tt+Cstrr(bonus,10)+' bonus points.';
   PRINT(tt);
   NEWLINE;
  End;
  close(playerfile);
  if canplay or psl then
  Begin
   if canplay then PRINT('1: Play the game');
   if canplay then PRINT('2: Quit') else PRINT('1: Quit');
   if psl then
   Begin
    if b1 then COLOR(6);
    if canplay then PRINT('3: Update Files') else PRINT('2: Update Files');
   End;
   NEWLINE;
   PROMPT('Enter a number from above to proceed : ');
   if (psl) and (canplay) then ONEKEY(cc,'123') else ONEKEY(cc,'12');
   case(cc) of
    '1':if not(canplay) then PLAY;
    '2':if canplay then PLAY else if psl then UPDATEMENU;
    '3':UPDATEMENU;
   End;
  End;
 End
 else
 if psl then
 Begin
  PRINT('1: Quit');
  if b1 then COLOR(6);
  PRINT('2: Update Files');
  PROMPT('Enter a number from above to proceed : ');
  ONEKEY(cc,'12');
  case(cc) of
   '1':PLAY;
   '2':UPDATEMENU;
  End;
 End
 else
 Begin
  GETKEY(cc,60,1);
  PLAY;
 End;
End;

Procedure CLEARTESTEDRECORDS;
Begin
 bentst:=false;
 {$I-}reset(testedfile);{$I+}
 if ioresult=0 then
 Begin
  assign(temperfile,filelocation+'koth-'+game+'.tmp');
  rewrite(temperfile);
  for count:=0 to filesize(testedfile)-1 do
  Begin
   seek(testedfile,count);
   read(testedfile,testedrecd);
   with testedrecd do if person<>planam then write(temperfile,testedrecd);
  End;
  close(testedfile);
  close(temperfile);
  erase(testedfile);
  rename(temperfile,filelocation+'koth-'+game+'.tst');
 End;
End;

Procedure TOPPLAYER;
Begin
 NEWLINE;NEWLINE;NEWLINE;NEWLINE;
 COLOR(1);
 s:='You are top player and have no one to challange..., but you';
 CENTERIT(s);
 PRINT(s);
 COLOR(1);
 s:='do get to answer a question for 5000 points!!!';
 CENTERIT(s);
 PROMPT(s);
 NEWLINE;NEWLINE;
 s:='Strike a key to continue...';
 CENTERIT(s);
 COLOR(2);
 PROMPT(s);
 GETKEY(cc,30,0);
 ptsavl:=5000;
 oppnam:='';
 oppnum:=0;
End;

Procedure GETCHALLENGER;
Begin
 NEWLINE;NEWLINE;NEWLINE;NEWLINE;
 b1:=false;
 reset(playerfile);
 if p1<>0 then
 Begin
  b1:=true;
  seek(playerfile,p1);
  read(playerfile,playerrecd);
  with playerrecd do
  Begin
   payoff1:=(29-position)*100;
   challange1:=name;
  End;
 End;
 seek(playerfile,p2);
 read(playerfile,playerrecd);
 with playerrecd do
 Begin
  payoff2:=(29-position)*100;
  challange2:=name;
 End;
 if b1 then
 Begin
  PRINT('1: Challange '+challange1+' for '+Cstr(payoff1)+' points');
  PRINT('2: Challange '+challange2+' for '+Cstr(payoff2)+' points');
  NEWLINE;
  PROMPT('Enter a number from above to proceed : ');
  ONEKEY(cc,'12');
  case(cc) of
   '1':Begin
        oppnum:=p1;
        oppnam:=challange1;
        ptsavl:=payoff1;
       End;
   '2':Begin
        oppnum:=p2;
        oppnam:=challange2;
        ptsavl:=payoff2;
       End;
  End;
 End
 else
 Begin
  oppnum:=p2;
  oppnam:=challange2;
  ptsavl:=payoff2;
  PRINT('You only have one person you can challange...');
  PRINT(challange2+' for '+Cstr(payoff2)+' points');
  NEWLINE;
  PRINT('Hit any key to continue');
  GETKEY(cc,30,0);
 End;
 close(playerfile);
End;

Procedure FINDOPTIONS;
Begin
 if bentst then CLEARTESTEDRECORDS;
 write(chr(12));
 case planum of
   1    : Begin
           TOPPLAYER;
           exit;
          End;
   2,3  : Begin
           p1:=0;
           p2:=1;
          End;
   4    : Begin
           p1:=0;
           p2:=2;
          End;
   5    : Begin
           p1:=2;
           p2:=3;
          End;
   6,7  : Begin
           p1:=0;
           p2:=planum-3;
          End;
   8,9  : Begin
           p1:=planum-4;
           p2:=planum-3;
          End;
  10,11 : Begin
           p1:=0;
           p2:=planum-4;
          End;
  12..14: Begin
           p1:=planum-5;
           p2:=planum-4;
          End;
  15,16 : Begin
           p1:=0;
           p2:=planum-5;
          End;
  17..20: Begin
           p1:=planum-6;
           p2:=planum-5;
          End;
  21,22 : Begin
           p1:=0;
           p2:=planum-6;
          End;
  23..27: Begin
           p1:=planum-7;
           p2:=planum-6;
          End;
  28    : Begin
           p1:=0;
           p2:=21;
          End;
 End;
 GETCHALLENGER;
End;

Procedure ADDPOINTS;
Begin
 reset(playerfile);
 seek(playerfile,planum);
 read(playerfile,playerrecd);
 with playerrecd do
 Begin
  score:=score+waiting+bonus;
  waiting:=0;
  bonus:=0;
 End;
 seek(playerfile,planum);
 write(playerfile,playerrecd);
 close(playerfile);
End;

Procedure CHANGEPLACES;
Begin
 reset(playerfile);
 seek(playerfile,planum);
 read(playerfile,playerrecd);
 with playerrecd do
 Begin
  trn1:=realname;
  tn1:=name;
  tp2:=position;
  ts1:=score;
  tw1:=waiting;
  tb1:=bonus;
  tl1:=laston;
  tq1:=nextquestion;
 End;
 seek(playerfile,oppnum);
 read(playerfile,playerrecd);
 with playerrecd do
 Begin
  trn2:=realname;
  tn2:=name;
  tp1:=position;
  ts2:=score;
  tw2:=waiting;
  tb2:=bonus;
  tl2:=laston;
  tq2:=nextquestion;
 End;
 seek(playerfile,oppnum);
 read(playerfile,playerrecd);
 with playerrecd do
 Begin
  realname:=trn1;
  name:=tn1;
  position:=tp1;
  score:=ts1;
  waiting:=tw1;
  bonus:=tb1;
  laston:=tl1;
  nextquestion:=tq1;
 End;
 seek(playerfile,oppnum);
 write(playerfile,playerrecd);
 seek(playerfile,planum);
 read(playerfile,playerrecd);
 with playerrecd do
 Begin
  realname:=trn2;
  name:=tn2;
  position:=tp2;
  score:=ts2;
  waiting:=tw2;
  bonus:=tb2;
  laston:=tl2;
  nextquestion:=tq2;
 End;
 seek(playerfile,planum);
 write(playerfile,playerrecd);
 close(playerfile);
End;

Procedure CORRECTANSWER;
Begin
 winpla:=1;
 got1right:=true;
 PRINT('Correct answer, you have earned '+Cstr(ptsavl)+' points.');
 if (planum=2) or (planum=3) then PROMPT('You Made it to the top, strike a key to add a question')
 else if (oppnum=0) then PROMPT('You are still KING OF THE HILL, strike a key to add a question')
 else PROMPT('Please strike a key to play again!');
End;

Procedure WRONGANSWER;
Begin
 PRINT(#7#7+'WRONG ANSWER...  You can try again tomorrow.');
 PROMPT('Please strike a key to continue.');
End;

Procedure ANSICLUE;
Begin
 PROMPT('> ');
 COLOR(4);
 PROMPT(' ');
 for x:=1 to length(s) do
 Begin
  if (s[x] in ['A'..'Z']) or (s[x] in ['0'..'9']) then cc:='_' else cc:=s[x];
  PROMPT(cc);
 End;
 PROMPT(' '+#27+'['+Cstr(length(s)+1)+'D');
End;

Procedure NORMALCLUE;
(* Original Procedure By Parker Prospect #1 @9964 *)
Begin
 Prompt(#32#32);
 for x:=1 to length(s) do
 Begin
  if (s[x] in ['A'..'Z']) or (s[x] in ['0'..'9']) then cc:='*' else cc:=s[x];
  PROMPT(cc);
 End;
 NEWLINE;
 PROMPT('> ');
End;

Procedure ASKTHEQUESTION;
var answertime,nextone:byte;
Begin
 ADDPOINTS;
 answertime:=20;
 case oppnum of
  16..21 : answertime:=90;
  11..15 : answertime:=75;
   7..10 : answertime:=60;
   4..6  : answertime:=45;
   2..3  : answertime:=30;
 End;
 b1:=false;
 winpla:=0;
 NEWLINE;NEWLINE;
 reset(playerfile);
 seek(playerfile,planum);
 read(playerfile,playerrecd);
 nextone:=playerrecd.nextquestion;
 close(playerfile);
 reset(askingfile);
 repeat
  if nextone>=filesize(askingfile) then nextone:=0;
  seek(askingfile,nextone);
  nextone:=nextone+1;
  read(askingfile,askingrecd);
  with askingrecd do
  Begin
   r:=question;
   s:=answer;
   w:=right;
   z:=asked;
   if whose<>playerreal then b1:=true;
  End;
 until b1;
 close(askingfile);
 count:=nextone-1;
 reset(playerfile);
 seek(playerfile,planum);
 read(playerfile,playerrecd);
 playerrecd.nextquestion:=nextone;
 seek(playerfile,planum);
 write(playerfile,playerrecd);
 close(playerfile);
 if z>0 then xxr:=w/z*100;
 PRINT('OK here''s your question...');
 PROMPT('     It is question #'+Cstr(count+1)+',');
 if z>0 then PRINT(' with '+Cstrr(xxr,10)+'% correct response.') else
 PRINT(' this is the fist time it is being asked!');
 NEWLINE;NEWLINE;
 PRINT(r);
 NEWLINE;
 COLOR(6);
 PRINT('You have '+Cstr(answertime)+' seconds to answer!');
 if okansi then ANSICLUE else NORMALCLUE;
 INPUT(r,length(s),answertime);
 if hangup then RETURNTOBBS;
 with askingrecd do
 Begin
  asked:=asked+1;
  if r=s then right:=right+1;
 End;
 reset(askingfile);
 seek(askingfile,count);
 write(askingfile,askingrecd);
 close(askingfile);
 NEWLINE;
 if r=s then CORRECTANSWER else WRONGANSWER;
 GETKEY(cc,15,0);
End;

Procedure ADDTESTEDRECORD;
Begin
 if oppnam='' then exit;
 {$I-}reset(testedfile);{$I+}
 if ioresult<>0 then rewrite(testedfile);
 seek(testedfile,filesize(testedfile));
 with testedrecd do
 Begin
  person:=oppnam;
  winner:=winpla;
 End;
 write(testedfile,testedrecd);
 close(testedfile);
End;

Procedure GAMEWON;
Begin
 write(chr(12));
 s:='Gadzooks!!!  YOU WON THIS GAME...';
 CENTERIT(s);
 COLOR(6);
 PRINT(s);
 if playerscore>hp1 then s:='DAMN...  You even set a new all time high score!'
 else s:='Your name is now in our records until the next game win!';
 CENTERIT(s);
 COLOR(6);
 PRINT(s);
 NEWLINE;
 COLOR(1);
 s:='Strike any key to re-roll the game : ';
 CENTERIT(s);
 PROMPT(s);
 GETKEY(cc,30,0);
 UPDATEHALLWINNERS;
 SYSOPLOG(6,'King Trivia Reset ('+gametype+'), This Game Won!');
 MAKEPLAYERFILE;
 MAKETESTEDFILE;
 PLAY;
End;

Procedure ADDSCORE;
Begin
 keepon:=true;
 reset(playerfile);
 if (oppnum=0) or (winpla=0) or (planum=2) or (planum=3) then
 Begin
  keepon:=false;
  seek(playerfile,planum);
  read(playerfile,playerrecd);
  with playerrecd do laston:=0;
  seek(playerfile,planum);
  write(playerfile,playerrecd);
  close(playerfile);
 End;
 if (oppnum=0) and (winpla=0) then exit;
 if winpla=1 then x:=planum else x:=oppnum;
 reset(playerfile);
 seek(playerfile,x);
 read(playerfile,playerrecd);
 with playerrecd do
 Begin
  if x=planum then score:=score+ptsavl
  else waiting:=waiting+ptsavl;
 End;
 seek(playerfile,x);
 write(playerfile,playerrecd);
 close(playerfile);
 if (winpla=1) and (oppnum<>0) then CHANGEPLACES;
End;

Procedure SHOWFINALSCORE;
Begin
 if winpla=1 then x:=oppnum else x:=planum;
 if x=0 then x:=planum;
 reset(playerfile);
 seek(playerfile,x);
 read(playerfile,playerrecd);
 with playerrecd do
 Begin
  playerscore:=score;
  x:=position;
 End;
 if playerscore>bestscore then CHANGEHALLSCORE;
 s:='You now have '+Cstrr(playerscore,10)+' points.';
 s:=Centerstring(s,80);
 COLOR(6);
 PRINT(s);
 delay(750);
 if (playerscore>=bestscore) and (x=1) and (wintime) then GAMEWON;
 close(playerfile);
 delay(750);
End;

Procedure GETSECTION;
var
 s0,s1,s2,s3:str;
 x1,x2      :integer;
Begin
 assign(text1,filelocation+'koth-dat.txt');
 {$I-}reset(text1);{$I+}
 if ioresult<>0 then
 Begin
  rewrite(text1);
  writeln(text1,3);
  writeln(text1,'Computers');
  writeln(text1,'General');
  writeln(text1,'Music');
  close(text1);
  reset(text1);
 End;
 readln(text1,s1);
 if Value(s1)=1 then
 Begin
  if played then RETURNTOBBS;
  readln(text1,s2);
  gametype:=s2;
  game:=copy(s2,1,3);
 End
 else
 Begin
  write(chr(12));
  COLOR(1);
  s0:='Welcome to King of The Hill Trivia '+version;
  CENTERIT(s0);
  PRINT(s0);
  COLOR(1);
  s0:='by Dave Boothe of the PHONE BOOTHE BBS';
  CENTERIT(s0);
  PRINT(s0);
  COLOR(5);
  s0:='(804) 643-7537  300-2400 baud';
  CENTERIT(s0);
  PRINT(s0);
  NEWLINE;NEWLINE;
  for x1:=1 to Value(s1) do
  Begin
   if thisuser.linelen=80 then PROMPT('                                  ')
   else PROMPT('               ');
   COLOR(2);
   PROMPT(Setright(Cstr(x1),2));
   readln(text1,s2);
   COLOR(3);
   PRINT(' '+s2);
  End;
  NEWLINE;
  COLOR(2);
  if thisuser.linelen=80 then PROMPT('                                  ')
  else PROMPT('               ');
  PROMPT(' Q');
  COLOR(3);
  PRINT(' Quit');
  NEWLINE;
  NEWLINE;
  COLOR(5);
  s0:='Enter a selection: ';
  CENTERIT(s0);
  PROMPT(s0);
  COLOR(2);
  INPUT(s3,length(s1),15);
  x2:=Value(s3);
  if x2 in [1..Value(s1)] then
  Begin
   reset(text1);
   for x1:=1 to x2 do readln(text1,s1);
   readln(text1,s1);
   gametype:=s1;
   game:=copy(s1,1,3);
  End
  else
  Begin
   if (s3='') or (upcase(s3[1])='Q') then RETURNTOBBS else
   Begin
    NEWLINE;NEWLINE;
    s0:='I''m sorry, but that is an invalid choice, TRY AGAIN!';
    CENTERIT(s0);
    PROMPT(s0);
    delay(250);
    GETSECTION;
    s3:='';
   End;
  End;
 End;
 played:=true;
 close(text1);
End;

Procedure GOPLAY;
Begin
 PREPAREGAME;
 SHOWBOARD;
 if not showonly then CHECKELIGIBILITY;
 ASKIFPLAYING;
 FINDOPTIONS;
 ASKTHEQUESTION;
 ADDTESTEDRECORD;
 ADDSCORE;
 if not(keepon) then
 Begin
  if got1right then ADDQUESTIONS;
  SHOWBOARD;
  SHOWFINALSCORE;
 End;
 close(playerfile);
 close(askingfile);
 close(testedfile);
 if keepon then GOPLAY else PLAY;
End;

Procedure PLAY;
Begin
 logged:=0;
 got1right:=false;
 GETSECTION;
 GETHALLDATA;
 GOPLAY;
End;

BEGIN
 WRITE(CHR(12));
 GETCALLERDATA;
 PLAYED:=FALSE;
 PLAY;
 RETURNTOBBS;
END.
