;DDTERM.CTL
;
;This file is a "control file" for use with DDTerm. It contains various
;parameters effecting the operation and configuration of DDTerm. This file
;may be edited with any ASCII text editor. Lines beginning with a semicolon
;are treated as comments.
;
;
;PORT      The PORT parameter defines the default port that DDTerm will use
;          if no port is given on the command line.
;
PORT 1
;
;BAUD      The baud parameter defines the default baud rate that DDTerm will
;          use if no baud rate is given on the command line.
BAUD 2400
;
;
;MACRO     MACRO specifies a function key definition. With HPReader, you
;          may specify (normal,shift,ctrl,or alt) F1 - F10 as macro keys.
;          Macro keys may store any string of characters up to 254 characters
;          long. Upon pressing the specified key, DDTerm will act upon
;          the keys specified in the macro.
;
;          The format for the macro definition is as follows:
;
;                   -MACRO <keynum> <string of characters>
;
;          The key numbers are as follows:
;
;                  1-10 = F1-F10
;
;          The <string of characters> may be any string of up to 255
;          characters. It may be only one line long, but may contain any
;          control characters and/or keyboard scan codes. To specify a control
;          character, use a carat (^) sign followed by the character (i.e.
;          CTRL-M would be ^M, CTRL-A would be ^A). Scan codes may be used
;          by inserting "\0xnn" where "nn" is the hexidecimal scan code of the
;          key you wish to insert.
;
;          EXAMPLES:
;
;           MACRO 1 Scott Baker^MSysop of the Not-Yet-Named BBS^M
;                This would send out "Scott Baker" and "Sysop of the Not-
;                Yet-Named BBS" followed by carriage returns. It would be
;                invoked with F1.
;
MACRO 1 Scott Baker
;
;  ^^^ Sends my name
;
MACRO 2 Scott Baker^MAuthor of DDTerm^M
;
;  ^^^ Sends my name and "Author of..."
;
MACRO 3 u;3;16384;q;l;t;y;l^M
;
;  ^^^ Useful macro for Galactic Warzone
;
MACRO 4 l;3^M^Ml;u;3;0;q
;
;  ^^^ The flipside of the previous macro
;
;
;The following lines contain the configuration variables for DDTerm's color
;scheme. For monochrome, you should leave them all commented out unless
;you specifically want to change something. (Monochrome is defaulted within
;DDTerm). For color, you should uncomment them. A table of color definitions
;follows the configuration statements.
;
;
;     ::-------------------  Uncomment the following lines to set up colors
;     ::-------------------  for a color monitor
;     \/
;
HEADERNORMFORE 15
HEADERNORMBACK 1
HEADERHILIGHTFORE 0
HEADERHILIGHTBACK 7
MENUNORMBACK 3
MENUNORMFORE 0
MENUHILIGHTBACK 7
MENUHILIGHTFORE 0
MENUBORDERBACK 3
MENUBORDERFORE 15
FOOTERBACK 1
FOOTERFORE 15
DIALDIRBACK 3
DIALDIRFORE 0
DIALDIRBORDERBACK 3
DIALDIRBORDERFORE 15
DIALBACK 3
DIALFORE 0
DIALBORDERBACK 3
DIALBORDERFORE 15
CONBORDERBACK 3
CONBORDERFORE 15
CONBACK 3
CONFORE 0
CONHILIGHTBACK 7
CONHILIGHTFORE 0
HELPBACK 1
HELPFORE 7
HELPBORDERBACK 1
HELPBORDERFORE 15
LOGBACK 1
LOGFORE 7
LOGBORDERBACK 1
LOGBORDERFORE 15
RMBORDERBACK 3
RMBORDERFORE 15
RMBACK 3
RMFORE 0
RMHILIGHTBACK 7
RMHILIGHTFORE 0
;
;
;
;Turbo Pascal Color Codes:
;
;     Black     0        DarkGray      8
;     Blue      1        LightBlue     9
;     Green     2        LightGreen   10
;     Cyan      3        LightCyan    11
;     Red       4        LightRed     12
;     Magenta   5        LightMagenta 13
;     Brown     6        Yellow       14
;     LightGray 7        White        15
;
; (Note: Only colors 0-7 are available as background colors)
;
;Reliability parameters: The following parameters if specified will activate
;various DDTerm services. The user is allowed them to be turned on/off because
;line noise may cause severe trouble for them.
;
;ONELINE - The OneLine parameter enables DDTerm to send certain 3-byte
;          sequences as substitutes for certain character strings. Since no
;          error checking is performed for speed reasons, this option is
;          very susceptible to line noise. I default it to OFF.
;
;ONELINE
;
;
;
;Misc options
;
;SECTSCAN - This will cause the GW sector scanner to activate automatically
;           when you log into a Galactic Warzone game. The sector scanner is
;           a useful way to locate and keep track of stuff in a GW game.
;
SECTSCAN
