/* ZOOM.C -- Program to demonstrate palette animation */
/* Version 1.46 */
/* This program is Copyright (c) 1993 by Raja Thiagarajan. However, you
   may freely use it for any non-commercial purpose. You can contact me
   at sthiagar@bronze.ucs.indiana.edu */

#include <stdlib.h>      /* include atol () */

#define INCL_GPI
#define INCL_WIN
#include <os2.h>

MRESULT EXPENTRY ClientWinProc (HWND hWnd, USHORT msg, MPARAM mp1, MPARAM mp2);

static LONG hasPalMan;      /* Whether the Palette Manager is available */
static LONG shadesToShow;   /* How many squares to draw */

#define MAX_SHADES 16
static ULONG tbl[MAX_SHADES];  /* Table of RGB values */

static HAB hab;                /* This program's hab ... */
static HDC hdc;                /* ... hdc ... */
static HPS hps;                /* ... and hps. Note that we do NOT use
                                  a cached micro-ps! */
static HPAL hpal;              /* Handle to the palette we'll use */

INT main (INT argc, CHAR * argv [])
{
   HMQ   hmq;         /* The usual bunch of variables for PM programs */
   QMSG  qmsg;
   HWND  hwnd,
         hwndClient;

   ULONG createFlags  =  FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER
                                      | FCF_MINMAX | FCF_SHELLPOSITION
                                      |  FCF_TASKLIST;

#define clientClass "zoom"

   {
      LONG sColors; /* How many colors are available */
      HPS hpsScr;   /* These temporary vars are */
      HDC hdcScr;   /*   used to query the screen driver */
      hpsScr = WinGetPS (HWND_DESKTOP);
      hdcScr = GpiQueryDevice (hpsScr);
      DevQueryCaps (hdcScr, CAPS_COLORS, 1L, &sColors);
      DevQueryCaps (hdcScr, CAPS_ADDITIONAL_GRAPHICS, 1, &hasPalMan);
      hasPalMan &= CAPS_PALETTE_MANAGER;
      shadesToShow = sColors;
#define MAX_SHADES 16
      if (shadesToShow > MAX_SHADES)
        shadesToShow = MAX_SHADES;
   }

   hab = WinInitialize (0);  /* initialize PM usage */

   if (hasPalMan) {
/* Use 65536 for Red, 256 for Green, 1 for Blue */
#define WHITE 65793 /* White = Red + Green + Blue */
      ULONG  primary = WHITE;
      INT    j;
      if (argc > 1) {
         primary = atol (argv [1]);
         if ((primary < 1) || (primary > WHITE)) {
            primary = WHITE;
         }
      }

      for (j = 0; j < shadesToShow; j++) {
         tbl [j] = PC_RESERVED * 16777216 + primary * j * (256 / MAX_SHADES);
      }
      hpal = GpiCreatePalette (hab, 0L, LCOLF_CONSECRGB, shadesToShow, tbl);
   }

   hmq = WinCreateMsgQueue (hab, 0);   /* create message queue */

   WinRegisterClass (hab, clientClass, (PFNWP) ClientWinProc, CS_SIZEREDRAW, 0);

      /* Create standard window and client */
      hwnd = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE, &createFlags,
                                 clientClass, "Zoom In", 0L,
                                 0UL, 0, &hwndClient);
   if (!hasPalMan) {
      /* If there isn't a palette manager, give up now */
      WinMessageBox (HWND_DESKTOP, hwndClient,
                     "ZOOM cannot run without palette manager",
                     "ZOOM: FATAL ERROR", 0, MB_OK | MB_ERROR);
   } else {

#define TIMER_ID 1

      if (!WinStartTimer (hab, hwndClient, TIMER_ID, 100L)) {
         WinMessageBox (HWND_DESKTOP, hwndClient,
                        "ZOOM cannot allocate a timer. Please free a timer and try again",
                        "ZOOM: FATAL ERROR", 0, MB_OK | MB_ERROR);
      } else {
         while (WinGetMsg (hab, &qmsg, NULLHANDLE, 0, 0)) /* msg dispatch loop */
            WinDispatchMsg (hab, &qmsg);

         WinStopTimer (hab, hwndClient, TIMER_ID);

         GpiDeletePalette (hpal);
      }
   }

   WinDestroyWindow (hwnd);           /* destroy frame window */
   WinDestroyMsgQueue (hmq);          /* destroy message queue */
   WinTerminate (hab);                /* terminate PM usage */

   return 0;
}

MRESULT EXPENTRY ClientWinProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
   static USHORT  cWid, cHi;
   static BOOL    firstPaint = TRUE; /* Whether this is the first response
                                        to WM_PAINT */
     
   switch (msg)
      {
         case WM_CREATE:
            {
               SIZEL sizl;
               sizl.cx = sizl.cy = 0;
               hdc = WinOpenWindowDC (hwnd);
               hps = GpiCreatePS (hab, hdc, &sizl, PU_PELS | GPIF_DEFAULT
                        | GPIT_MICRO | GPIA_ASSOC);
               GpiSelectPalette (hps, hpal);
            }
            return (MRESULT) FALSE;
         case WM_DESTROY:
            GpiSelectPalette (hps, NULLHANDLE);
            GpiDestroyPS (hps);
            return (MRESULT) FALSE;
         case WM_TIMER:
            {
               INT j;
               ULONG tmp = tbl [0];
               for (j = 0; j < (shadesToShow - 1); j++) {
                  tbl [j] = tbl [j + 1];
               }
               tbl [shadesToShow - 1] = tmp;
               GpiAnimatePalette (hpal, LCOLF_CONSECRGB, 0, shadesToShow, tbl);
               {
                  ULONG palSize = shadesToShow;
                  WinRealizePalette (hwnd, hps, &palSize);
               }
            }
            return (MRESULT) FALSE;
         case WM_ERASEBACKGROUND:
            return (MRESULT) TRUE;
         case WM_REALIZEPALETTE:
            {
               ULONG palSize = shadesToShow;
               if (WinRealizePalette (hwnd, hps, &palSize)) {
                  WinInvalidateRect (hwnd, NULL, FALSE);
               }
            }
            return (MRESULT) FALSE;
         case WM_PAINT:
            {
               POINTL ptl, p2;
               LONG   j;

               WinBeginPaint (hwnd, hps, NULL);
               if (hasPalMan) {
                  if (firstPaint) {
                     ULONG palSize = shadesToShow;
                     WinRealizePalette (hwnd, hps, &palSize);
                     firstPaint = FALSE;
                  }
                  ptl.x = ptl.y = 0;
                  p2.x = cWid;
                  p2.y = cHi;
                  for (j = 0; j < shadesToShow; j++) {
                     GpiSetColor (hps, j);
                     GpiMove (hps, &ptl);
                     GpiBox (hps, DRO_FILL, &p2, 0L, 0L);
                     ptl.x += cWid / shadesToShow / 2;
                     ptl.y += cHi / shadesToShow / 2;
                     p2.x -= cWid / shadesToShow / 2;
                     p2.y -= cHi / shadesToShow / 2;
                  }
               }
               WinEndPaint (hps);
               return (MRESULT) FALSE;
            }
         case WM_SIZE:
            cWid = SHORT1FROMMP (mp2);
            cHi = SHORT2FROMMP (mp2);
            return (MRESULT) FALSE;
         default:
            return (WinDefWindowProc (hwnd, msg, mp1, mp2));
            break;
      }  /*end switch*/
   return (MRESULT) FALSE;
}
