/* PHYSCOLO.C -- Program to display the physical screen colors */
/* Version 1.93 */
/* This program is Copyright (c) 1993 by Raja Thiagarajan. However, you
   may freely use it for any non-commercial purpose. You can contact me
   at sthiagar@bronze.ucs.indiana.edu */
/* Thanks to Peter Nielsen (pnielsen@finabo.abo.fi) for his help and
   clever ideas */

#define INCL_GPI
#define INCL_WIN
#include <os2.h>

MRESULT EXPENTRY ClientWinProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);

static LONG hasPalMan;      /* Whether the Palette Manager is available */
static LONG colorsToShow;   /* How many colored rectangles to draw */

static HAB  hab;            /* This program's hab*/

INT main (VOID)
{
   HMQ   hmq;         /* The usual bunch of variables for PM programs */
   QMSG  qmsg;
   HWND  hwnd,
         hwndClient;

   ULONG createFlags  =  FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER
                                      | FCF_MINMAX | FCF_SHELLPOSITION
                                      | FCF_TASKLIST;

#define clientClass "physColo"

   {
      LONG sColors; /* How many colors are available */
      HDC hdcScr;   /* Used to query the screen driver */
      hdcScr = GpiQueryDevice (WinGetPS (HWND_DESKTOP));
      DevQueryCaps (hdcScr, CAPS_ADDITIONAL_GRAPHICS, 1, &hasPalMan);
      hasPalMan &= CAPS_PALETTE_MANAGER;
      DevQueryCaps (hdcScr, CAPS_COLORS, 1L, &sColors);
      colorsToShow = sColors;
   }
#define MAX_PAL_SIZE 256
   /* To save time, only draw the first 256 colors if there are more */
   if (colorsToShow > MAX_PAL_SIZE)
     colorsToShow = MAX_PAL_SIZE;

   hab = WinInitialize (0);  /* initialize PM usage */

   hmq = WinCreateMsgQueue (hab, 0);   /* create message queue */

   WinRegisterClass (hab, clientClass, (PFNWP) ClientWinProc,
                     CS_SIZEREDRAW, 0);

      /* Create standard window and client. Note that the title message
         depends on whether the Palette Manager is available or not */
   if (hasPalMan) {
      hwnd = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE, &createFlags,
                                 clientClass, "Physical Color Viewer", 0L,
                                 0UL, 0, &hwndClient);
   } else {
      hwnd = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE, &createFlags,
                                 clientClass, "Color Viewer", 0L, 0UL, 0,
                                 &hwndClient);
   }

   while (WinGetMsg (hab, &qmsg, NULLHANDLE, 0, 0)) /* msg dispatch loop */
      WinDispatchMsg (hab, &qmsg);

   WinDestroyWindow (hwnd);           /* destroy frame window */
   WinDestroyMsgQueue (hmq);          /* destroy message queue */
   WinTerminate (hab);                /* terminate PM usage */

   return 0;
}

MRESULT EXPENTRY ClientWinProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
   static HPS    hps;
   static HDC    hdc;
   static HPAL   hpal;
   static USHORT cWid, cHi; /* client area width and height */
   static BOOL   firstPaint = TRUE; /* Whether this is the first response
                                       to WM_PAINT */
   switch (msg)
      {
         case WM_CREATE:
            {
               SIZEL sizl;
               ULONG tbl [MAX_PAL_SIZE];
               INT   j;
               sizl.cx = sizl.cy = 0;
               hdc = WinOpenWindowDC (hwnd);
               hps = GpiCreatePS (hab, hdc, &sizl, PU_PELS | GPIF_DEFAULT
                        | GPIT_MICRO | GPIA_ASSOC);
               if (hasPalMan) {
                  /* Create the palette. Since we use PC_EXPLICIT, table
                     entries are interpreted as palette register numbers,
                     rather than RGB values */
                  ULONG tbl [MAX_PAL_SIZE];
                  INT   j;
                  for (j = 0; j < colorsToShow; j++) {
                     tbl [j] = PC_EXPLICIT * 16777216 + j;
                  }
                  hpal = GpiCreatePalette (hab, 0L, LCOLF_CONSECRGB,
                                           colorsToShow, tbl);
                  GpiSelectPalette (hps, hpal);
               }
            }
            return (MRESULT) FALSE;
         case WM_DESTROY:
            if (hasPalMan) {
               GpiSelectPalette (hps, NULLHANDLE);
               GpiDeletePalette (hpal);
            }
            /* We cannot destroy hdc; see the PM docs */
            GpiDestroyPS (hps);
            return (MRESULT) FALSE;
         case WM_ERASEBACKGROUND:
            return (MRESULT) TRUE;
         case WM_REALIZEPALETTE:
            {
               ULONG palSize = colorsToShow;
               WinRealizePalette (hwnd, hps, &palSize);
/* Note: For most uses of the palette manager, replace the
         "WinRealize..." line above with the following
         if statement:
                  if (WinRealizePalette (hwnd, hps, &palSize)) {
                     WinInvalidateRect (hwnd, NULL, FALSE);
                  }
*/
            }
            return (MRESULT) FALSE;
         case WM_PAINT:
            {
               POINTL ptl;
               LONG   j;

               WinBeginPaint (hwnd, hps, NULL);
               if (hasPalMan && firstPaint) {
                  /* Realize the palette when you paint for the first time.
                     This is necessary in case the program doesn't start
                     in the foreground. */
                  ULONG palSize = colorsToShow;
                  WinRealizePalette (hwnd, hps, &palSize);
                  firstPaint = FALSE;
               }
               for (j = 0; j < colorsToShow; j++) {
                  GpiSetColor (hps, j);
                  ptl.y = 0;
                  ptl.x = j * cWid / colorsToShow;
                  GpiMove (hps, &ptl);
                  ptl.y = cHi;
                  ptl.x += cWid / colorsToShow;
                  GpiBox (hps, DRO_FILL, &ptl, 0L, 0L);
               }
               WinEndPaint (hps);
            }
            return (MRESULT) FALSE;
         case WM_SIZE:
            cWid = SHORT1FROMMP (mp2);
            cHi = SHORT2FROMMP (mp2);
            return (MRESULT) FALSE;
         default:
            return (WinDefWindowProc (hwnd, msg, mp1, mp2));
      }  /*end switch*/
   return (MRESULT) FALSE;
}
