/* GRAYBITM.C -- Program to draw a grayscale bitmap using Palette Manager
                 and then display it via WinDrawBitmap. */
/* Version 0.9*/
/* This program is Copyright (c) 1993 by Raja Thiagarajan. However, you
   may freely use it for any non-commercial purpose. You can contact me
   at sthiagar@bronze.ucs.indiana.edu */

#define INCL_DOS /* include DosBeep */
#define INCL_GPI
#define INCL_WIN
#include <os2.h>

#define TITLE "GRAYBITM"

/* Function prototypes */
MRESULT EXPENTRY ClientWinProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);
HBITMAP CreateBitmap (HAB hab);
VOID SizeTheWindow (HWND hwnd);

static HAB hab;   /* the handle to the program's anchor block */

static HBITMAP hBitmap;    /* the bitmap itself */
static LONG    hasPalMan;  /* Whether the Palette Manager is available */
static HPAL    hpal;       /*Grayscale palette*/

#define clientClass "GRAYBITM class"

INT main (VOID)
{
   HMQ   hmq;     /* handle for message queue */
   QMSG  qmsg;    /* message queue element */
   HWND  hwnd;    /* handle to frame window */

   ULONG createFlags  =  FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER
                            | FCF_MINMAX | FCF_SHELLPOSITION | FCF_TASKLIST;

   HWND  hwndClient;    /* handle for client window */

   {
      HDC hdcScr;   /* This is used to query the screen driver */
      hdcScr = GpiQueryDevice (WinGetPS (HWND_DESKTOP));
      DevQueryCaps (hdcScr, CAPS_ADDITIONAL_GRAPHICS, 1, &hasPalMan);
      hasPalMan &= CAPS_PALETTE_MANAGER;
   }

   hab = WinInitialize (0);  /* initialize PM usage */

   if (hasPalMan) {
#define SHADES 8
/* The magic number below, 65793, is 65536 + 256 + 1. Use 65536 for red,
   256 for green, and 1 for blue [or add them together to combine colors] */
      ULONG  tbl [SHADES];
      INT    j;
      for (j = 0; j < SHADES; j++) {
         tbl [j] = 65793 * j * 256 / SHADES;
      }
      hpal = GpiCreatePalette (hab, 0L, LCOLF_CONSECRGB, SHADES, tbl);
   } else {
      DosBeep (440, 1000L); /* Beep for 1 sec if palette manager is
                               NOT available */
   }

   hmq = WinCreateMsgQueue (hab, 0);   /* create message queue */

   WinRegisterClass (hab, clientClass, (PFNWP)ClientWinProc, CS_SIZEREDRAW, 0);

      /* create standard window and client */
   hwnd = WinCreateStdWindow (HWND_DESKTOP,
                              0 /*WS_VISIBLE*/,
                              &createFlags,
                              clientClass,
                              TITLE,
                              0L,
                              0UL,
                              0,
                              &hwndClient);

   SizeTheWindow (hwnd);

   hBitmap = CreateBitmap (hab);

   while (WinGetMsg (hab, &qmsg, NULLHANDLE, 0, 0)) {
     WinDispatchMsg (hab, &qmsg);
   } /* endwhile */

   WinDestroyWindow (hwnd);     /* destroy frame window */
   WinDestroyMsgQueue (hmq);    /* destroy message queue */
   WinTerminate (hab);          /* terminate PM usage */

   return 0;
}

#define BMAPWIDTH       40
#define BMAPHEIGHT      60

VOID SizeTheWindow (HWND hwnd)
{
   RECTL rcl = {0, 0, BMAPWIDTH, BMAPHEIGHT};

   WinCalcFrameRect (hwnd, &rcl, FALSE);

   WinSetWindowPos (hwnd, NULLHANDLE, 0, 0, (rcl.xRight - rcl.xLeft),
         (rcl.yTop - rcl.yBottom), SWP_SHOW | SWP_SIZE);
}

HBITMAP CreateBitmap (HAB hab)
{
   BITMAPINFOHEADER2    bmpInfoHdr;
   SIZEL                sizl;
   POINTL               ptl;
   HDC                  hdcMem;
   HBITMAP              hbm;
   HPS                  hpsMem;

   bmpInfoHdr.cbFix = sizeof (bmpInfoHdr.cbFix) + sizeof (bmpInfoHdr.cx)
        + sizeof (bmpInfoHdr.cy) + sizeof (bmpInfoHdr.cPlanes)
        + sizeof (bmpInfoHdr.cBitCount);
   bmpInfoHdr.cx = BMAPWIDTH;
   bmpInfoHdr.cy = BMAPHEIGHT;

   hdcMem = DevOpenDC (hab, OD_MEMORY, "*", 0L, NULL, NULLHANDLE);
   /* Query the driver for the number of planes and bits. This will allow
      the program to run on *any* display that OS/2 supports. Thanks to
      Larry Salomon for teaching me this trick. */
   {
      LONG lVal;
      DevQueryCaps (hdcMem, CAPS_COLOR_PLANES, 1, &lVal);
      bmpInfoHdr.cPlanes = lVal;
      DevQueryCaps (hdcMem, CAPS_COLOR_BITCOUNT, 1, &lVal);
      bmpInfoHdr.cBitCount = lVal;
   }

   sizl.cx = sizl.cy = 0L;
   hpsMem = GpiCreatePS (hab, hdcMem, &sizl, PU_PELS | GPIF_DEFAULT
		      | GPIT_MICRO | GPIA_ASSOC);
   GpiSelectPalette (hpsMem, hpal);

   hbm = GpiCreateBitmap (hpsMem, &bmpInfoHdr, 0L, NULL, NULL);
   GpiSetBitmap (hpsMem, hbm);

   GpiErase (hpsMem);

   GpiSetColor (hpsMem, 3);	/* dark gray */

   ptl.x = ptl.y = 5;
   GpiMove (hpsMem, &ptl);
   ptl.x += 5;
   ptl.y += 50;
   GpiBox (hpsMem, DRO_OUTLINEFILL, &ptl, 0L, 0L); /* draw rectangle */

   ptl.x += 5;
   GpiMove (hpsMem, &ptl);
   GpiSetColor (hpsMem, 4); /* Gray */
   ptl.x += 15;
   ptl.y -= 15;
   GpiBox (hpsMem, DRO_OUTLINEFILL, &ptl, 15L, 15L); /* draw circle */

   GpiSetColor (hpsMem, 6);   /* light gray */
   GpiBeginArea (hpsMem, 0);
   ptl.x -= 15;
   ptl.y -= 35;
   GpiMove (hpsMem, &ptl);
   ptl.x += 10;
   ptl.y += 14;
   GpiLine (hpsMem, &ptl);
   ptl.x += 10;
   ptl.y -= 14;
   GpiLine (hpsMem, &ptl);
   GpiEndArea (hpsMem);       /* draw triangle */

   GpiSetBitmap (hpsMem, NULLHANDLE);
   GpiDestroyPS (hpsMem);
   DevCloseDC (hdcMem);

   return (hbm);
}

MRESULT EXPENTRY ClientWinProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
   static HPS  hps;
   static HDC  hdc;
   static BOOL firstPaint = TRUE;

   switch (msg) {
      case WM_CREATE:
         {
            SIZEL sizl = {0L, 0L};
            hdc = WinOpenWindowDC (hwnd);
            hps = GpiCreatePS (hab, hdc, &sizl, PU_PELS | GPIF_DEFAULT
                     | GPIT_MICRO | GPIA_ASSOC);
            GpiSelectPalette (hps, hpal);
         }
         return (MRESULT) FALSE;
      case WM_DESTROY:
         GpiSelectPalette (hps, NULLHANDLE);
         GpiDeletePalette (hpal);
         GpiDestroyPS (hps);
         return (MRESULT) FALSE;
      case WM_REALIZEPALETTE:
         {
            ULONG palSize = SHADES;
            if (hasPalMan) {
               if (WinRealizePalette (hwnd, hps, &palSize)) {
                  WinInvalidateRect (hwnd, NULL, FALSE);
               }
            }
         }
         return (MRESULT) FALSE;
      case WM_PAINT:
         {
            RECTL rcl;
            LONG  rWid, rHi; /* rectangle width and height */
            WinBeginPaint (hwnd, hps, NULL);
            if (firstPaint) {
               ULONG palSize = SHADES;
               WinRealizePalette (hwnd, hps, &palSize);
               firstPaint = FALSE;
            }
            WinQueryWindowRect (hwnd, &rcl);
            rWid = rcl.xRight;
            rHi = rcl.yTop;
            if (rHi < (rWid * BMAPHEIGHT / BMAPWIDTH)) {
               rcl.xRight = rHi * BMAPWIDTH / BMAPHEIGHT;
            } else {
               rcl.yTop = rWid * BMAPHEIGHT / BMAPWIDTH;
            }
            WinDrawBitmap (hps, hBitmap, NULL, (PPOINTL) &rcl, 0, 0,
                           DBM_NORMAL | DBM_STRETCH);
            WinEndPaint (hps);
         }
         return (MRESULT) FALSE;
      case WM_ERASEBACKGROUND:
         return (MRESULT) TRUE;
      default: 
         return WinDefWindowProc (hwnd, msg, mp1, mp2);
   } /* endswitch */
}
