/**************************************************/
/* Prince of Persia 2 save game editor - by Patch */
/* April 27, 1993   11:55pm PST                   */
/*                                                */
/* Rape this source code all you want ... it's    */
/* nothing special.  Plain Jane C stuff.          */
/**************************************************/

#include <stdio.h>
#include <conio.h>

#undef          DEBUG
#define         clrscr          printf("%c[2J",27);
#define         ESC             27

FILE *fp;
int index, count = 0;
unsigned char descrip[25][10], minutes[10], scene[10], health[10], ch;
int temp;

void Read_Data(void)
{
    fp = fopen("prince.sav","rb");
    if (fp == NULL)
    {
      fprintf(stderr,"Prince of Persia 2 save game editor\n");
      fprintf(stderr,"            by Patch               \n\n");
      fprintf(stderr,"Could not find file PRINCE.SAV!\n");
      exit(-1);
    }

    /* read in the save game descriptions */
    fseek(fp,2,0);
    while (fread(descrip[count],1,25,fp) && *descrip[count] != 0)
    {
	#ifdef DEBUG
	printf("Descrip = [%s]\n",descrip[count]);
	#endif

	/* increment save game count */
	count++;
    }

    /* error checking, just in case */
    if (count == 0)
    {
	fprintf(stderr,"No save games present in PRINCE.SAV!\n");
	exit(-2);
    }

    /* set file pointer to start of save game data */
    fseek(fp,256,0);

    /* read in the save game data (scene and health) */
    for (index = 0; index < count; index++)
    {
	minutes[index] = fgetc(fp);
	fseek(fp,3,1);
	scene[index] = fgetc(fp);
	health[index] = fgetc(fp);

	#ifdef DEBUG
	printf("minutes = [%3d]\tScene = [%2d]\tHealth = [%2d]\n",
	       minutes[index],scene[index], health[index]);
	#endif

	fseek(fp,9617,1);
    }
    fclose(fp);
}

void Save_Data(void)
{
    printf("Saving data ...\n");

    fp = fopen("prince.sav","r+b");
    /* set file point to start of descriptions */
    fseek(fp,2,0);
    /* first save descriptions */
    for (index = 0; index < count; index++)
	fwrite(descrip[index],1,25,fp);

    /* set file pointer to start of save game data */
    fseek(fp,256,0);

    /* write the save game data (scene and health) */
    for (index = 0; index < count; index++)
    {
	fprintf(fp,"%c",minutes[index]);
	fseek(fp,3,1);
	fprintf(fp,"%c",scene[index]);
	fprintf(fp,"%c",health[index]);
	fseek(fp,9617,1);
    }

    fclose(fp);
}

void Print_Data(void)
{
    printf("Prince of Persia 2 save game editor - by Patch\n\n");
    printf("Esc  quit (no save)\n");
    printf("S   - save changes\n\n");
    for (index = 0; index < count; index++)
    {
	printf("Description #%d: %-25s  Minutes: %3d  Scene: %2d  Health: %2d\n",
	       index, descrip[index], minutes[index],
	       scene[index], health[index]);
    }
}

void Get_Key(void)
{
    /* wait for a keystroke of 0-9, or Esc */
    do
    {
	ch = getch();
	if (ch == 's') ch = 'S';
	/* if extended keystroke, get next key and set ch to 0 */
	if (ch == 0)
	{
	    getch();
	    ch = 0;
	}
    }
    while ((ch < '0' || ch > count + 48 - 1) && ch != ESC && ch != 'S');
}

void main(void)
{
    clrscr;
    Read_Data();
    do
    {
	clrscr;
	Print_Data();
	printf("\nSave game to edit: ");
	Get_Key();

	#ifdef DEBUG
	printf("[%d]\n",ch);
	#endif

	switch (ch)
	{
	    case 'S':Save_Data();
		     break;
	    case ESC:break;
	    default :printf("\n");
		     printf("Enter new description: ");
		     scanf("%s",descrip[ch - 48]);
		     printf("Enter new minutes    : ");
		     scanf("%d",&temp);
		     minutes[ch - 48] = temp;
		     printf("Enter new scene      : ");
		     scanf("%d",&temp);
		     scene[ch - 48] = temp;
		     printf("Enter new health     : ");
		     scanf("%d",&temp);
		     health[ch - 48] = temp;
		     break;

	    #ifdef DEBUG
	    printf("new descrip: [%s]\tnew scene: [%d]\tnew health: [%d]\n",
		    descrip[ch - 48], scene[ch - 48], health[ch - 48]);
	    #endif
	}
    }
    while (ch != ESC);

    clrscr;
    printf("Call Dead Man's Hand - 503.288.9264 - USR 16.8k DS - Grafx/sound programming\n");
}
