//
// xvgopher.h
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Header for the xvgopher gopher client
//
#ifndef	_xvgopher_h_
#define	_xvgopher_h_

//
// Configurable defines
//

//
// GOPHER_SERVER is a string describing the initial gopher server to
// contact.  If you have a say in local nameserver administration, it
// would be wise to create an alias 'gopher' for the machine the gopher
// server runs on.  This way none of the client configurations will have
// to change if the server is moved to a different machine.  Only the
// nameserver alias needs to be changed to reflect the new server.
//
#define	GOPHER_SERVER	"gopher"

//
// External programs used by xvgopher.  All of these are just defaults and can be
// changed by the user.
//
#define	DEFAULT_TELNET			"xterm -T \"%s\" -e telnet %s %d &"
#define	DEFAULT_IMAGER			"xv"
#define	DEFAULT_PLAYER			"play"
#define	DEFAULT_MAILER			"/usr/ucb/Mail"
#define	DEFAULT_PRINT_FILTER	"lpr"


//
// DO NOT CHANGE ANYTHING BELOW THIS LINE
//

//
// The following define the different types of items which are known
// to gopher
//
#define	GOPHER_FILE			'0'	// Item is a file  
#define	GOPHER_DIRECTORY	'1'	// Item is a directory  
#define	GOPHER_CSO			'2'	// Item is a CSO (qi) phone-book server  
#define	GOPHER_ERROR		'3'	// Error   
#define	GOPHER_BINHEX		'4'	// Item is a BinHexed Macintosh file. Use of this type is discouraged 
#define	GOPHER_DOS			'5'	// Item is DOS binary archive of some sort. Use of this type is discouraged 
#define	GOPHER_UU			'6'	// Item is a UNIX uuencoded file. Use of this type is discouraged 
#define	GOPHER_INDEX		'7'	// Item is an Index-Search server.  
#define	GOPHER_TELNET		'8'	// Item points to a text-based telnet session. 
#define	GOPHER_BIN			'9'	// Item is a binary file! Client must read until the connection closes. Beware.
#define	GOPHER_REDUNDANT	'+'	// Item is a redundant server (same information as the previous server) 
#define	GOPHER_SOUND		's'	// Item is a sound file
#define	GOPHER_IMAGE		'I'	// Item is an image file
#define	GOPHER_GIF			'g'	// Item is a GIF file
#define	GOPHER_SPECIAL		31	// Item is a special directory (index)

#ifndef	TRUE
# define	TRUE		(1)
#endif

#ifndef	FALSE
# define	FALSE		(0)
#endif

#define	OK				0
#define	NOTOK			(-1)

typedef	unsigned long	dword;
typedef	unsigned short	word;
typedef	unsigned char	byte;

//
// These keys are used to attach data to xview items
//
#define	KEY_FRAME		11001
#define	KEY_GWINDOW		11002
#define	KEY_GOPHER		11003

//
// Version number.  This is nicely tucked away so people don't go changing it without
// any real reasons.
//
#define	VERSION			"0.5beta"

#include "Preferences.h"

extern Preferences	preferences;

#endif	_xvgopher_h_
