//
// main.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Main program for xvgopher
//
#include "xvgopher.h"
#include "GWindow.h"
#include "Preferences.h"
#include <xview/xview.h>


Preferences	preferences;

static int error_proc()
{
	abort();
	return XV_OK;
}


//***************************************************************************
// main(int ac, char **av)
//
main(int ac, char **av)
{
	char		*server = GOPHER_SERVER;
	char		*port = "70";

	xv_init(XV_INIT_ARGC_PTR_ARGV,		&ac, av,
		XV_ERROR_PROC,			error_proc,
		NULL);

	switch (ac)
	{
		case 2:	// A machine was specified
			server = av[1];
			break;
		case 3:	// A machine and port were specified
			server = av[1];
			port = av[2];
			break;
	}

	Response	*r = new Response("1");
	r->set_server(server);
	r->set_port(port);
	GWindow	*main_window = CreateWindow(r);

	if (main_window)
		main_window->main_loop();

	return 0;
}
