//
// icons.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// This file defines all the glyphs used in the xvgopher program
//
#include <xview/xview.h>
#include <xview/svrimage.h>
#include "icons.h"

static unsigned short bin_bits[] = {
#include "icons/bin"
};
static unsigned short cso_bits[] = {
#include "icons/cso"
};
static unsigned short dir_bits[] = {
#include "icons/dir"
};
static unsigned short doc_bits[] = {
#include "icons/doc"
};
static unsigned short dos_bits[] = {
#include "icons/dos"
};
static unsigned short error_bits[] = {
#include "icons/error"
};
static unsigned short idx_bits[] = {
#include "icons/idx"
};
static unsigned short mac_bits[] = {
#include "icons/mac"
};
static unsigned short tel_bits[] = {
#include "icons/tel"
};
static unsigned short unknown_bits[] = {
#include "icons/unknown"
};
static unsigned short uu_bits[] = {
#include "icons/uu"
};
static unsigned short sound_bits[] = {
#include "icons/sound"
};
static unsigned short image_bits[] = {
#include "icons/image"
};
static unsigned short info_bits[] = {
#include "icons/info"
};
static unsigned short info_dragging_bits[] = {
#include "icons/info_dragging"
};


struct
{
	unsigned char	type;
	Server_image	image;
	unsigned short	*bits;
} icons[] =
{
	{'.', NULL, unknown_bits},
	{'0', NULL, doc_bits},
	{'1', NULL, dir_bits},
	{'2', NULL, cso_bits},
	{'3', NULL, error_bits},
	{'4', NULL, mac_bits},
	{'5', NULL, dos_bits},
	{'6', NULL, uu_bits},
	{'7', NULL, idx_bits},
	{'8', NULL, tel_bits},
	{'9', NULL, bin_bits},
	{'s', NULL, sound_bits},
	{'I', NULL, image_bits},
	{'g', NULL, image_bits},

	//
	// The following are images used by other parts of xvgopher.  They are
	// identified by characters with the high bit set.
	//
	{'i' | 0x80, NULL, info_bits},
	{'d' | 0x80, NULL, info_dragging_bits},
	{'\0', NULL, NULL}
};


//***************************************************************************
// void icon_init()
//
void icon_init()
{
	static int	had_init = FALSE;
	if (had_init)
		return;
	had_init = TRUE;

	for (int i = 0; icons[i].type; i++)
	{
		icons[i].image = (Server_image) xv_create(NULL, SERVER_IMAGE,
			XV_WIDTH,					16,
			XV_HEIGHT,					16,
			SERVER_IMAGE_BITS,			icons[i].bits,
			NULL);
	}
}


//***************************************************************************
// Server_image get_image(char type)
//
Server_image get_image(char type)
{
	icon_init();

	//
	// Search through the list of icons to find the right one...
	//
	for (int i = 0; icons[i].type; i++)
	{
		if (icons[i].type == (unsigned char) type)
			return icons[i].image;
	}

	//
	// Nothing found.  Return the unknown icons
	//
	return icons[0].image;
}

