//
// String.h
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// This class defines a string as an object derived from Object.
//
#ifndef	_String_h_
#define	_String_h_

#include "Object.h"
#include "string.h"

class String : public  Object
{
public:
	//
	// Constructors/Destructor
	//
							String();
							String(char *str);
							String(String &s);
							~String();

	//
	// Access to the string
	//
	char					*get();
	void					set(char *str);

private:
	//
	// A place to store our string
	//
	char					*string;
};


//***************************************************************************
// String::String()
//
inline String::String()
{
	string = (char *) 0;
}


//***************************************************************************
// inline String::String(char *str)
//
inline String::String(char *str)
{
	string = strdup(str);
}


//***************************************************************************
// String::~String()
//
inline String::~String()
{
	if (string)
		delete string;
	string = (char *) 0;
}


//***************************************************************************
// inline String::String(String &s)
//
inline String::String(String &s)
{
	string = strdup(s.string);
}


//***************************************************************************
// inline char *String::get()
//
inline char *String::get()
{
	return string;
}


//***************************************************************************
// inline void String::set(char *str)
//
inline void String::set(char *str)
{
	string = strdup(str);
}


#endif	_String_h_
