//
// Response.h
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// This class keeps track of responses from a gopher server.
// It can be interrogated to get part or all of the response.
//
#ifndef	_Response_h_
#define	_Response_h_

#include <stdio.h>

#define	MAX_WORDS			20


class Response
{
public:
	//
	// Constructor/Destructor
	//
							Response();
							Response(char *str);
							Response(Response *r);
							~Response();

	//
	// Data access
	//
	int						set(char *str);

	char					*get_server();
	int						get_port();
	char					*get_command();
	char					*get_title();
	char					get_type();
	char					*get_nth(int n);

	void					set_server(char *str);
	void					set_port(int port);
	void					set_port(char *port);
	void					set_command(char *str);
	void					set_type(char c);
	void					set_nth(int n, char *str);
	void					set_nth(int n, int x);
private:
	//
	// Internally we will split the original into words.  The words are seperated with TABs
	//
	char					type;
	char					*words[MAX_WORDS];
	int						wordcount;
};


//***************************************************************************
// void Response::set_server(char *str)
//
inline void Response::set_server(char *str)
{
	set_nth(2, str);
}


//***************************************************************************
// void Response::set_command(char *str)
//
inline void Response::set_command(char *str)
{
	set_nth(1, str);
}


//***************************************************************************
// void Response::set_port(int port)
//
inline void Response::set_port(int port)
{
	set_nth(3, port);
}


//***************************************************************************
// void Response::set_port(char *port)
//
inline void Response::set_port(char *port)
{
	set_nth(3, port);
}


//***************************************************************************
// void Response::set_type(char ch)
//
inline void Response::set_type(char ch)
{
	type = ch;
}


//***************************************************************************
// char *Response::get_server()
//
inline char *Response::get_server()
{
	return get_nth(2);
}


//***************************************************************************
// char *Response::get_title()
//
inline char *Response::get_title()
{
	return get_nth(0);
}


//***************************************************************************
// char *Response::get_command()
//
inline char *Response::get_command()
{
	return get_nth(1);
}


#include <stdlib.h>
//***************************************************************************
// int Response::get_port()
//
inline int Response::get_port()
{
	return atoi(get_nth(3));
}


//***************************************************************************
// char Response::get_type()
//
inline char Response::get_type()
{
	return type;
}


#endif	_Response_h_
