//
// Response.cc
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// Implementation of the Response class
//
#include "Response.h"
#include <string.h>
#include <stdio.h>


//***************************************************************************
// Response::Response()
//
Response::Response()
{
	words[0] = NULL;
	wordcount = 0;
}


//***************************************************************************
// Response::Response(Response *r)
//
Response::Response(Response *r)
{
	for (wordcount = 0; wordcount < r->wordcount; wordcount++)
		words[wordcount] = strdup(r->words[wordcount]);
	type = r->type;
}


//***************************************************************************
// Response::Response(char *str)
//
Response::Response(char *str)
{
	words[0] = NULL;
	wordcount = 0;

	set(str);
}


//***************************************************************************
// Response::~Response()
//
Response::~Response()
{
	for (int i = 0; i < wordcount; i++)
		if (words[i])
			delete words[i];
}


//***************************************************************************
// int Response::set(char *str)
//
int Response::set(char *str)
{
	extern char *good_strtok(char *, char *);
	char	*temp = strdup(str);

	type = *temp;
	char *token = good_strtok(temp + 1, "\t\r\n");
	if (!token)
	{
		delete temp;
		return 0;
	}
	words[0] = strdup(token);
	for (wordcount = 1; (token = good_strtok((char *) 0, "\t\r\n")); wordcount++)
		words[wordcount] = strdup(token);
	delete temp;
	return wordcount;
}


//***************************************************************************
// char *Response::get_nth(int n)
//
char *Response::get_nth(int n)
{
	if (n >= wordcount || n < 0)
		return (char *) 0;
	else
		return words[n];
}


//***************************************************************************
// void Response::set_nth(int n, char *str)
//
void Response::set_nth(int n, char *str)
{
	if (n >= MAX_WORDS || n < 0)
		return;
	else
	{
		words[n] = strdup(str);
		if (n >= wordcount)
			wordcount = n + 1;
	}
}


//***************************************************************************
// void Response::set_nth(int n, int x)
//
void Response::set_nth(int n, int x)
{
	if (n >= MAX_WORDS || n < 0)
		return;
	else
	{
		char buffer[20];
		sprintf(buffer, "%d", x);
		words[n] = strdup(buffer);
		if (n >= wordcount)
			wordcount = n + 1;
	}
}


