//
// Preferences.h
//
// (c) Copyright 1993, San Diego State University -- College of Sciences
//       (See the COPYRIGHT file for more Copyright information)
//
// This class defines the interface between the options database and the options.
//
#ifndef	_Preferences_h_
#define	_Preferences_h_

class Preferences
{
public:
	//
	// Constructor: It will try to read in all the options
	//
							Preferences();
							~Preferences();

	//
	// The interface to the database consists of get_ and set_ routines.
	// Once an option has been 'set_', it will be written to the database
	// when this class is deleted.
	//
	int						get_remove_children();
	void					set_remove_children(int);
	int						get_popup_bookmarks();
	void					set_popup_bookmarks(int);

	char					*get_mail_filter();
	void					set_mail_filter(char *);
	char					*get_print_filter();
	void					set_print_filter(char *);
	char					*get_play_filter();
	void					set_play_filter(char *);
	char					*get_image_filter();
	void					set_image_filter(char *);
	char					*get_telnet_command();
	void					set_telnet_command(char *);

private:
	//
	// The actual preference items
	//
	int						remove_children;
	int						popup_bookmarks;
	char					*mail_filter;
	char					*print_filter;
	char					*play_filter;
	char					*image_filter;
	char					*telnet_command;
};

#endif	_Preferences_h_
